/* $Id: gdict-about.c,v 1.7 2002/02/03 22:22:55 chyla Exp $ */

/*
 *  Papadimitriou Spiros <spapadim+@cs.cmu.edu>
 *  Mike Hughes <mfh@psilord.com>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 *  GDict About box
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include <gnome.h>

#include "gdict-about.h"


static GtkWidget *gdict_about_new (void)
{
    const gchar *authors[] = {
        "Mike Hughes <mfh@psilord.com>",
        "Spiros Papadimitriou <spapadim+@cs.cmu.edu>",
        "Bradford Hovinen <hovinen@udel.edu>",
        NULL
    };
    gchar *documenters[] = {
	    NULL
    };
    /* Translator credits */
    gchar *translator_credits = _("translator_credits");
    GtkWidget *about;
    
    about = gnome_about_new ("GNOME Dictionary", VERSION,
                             "Copyright 1999 by Mike Hughes",
                             _("Client for MIT dictionary server.\n"
			    "Web: http://gdict.dhs.org/, "
			    "http://www.psilord.com/code/"),
			     (const char **)authors,
			     (const char **)documenters,
			     strcmp (translator_credits, "translator_credits") != 0 ? translator_credits : NULL,
                             NULL);
    gtk_window_set_modal (GTK_WINDOW (about), TRUE);
    return about;
}

void gdict_about (void)
{
    GtkWidget *about = gdict_about_new();

    gtk_widget_show(about);
}

