#ifndef __GDICT_PREF_H_
#define __GDICT_PREF_H_

/* $Id: gdict-pref.h,v 1.14 2005/05/25 15:01:40 vnoel Exp $ */

/*
 *  Papadimitriou Spiros <spapadim@cs.cmu.edu>
 *  Mike Hughes <mfh@psilord.com>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 * 
 *  GDict preferences
 *
 */

#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include "dict.h"

typedef struct _GDictPref {
    /* Server preferences */
    gchar        *server;
    gint          port;
    gchar        *database;     /* Database to search for words and defs */
    gchar        *dfl_strat;    /* Default match strategy */
    gchar        *fontname;
    int          fontsize;
    /* Applet preferences (read only during startup) */
    gboolean      applet_handle;
} GDictPref;

GDictPref *gdict_pref_new (gpointer data);
GConfClient *gdict_get_gconf_client (void);

gboolean gdict_is_gconf_key_writable (GDictWindow *gdict, gchar *key);

int gdict_get_gconf_int (GDictWindow *gdict, gchar *key);
gboolean gdict_get_gconf_bool (GDictWindow *gdict, gchar *key);
gchar* gdict_get_gconf_string (GDictWindow *gdict, gchar *key);
void gdict_set_gconf_int (GDictWindow *gdict, gchar *key, int value);
void gdict_set_gconf_bool (GDictWindow *gdict, gchar *key, gboolean bool);
void gdict_set_gconf_string (GDictWindow *gdict, gchar *key, gchar *string);
void gdict_window_store_position (GDictWindow *gdict);
void gdict_window_restore_position (GDictWindow *gdict);
void gdict_window_store_font (GDictWindow *gdict);

#endif /* __GDICT_PREF_H_ */
