/* $Id: handle.h,v 1.3 2003/04/30 18:25:18 murrayc Exp $ */

/* Copyright 2003 gnome-vfsmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef _LIBGNOMEVFSMM_HANDLE_H
#define _LIBGNOMEVFSMM_HANDLE_H

#include <glibmm.h>

#include <libgnomevfsmm/uri.h>
#include <libgnomevfsmm/file-info.h>
#include <libgnomevfsmm/enums.h>
#include <libgnomevfs/gnome-vfs-ops.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct GnomeVFSHandle GnomeVFSHandle;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gnome
{

namespace Vfs
{

class Handle
{
public:
  Handle();
  virtual ~Handle();
  
  void open(const Glib::ustring& text_uri, GnomeVFSOpenMode open_mode) throw(exception);
  void open(const Glib::RefPtr<const Uri>& uri, GnomeVFSOpenMode open_mode) throw(exception);

  void create(const Glib::ustring& text_uri, GnomeVFSOpenMode open_mode, bool exclusive, guint perm) throw(exception);

  void create(const Glib::RefPtr<const Uri>& uri, GnomeVFSOpenMode open_mode, bool exclusive, guint perm) throw(exception);

  void close() throw(exception);

  GnomeVFSFileSize read(gpointer buffer, GnomeVFSFileSize bytes) throw(exception);

  GnomeVFSFileSize write(gconstpointer buffer, GnomeVFSFileSize bytes) throw(exception);

  void seek(GnomeVFSSeekPosition whence, GnomeVFSFileOffset offset) throw(exception);

  void tell(GnomeVFSFileSize& offset_return) throw(exception);
  
  static Glib::RefPtr<FileInfo> get_file_info(const Glib::ustring& text_uri, FileInfoOptions options = FILE_INFO_DEFAULT) throw(exception);

  Glib::RefPtr<FileInfo> get_file_info(FileInfoOptions options = FILE_INFO_DEFAULT) const throw(exception);

  
  static void truncate(const Glib::ustring& text_uri, GnomeVFSFileSize length) throw(exception);
  void truncate(GnomeVFSFileSize length) throw(exception);

  static void make_directory(const Glib::ustring& text_uri, guint perm) throw(exception);

  static void remove_directory(const Glib::ustring& text_uri) throw(exception);

  void create_symbolic_link(const Glib::RefPtr<const Uri>& uri, const Glib::ustring& target_reference) throw(exception);
  static void unlink(const Glib::ustring& text_uri) throw(exception);

  static void move(const Glib::ustring& old_text_uri, const Glib::ustring& new_text_uri, bool force_replace) throw(exception);
   
  static bool check_same_fs(const Glib::ustring& source, const Glib::ustring& target) throw(exception);

  bool gnome_vfs_uri_exists(const Glib::RefPtr<const Uri>& uri) throw(exception);

  static void set_file_info(const Glib::ustring& text_uri, const Glib::RefPtr<const FileInfo>& info, GnomeVFSSetFileInfoMask mask) throw(exception);

  //TODO: Use a SigC::Slot.
  void monitor_add(GnomeVFSMonitorHandle **handle, const Glib::ustring& text_uri, GnomeVFSMonitorType monitor_type, GnomeVFSMonitorCallback callback, gpointer user_data) throw(exception);

  static void monitor_cancel(GnomeVFSMonitorHandle *handle) throw(exception);

  void file_control(const Glib::ustring& operation, gpointer operation_data) throw(exception);

  
  GnomeVFSHandle* gobj();
  const GnomeVFSHandle* gobj() const;  


protected:

  static void handle_result(GnomeVFSResult result) throw(exception);
  
  GnomeVFSHandle* gobj_;
};

} // namespace Vfs
} // namespace Gnome




#endif /* _LIBGNOMEVFSMM_HANDLE_H */

