
/*  A Bison parser, made from parse.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	CLASS	257
#define	FROM	258
#define	CONST	259
#define	VOID	260
#define	STRUCT	261
#define	UNION	262
#define	ENUM	263
#define	THREEDOTS	264
#define	SIGNED	265
#define	UNSIGNED	266
#define	LONG	267
#define	SHORT	268
#define	INT	269
#define	FLOAT	270
#define	DOUBLE	271
#define	CHAR	272
#define	TOKEN	273
#define	NUMBER	274
#define	TYPETOKEN	275
#define	ARRAY_DIM	276
#define	SINGLE_CHAR	277
#define	CCODE	278
#define	HTCODE	279
#define	PHCODE	280
#define	HCODE	281
#define	ACODE	282
#define	ATCODE	283
#define	STRING	284
#define	PUBLIC	285
#define	PRIVATE	286
#define	PROTECTED	287
#define	CLASSWIDE	288
#define	PROPERTY	289
#define	ARGUMENT	290
#define	VIRTUAL	291
#define	SIGNAL	292
#define	OVERRIDE	293
#define	NICK	294
#define	BLURB	295
#define	MAXIMUM	296
#define	MINIMUM	297
#define	DEFAULT_VALUE	298
#define	ERROR	299
#define	FLAGS	300
#define	TYPE	301
#define	FLAGS_TYPE	302
#define	ENUM_TYPE	303
#define	PARAM_TYPE	304
#define	BOXED_TYPE	305
#define	OBJECT_TYPE	306

#line 22 "parse.y"


#include "config.h"
#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "treefuncs.h"
#include "main.h"
#include "util.h"

/* FIXME: add gettext support */
#define _(x) (x)
	
GList *nodes = NULL;

static GList *class_nodes = NULL;
Node *class = NULL;
GList *enums = NULL;
static GList *enum_vals = NULL;
static GList *flag_vals = NULL;
static GList *error_vals = NULL;

static char *chunk_size = NULL;
static char *bonobo_object_class = NULL;
static GList *interfaces = NULL;
static GList *typestack = NULL;
static GList *funcargs = NULL;
static GList *checks = NULL;
static int has_self = FALSE;
static int vararg = FALSE;
static Method *last_added_method = NULL;

/* destructor and initializer for variables */
static gboolean destructor_unref = FALSE;
static char *destructor = NULL;
static int destructor_line = 0;
static gboolean destructor_simple = TRUE;
static char *initializer = NULL;
static int initializer_line = 0;

static char *onerror = NULL;
static char *defreturn = NULL;

static GList *gtktypes = NULL;

static Property *property = NULL;

/* this can be a global as we will only do one function at a time
   anyway */
static int the_scope = NO_SCOPE;

void free(void *ptr);
int yylex(void);

extern int ccode_line;
extern int line_no;

extern char *yytext;

static void
yyerror(char *str)
{
	char *out=NULL;
	char *p;
	
	if(strcmp(yytext,"\n")==0) {
		out=g_strconcat("Error: ",str," before newline",NULL);
	} else if(yytext[0]=='\0') {
		out=g_strconcat("Error: ", str, " at end of input", NULL);
	} else {
		char *tmp = g_strdup(yytext);
		while((p=strchr(tmp, '\n')))
			*p='.';

		out=g_strconcat("Error: ", str, " before '", tmp, "'", NULL);
		g_free(tmp);
	}

	fprintf(stderr, "%s:%d: %s\n", filename, line_no, out);
	g_free(out);
	
	exit(1);
}

static Type *
pop_type(void)
{
	Type *type = typestack->data;
	typestack = g_list_remove(typestack,typestack->data);
	return type;
}

static void
push_variable (char *name, int scope, int line_no, char *postfix)
{
	Node *var;
	Type *type = pop_type ();

	type->postfix = postfix;
	
	var = node_new (VARIABLE_NODE,
			"scope", scope,
			"vtype:steal", type,
			"id:steal", name,
			"line_no", line_no,
			"destructor_unref", destructor_unref,
			"destructor:steal", destructor,
			"destructor_line", destructor_line,
			"destructor_simple", destructor_simple,
			"initializer:steal", initializer,
			"initializer_line", initializer_line,
			NULL);
	class_nodes = g_list_append(class_nodes, var);
}

static void
push_function (int scope, int method, char *oid, char *id,
	       GString *cbuf, int line_no, int ccode_line,
	       gboolean vararg, GList *flags)
{
	Node *node;
	Type *type;
	char *c_cbuf;

	g_assert(scope != CLASS_SCOPE);
       
	if(method == INIT_METHOD || method == CLASS_INIT_METHOD) {
		type = (Type *)node_new (TYPE_NODE,
					 "name", "void",
					 NULL);
	} else {
		type = pop_type();
	}
	
	/* a complicated and ugly test to figure out if we have
	   the wrong number of types for a signal */
	if((method == SIGNAL_FIRST_METHOD ||
	    method == SIGNAL_LAST_METHOD) &&
	   g_list_length(gtktypes) != g_list_length(funcargs) &&
	   !(g_list_length(funcargs) == 1 &&
	     g_list_length(gtktypes) == 2 &&
	     strcmp(gtktypes->next->data, "NONE")==0)) {
		error_print(GOB_WARN, line_no,
			    _("The number of GTK arguments and "
			      "function arguments for a signal "
			      "don't seem to match"));
	}
	if(g_list_length(gtktypes) > 2) {
		GList *li;
		for(li = gtktypes->next; li; li = li->next) {
			if(strcmp(li->data, "NONE")==0) {
				error_print(GOB_ERROR, line_no,
					    _("NONE can only appear in an "
					      "argument list by itself"));
			}
		}
	}
	if(cbuf) {
		char *p;
		c_cbuf = p = cbuf->str;
		while(p && *p && (*p==' ' || *p=='\t' || *p=='\n' || *p=='\r'))
			p++;
		if(!p || !*p)
			c_cbuf = NULL;
	} else
		c_cbuf = NULL;

	node = node_new (METHOD_NODE,
			 "scope", scope,
			 "method", method,
			 "mtype:steal", type,
			 "otype:steal", oid,
			 "gtktypes:steal", gtktypes,
			 "flags:steal", flags,
			 "id:steal", id,
			 "args:steal", funcargs,
			 "onerror:steal", onerror,
			 "defreturn:steal", defreturn,
			 "cbuf:steal", c_cbuf,
			 "line_no", line_no,
			 "ccode_line", ccode_line,
			 "vararg", vararg,
			 "unique_id", method_unique_id++,
			 NULL);

	last_added_method = (Method *)node;

	if(cbuf)
		g_string_free(cbuf,
			      /*only free segment if we haven't passed it
				above */
			      c_cbuf?FALSE:TRUE);
	gtktypes = NULL;
	funcargs = NULL;

	onerror = NULL;
	defreturn = NULL;

	class_nodes = g_list_append(class_nodes, node);
}

static void
free_all_global_state(void)
{
	g_free(onerror);
	onerror = NULL;
	g_free(defreturn);
	defreturn = NULL;

	g_free(chunk_size);
	chunk_size = NULL;
	
	g_list_foreach(gtktypes, (GFunc)g_free, NULL);
	g_list_free(gtktypes);
	gtktypes = NULL;

	node_list_free (funcargs);
	funcargs = NULL;
}

static void
push_funcarg(char *name, char *postfix)
{
	Node *node;
	Type *type = pop_type();

	type->postfix = postfix;
	
	node = node_new (FUNCARG_NODE,
			 "atype:steal", type,
			 "name:steal", name,
			 "checks:steal", checks,
			 NULL);
	checks = NULL;
	
	funcargs = g_list_append(funcargs, node);
}

static void
push_init_arg(char *name, int is_class)
{
	Node *node;
	Node *type;
	char *tn;
	
	if(is_class)
		tn = g_strconcat(((Class *)class)->otype,":Class",NULL);
	else
		tn = g_strdup(((Class *)class)->otype);

	type = node_new (TYPE_NODE,
			 "name:steal", tn,
			 "pointer", "*",
			 NULL);
	node = node_new (FUNCARG_NODE,
			 "atype:steal", (Type *)type,
			 "name:steal", name,
			 NULL);
	funcargs = g_list_prepend(funcargs, node);
}

static void
push_self(char *id, gboolean constant)
{
	Node *node;
	Node *type;
	GList *ch = NULL;
	type = node_new (TYPE_NODE,
			 "name", ((Class *)class)->otype,
			 "pointer", constant ? "const *" : "*",
			 NULL);
	ch = g_list_append (ch, node_new (CHECK_NODE,
					  "chtype", NULL_CHECK,
					  NULL));
	ch = g_list_append (ch, node_new (CHECK_NODE,
					  "chtype", TYPE_CHECK,
					  NULL));
	node = node_new (FUNCARG_NODE,
			 "atype:steal", (Type *)type,
			 "name:steal", id,
			 "checks:steal", ch,
			 NULL);
	funcargs = g_list_prepend(funcargs, node);
}

static Variable *
find_var_or_die(const char *id, int line)
{
	GList *li;

	for(li = class_nodes; li != NULL; li = li->next) {
		Variable *var;
		Node *node = li->data;
		if(node->type != VARIABLE_NODE)
			continue;
		var = li->data;
		if(strcmp(var->id, id)==0)
			return var;
	}

	error_printf(GOB_ERROR, line, _("Variable %s not defined here"), id);

	g_assert_not_reached();
	return NULL;
}

static gboolean
set_return_value(char *type, char *val)
{
	if(strcmp(type, "onerror")==0) {
		if(!onerror) {
			onerror = val;
			return TRUE;
		} else
			return FALSE;
	} else if(strcmp(type, "defreturn")==0) {
		if(!defreturn) {
			defreturn = val;
			return TRUE;
		} else
			return FALSE;
	}
	return FALSE;
}

static void
export_accessors (const char *var_name,
		  gboolean do_get,
		  int get_lineno,
		  gboolean do_set,
		  int set_lineno,
		  Type *type,
		  const char *gtktype,
		  int lineno)
{	
	Type *the_type;

	if (type != NULL)
		the_type = (Type *)node_copy ((Node *)type);
	else
		the_type = get_tree_type (gtktype, TRUE);

	if (the_type == NULL) {
		error_print (GOB_ERROR, line_no,
			     _("Cannot determine type of property or argument"));
		return;
	}

	if (do_get) {
		char *get_id = g_strdup_printf ("get_%s", var_name);
		GString *get_cbuf = g_string_new (NULL);
		Node *node1 = node_new (TYPE_NODE,
					"name", the_type->name,
					"pointer", the_type->pointer,
					"postfix", the_type->postfix,
					NULL);
		Node *node3 = node_new (TYPE_NODE,
					"name", class->class.otype,
					"pointer", "*",
					NULL);

		g_string_sprintf (get_cbuf,
				  "\t%s%s val; "
				  "g_object_get (G_OBJECT (self), \"%s\", "
				  "&val, NULL); "
				  "return val;\n",
				  the_type->name, 
				  the_type->pointer ? the_type->pointer : "",
				  var_name);
		
		typestack = g_list_prepend (typestack, node1);
		typestack = g_list_prepend (typestack, node3);
		
		push_funcarg ("self", FALSE);
		
		push_function (PUBLIC_SCOPE, REGULAR_METHOD, NULL,
			       get_id, get_cbuf, get_lineno,
			       lineno, FALSE, NULL);
	}
	
	if (do_set) {
		char *set_id = g_strdup_printf ("set_%s", var_name);
		GString *set_cbuf = g_string_new (NULL);
		Node *node1 = node_new (TYPE_NODE, 
					"name", the_type->name,
					"pointer", the_type->pointer,
					"postfix", the_type->postfix,
					NULL);
		Node *node2 = node_new (TYPE_NODE, 
					"name", "void",
					NULL);
		Node *node3 = node_new (TYPE_NODE, 
					"name", class->class.otype,
					"pointer", "*",
					NULL);

		g_string_sprintf (set_cbuf,
				  "\tg_object_set (G_OBJECT (self), "
				  "\"%s\", val, NULL);\n",
				  var_name);

		typestack = g_list_prepend (typestack, node2);
		typestack = g_list_prepend (typestack, node1);
		typestack = g_list_prepend (typestack, node3);
		
		push_funcarg ("self", FALSE);
		push_funcarg ("val", FALSE);
	
		typestack = g_list_prepend (typestack, node2);
		push_function (PUBLIC_SCOPE, REGULAR_METHOD, NULL,
			       set_id, set_cbuf, set_lineno,
			       lineno, FALSE, NULL);
	}

	node_free ((Node *)the_type);
}

static void
property_link_and_export (Node *node)
{
	Property *prop = (Property *)node;

	if (prop->link) {
		const char *root;
		char *get = NULL, *set = NULL;
		Variable *var;

		if (prop->set != NULL ||
		    prop->get != NULL) {	
			error_print (GOB_ERROR, prop->line_no,
				     _("Property linking requested, but "
				       "getters and setters exist"));
		}

		var = find_var_or_die (prop->name, prop->line_no);
		if(var->scope == PRIVATE_SCOPE) {
			root = "self->_priv";
		} else if (var->scope == CLASS_SCOPE) {
			root = "SELF_GET_CLASS(self)";
			if (no_self_alias)
				error_print (GOB_ERROR, prop->line_no,
					     _("Self aliases needed when autolinking to a classwide member"));
		} else {
			root = "self";
		}

		if (strcmp (prop->gtktype, "STRING") == 0) {
			set = g_strdup_printf("{ char *old = %s->%s; "
					      "%s->%s = g_value_dup_string (VAL); g_free (old); }",
					      root, prop->name,
					      root, prop->name);
			get = g_strdup_printf("g_value_set_string (VAL, %s->%s);",
					      root, prop->name);
		} else if (strcmp (prop->gtktype, "OBJECT") == 0) {
			set = g_strdup_printf("{ GtkObject *___old = (GtkObject *)%s->%s; "
					      "GtkObject *___new = (GtkObject *)gtk_value_get_object (VAL); "
					      "if (___new != NULL) { "
					        "gtk_object_ref (GTK_OBJECT (___new)); "
					        "%s->%s = GTK_OBJECT (___new); "
					      "} else { "
					        "%s->%s = NULL; "
					      "} "
					      "if (___old != NULL) { "
					        "gtk_object_unref (GTK_OBJECT (___old)); "
					      "} "
					      "}",
					      root, prop->name,
					      root, prop->name,
					      root, prop->name);
			get = g_strdup_printf("g_value_set_object (VAL, %s->%s);",
					      root, prop->name);
		} else if (strcmp (prop->gtktype, "BOXED") == 0) {
			if (prop->extra_gtktype == NULL) {
				error_print (GOB_ERROR, prop->line_no,
					     _("Property linking requested for BOXED, but "
					       "boxed_type not set"));
			}
			set = g_strdup_printf("{ gpointer ___old = (gpointer)%s->%s; "
					      "gpointer ___new = (gpointer)gtk_value_get_boxed (VAL); "
					      "if (___new != ___old) { "
					        "if (___old != NULL) g_boxed_free (%s, ___old); "
					        "if (___new != NULL) %s->%s = g_boxed_copy (%s, ___new); "
					        "else %s->%s = NULL;"
					      "} "
					      "}",
					      root, prop->name,
					      prop->extra_gtktype,
					      root, prop->name,
					      prop->extra_gtktype,
					      root, prop->name);
			get = g_strdup_printf("g_value_set_object (VAL, %s->%s);",
					      root, prop->name);
		} else {
			char *set_func;
			char *get_func;
			set_func = g_strdup_printf ("g_value_set_%s", prop->gtktype);
			g_strdown (set_func);
			get_func = g_strdup_printf ("g_value_get_%s", prop->gtktype);
			g_strdown (get_func);

			set = g_strdup_printf("%s->%s = %s (VAL);",
					      root, prop->name,
					      get_func);
			get = g_strdup_printf("%s (VAL, %s->%s);",
					      set_func,
					      root, prop->name);

			g_free (get_func);
			g_free (set_func);
		}

		node_set (node,
			  "get:steal", get,
			  "get_line", prop->line_no,
			  "set:steal", set,
			  "set_line", prop->line_no,
			  NULL);
	}

	if (prop->export) {
		export_accessors (prop->name,
				  prop->get != NULL, prop->get_line,
				  prop->set != NULL,  prop->set_line,
				  prop->ptype,
				  prop->gtktype,
				  prop->line_no);
	} 
}


static char *
debool (char *s)
{
	if (strcmp (s, "BOOL") == 0) {
		error_print (GOB_WARN, line_no,
			    _("BOOL type is deprecated, please use BOOLEAN"));
		g_free (s);
		return g_strdup ("BOOLEAN");
	} else {
		return s;
	}
}

static void
ensure_property (void)
{
	if (property == NULL)
		property = (Property *)node_new (PROPERTY_NODE, NULL);
}


#line 576 "parse.y"
typedef union {
	char *id;
	GString *cbuf;
	GList *list;
	int line;
	int sigtype;
} YYSTYPE;
#ifndef YYDEBUG
#define YYDEBUG 1
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		393
#define	YYFLAG		-32768
#define	YYNTBASE	66

#define YYTRANSLATE(x) ((unsigned)(x) <= 306 ? yytranslate[x] : 118)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    64,     2,     2,     2,     2,     2,     2,    55,
    56,    61,     2,    59,    65,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,    57,    63,
    58,    62,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    53,    60,    54,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
    37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
    47,    48,    49,    50,    51,    52
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     4,     7,    10,    12,    14,    16,    18,    20,    22,
    24,    27,    30,    33,    36,    38,    40,    42,    44,    49,
    53,    59,    60,    66,    72,    78,    81,    83,    85,    88,
    92,    94,    96,    98,   100,   102,   104,   106,   108,   111,
   115,   118,   122,   125,   128,   130,   132,   133,   139,   146,
   159,   169,   176,   180,   181,   193,   202,   208,   212,   213,
   217,   219,   221,   226,   228,   230,   234,   238,   242,   246,
   250,   254,   258,   262,   266,   270,   274,   278,   280,   286,
   288,   292,   293,   297,   299,   302,   304,   306,   308,   311,
   314,   317,   321,   325,   328,   331,   334,   336,   339,   341,
   344,   346,   348,   350,   352,   354,   356,   358,   360,   362,
   364,   366,   368,   370,   373,   376,   380,   383,   385,   389,
   393,   396,   398,   403,   407,   409,   412,   414,   425,   437,
   447,   457,   466,   478,   487,   493,   496,   501,   502,   504,
   507,   509,   511,   514,   517,   521,   526,   531,   533,   537,
   539,   543,   545,   548,   552,   559,   567,   570,   572,   574,
   577,   580,   584,   588,   592,   596,   604,   613,   617,   619,
   623,   625,   633,   642,   646,   648,   656,   665,   669,   671,
   673,   676,   678
};

static const short yyrhs[] = {    68,
    69,    68,     0,    69,    68,     0,    68,    69,     0,    69,
     0,    24,     0,    27,     0,    25,     0,    26,     0,    28,
     0,    29,     0,    68,    67,     0,    68,   110,     0,    68,
   113,     0,    68,   115,     0,    67,     0,   110,     0,   113,
     0,   115,     0,    70,    53,    72,    54,     0,    70,    53,
    54,     0,     3,    21,     4,    21,    71,     0,     0,    55,
    19,    19,    56,    71,     0,    55,    19,    21,    56,    71,
     0,    55,    19,    20,    56,    71,     0,    72,    73,     0,
    73,     0,   101,     0,    19,   101,     0,    19,    21,   101,
     0,    78,     0,    79,     0,    81,     0,    57,     0,    31,
     0,    32,     0,    33,     0,    34,     0,    19,    19,     0,
    19,    53,    24,     0,    58,   117,     0,    58,    53,    24,
     0,    75,    76,     0,    76,    75,     0,    76,     0,    75,
     0,     0,    74,    90,    19,    77,    57,     0,    74,    90,
    19,    22,    77,    57,     0,    36,    88,    87,    19,    80,
    19,    53,    24,    19,    53,    24,    57,     0,    36,    88,
    87,    19,    80,    19,    53,    24,    57,     0,    36,    88,
    87,    19,    80,    19,     0,    55,    19,    56,     0,     0,
    35,    19,    19,    82,    19,    53,    24,    19,    53,    24,
    57,     0,    35,    19,    19,    82,    19,    53,    24,    57,
     0,    35,    19,    19,    82,    57,     0,    55,    83,    56,
     0,     0,    83,    59,    86,     0,    86,     0,    30,     0,
    19,    55,    30,    56,     0,   117,     0,    84,     0,    40,
    58,    84,     0,    41,    58,    84,     0,    42,    58,   117,
     0,    43,    58,   117,     0,    44,    58,    85,     0,    46,
    58,    89,     0,    47,    58,    90,     0,    48,    58,    19,
     0,    49,    58,    19,     0,    50,    58,    19,     0,    51,
    58,    19,     0,    52,    58,    19,     0,    19,     0,    19,
    55,    19,    90,    56,     0,    19,     0,    55,    89,    56,
     0,     0,    19,    60,    89,     0,    19,     0,    91,    95,
     0,    91,     0,    92,     0,    19,     0,     5,    19,     0,
    19,     5,     0,    94,    19,     0,     5,    94,    19,     0,
    94,    19,     5,     0,    93,    92,     0,    21,    92,     0,
     5,    92,     0,    21,     0,    21,     5,     0,    93,     0,
    93,     5,     0,     6,     0,    18,     0,    14,     0,    15,
     0,    13,     0,    16,     0,    17,     0,    11,     0,    12,
     0,     7,     0,     8,     0,     9,     0,    61,     0,    61,
     5,     0,    61,    95,     0,    61,     5,    95,     0,    19,
    98,     0,    98,     0,    74,    19,    98,     0,    19,    74,
    98,     0,    74,    98,     0,    96,     0,    19,    55,    99,
    56,     0,    99,    59,    19,     0,    19,     0,    53,    24,
     0,    57,     0,    38,    88,    97,    90,    19,    55,   104,
    56,   102,   100,     0,    74,    38,    88,    96,    90,    19,
    55,   104,    56,   102,   100,     0,    37,    74,    90,    19,
    55,   104,    56,   102,   100,     0,    74,    37,    90,    19,
    55,   104,    56,   102,   100,     0,    37,    90,    19,    55,
   104,    56,   102,   100,     0,    39,    55,    21,    56,    90,
    19,    55,   104,    56,   102,   100,     0,    74,    90,    19,
    55,   104,    56,   102,   100,     0,    19,    55,    19,    56,
   100,     0,    19,   103,     0,    19,   103,    19,   103,     0,
     0,   117,     0,    53,    24,     0,     6,     0,    19,     0,
    19,     5,     0,     5,    19,     0,    19,    59,   105,     0,
    19,     5,    59,   105,     0,     5,    19,    59,   105,     0,
   105,     0,   106,    59,    10,     0,   106,     0,   106,    59,
   107,     0,   107,     0,    90,    19,     0,    90,    19,    22,
     0,    90,    19,    55,    19,   108,    56,     0,    90,    19,
    22,    55,    19,   108,    56,     0,   108,   109,     0,   109,
     0,    19,     0,    62,   117,     0,    63,   117,     0,    62,
    58,   117,     0,    63,    58,   117,     0,    58,    58,   117,
     0,    64,    58,   117,     0,     9,    19,    53,   111,    54,
    21,    57,     0,     9,    19,    53,   111,    59,    54,    21,
    57,     0,   111,    59,   112,     0,   112,     0,    19,    58,
   117,     0,    19,     0,    46,    19,    53,   114,    54,    21,
    57,     0,    46,    19,    53,   114,    59,    54,    21,    57,
     0,   114,    59,    19,     0,    19,     0,    45,    19,    53,
   116,    54,    21,    57,     0,    45,    19,    53,   116,    59,
    54,    21,    57,     0,   116,    59,    19,     0,    19,     0,
    20,     0,    65,    20,     0,    23,     0,    19,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   597,   598,   599,   600,   603,   612,   621,   630,   639,   648,
   659,   660,   661,   662,   663,   664,   665,   666,   669,   674,
   681,   695,   696,   708,   717,   731,   732,   735,   736,   745,
   757,   758,   759,   760,   763,   764,   765,   766,   769,   789,
   813,   817,   825,   826,   827,   828,   829,   835,   838,   843,
   911,   965,  1053,  1061,  1066,  1114,  1150,  1166,  1167,  1170,
  1171,  1174,  1175,  1187,  1188,  1191,  1197,  1203,  1209,  1215,
  1221,  1227,  1234,  1240,  1246,  1252,  1258,  1264,  1284,  1293,
  1299,  1300,  1303,  1306,  1312,  1319,  1328,  1331,  1334,  1338,
  1342,  1346,  1351,  1359,  1363,  1368,  1372,  1375,  1379,  1382,
  1387,  1388,  1389,  1390,  1391,  1392,  1393,  1394,  1395,  1398,
  1399,  1400,  1403,  1404,  1405,  1409,  1416,  1428,  1434,  1446,
  1458,  1461,  1467,  1472,  1475,  1480,  1481,  1485,  1501,  1517,
  1533,  1549,  1560,  1566,  1576,  1599,  1610,  1629,  1635,  1636,
  1642,  1643,  1654,  1665,  1676,  1686,  1696,  1706,  1709,  1710,
  1713,  1714,  1717,  1720,  1723,  1731,  1741,  1742,  1745,  1762,
  1769,  1776,  1783,  1790,  1797,  1806,  1815,  1826,  1827,  1830,
  1850,  1860,  1869,  1880,  1883,  1888,  1897,  1908,  1911,  1917,
  1918,  1922,  1923
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","CLASS",
"FROM","CONST","VOID","STRUCT","UNION","ENUM","THREEDOTS","SIGNED","UNSIGNED",
"LONG","SHORT","INT","FLOAT","DOUBLE","CHAR","TOKEN","NUMBER","TYPETOKEN","ARRAY_DIM",
"SINGLE_CHAR","CCODE","HTCODE","PHCODE","HCODE","ACODE","ATCODE","STRING","PUBLIC",
"PRIVATE","PROTECTED","CLASSWIDE","PROPERTY","ARGUMENT","VIRTUAL","SIGNAL","OVERRIDE",
"NICK","BLURB","MAXIMUM","MINIMUM","DEFAULT_VALUE","ERROR","FLAGS","TYPE","FLAGS_TYPE",
"ENUM_TYPE","PARAM_TYPE","BOXED_TYPE","OBJECT_TYPE","'{'","'}'","'('","')'",
"';'","'='","','","'|'","'*'","'>'","'<'","'!'","'-'","prog","ccode","ccodes",
"class","classdec","classflags","classcode","thing","scope","destructor","initializer",
"varoptions","variable","argument","export","property","param_spec","param_spec_list",
"string","anyval","param_spec_value","argtype","flags","flaglist","type","specifier_list",
"spec_list","specifier","strunionenum","pointer","simplesigtype","fullsigtype",
"sigtype","tokenlist","codenocode","method","returnvals","retcode","funcargs",
"arglist","arglist1","arg","checklist","check","enumcode","enumvals","enumval",
"flagcode","flagvals","errorcode","errorvals","numtok", NULL
};
#endif

static const short yyr1[] = {     0,
    66,    66,    66,    66,    67,    67,    67,    67,    67,    67,
    68,    68,    68,    68,    68,    68,    68,    68,    69,    69,
    70,    71,    71,    71,    71,    72,    72,    73,    73,    73,
    73,    73,    73,    73,    74,    74,    74,    74,    75,    75,
    76,    76,    77,    77,    77,    77,    77,    78,    78,    79,
    79,    79,    80,    80,    81,    81,    81,    82,    82,    83,
    83,    84,    84,    85,    85,    86,    86,    86,    86,    86,
    86,    86,    86,    86,    86,    86,    86,    86,    87,    87,
    88,    88,    89,    89,    90,    90,    91,    91,    91,    91,
    91,    91,    91,    92,    92,    92,    92,    92,    92,    92,
    93,    93,    93,    93,    93,    93,    93,    93,    93,    94,
    94,    94,    95,    95,    95,    95,    96,    96,    97,    97,
    97,    97,    98,    99,    99,   100,   100,   101,   101,   101,
   101,   101,   101,   101,   101,   102,   102,   102,   103,   103,
   104,   104,   104,   104,   104,   104,   104,   104,   105,   105,
   106,   106,   107,   107,   107,   107,   108,   108,   109,   109,
   109,   109,   109,   109,   109,   110,   110,   111,   111,   112,
   112,   113,   113,   114,   114,   115,   115,   116,   116,   117,
   117,   117,   117
};

static const short yyr2[] = {     0,
     3,     2,     2,     1,     1,     1,     1,     1,     1,     1,
     2,     2,     2,     2,     1,     1,     1,     1,     4,     3,
     5,     0,     5,     5,     5,     2,     1,     1,     2,     3,
     1,     1,     1,     1,     1,     1,     1,     1,     2,     3,
     2,     3,     2,     2,     1,     1,     0,     5,     6,    12,
     9,     6,     3,     0,    11,     8,     5,     3,     0,     3,
     1,     1,     4,     1,     1,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     1,     5,     1,
     3,     0,     3,     1,     2,     1,     1,     1,     2,     2,
     2,     3,     3,     2,     2,     2,     1,     2,     1,     2,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     2,     2,     3,     2,     1,     3,     3,
     2,     1,     4,     3,     1,     2,     1,    10,    11,     9,
     9,     8,    11,     8,     5,     2,     4,     0,     1,     2,
     1,     1,     2,     2,     3,     4,     4,     1,     3,     1,
     3,     1,     2,     3,     6,     7,     2,     1,     1,     2,
     2,     3,     3,     3,     3,     7,     8,     3,     1,     3,
     1,     7,     8,     3,     1,     7,     8,     3,     1,     1,
     2,     1,     1
};

static const short yydefact[] = {     0,
     0,     0,     5,     7,     8,     6,     9,    10,     0,     0,
    15,     0,     4,     0,    16,    17,    18,     0,     0,     0,
     0,    11,     3,    12,    13,    14,     2,     0,     0,     0,
     0,     0,     1,     0,    35,    36,    37,    38,     0,    82,
     0,    82,     0,    20,    34,     0,    27,     0,    31,    32,
    33,    28,    22,   171,     0,   169,   179,     0,   175,     0,
     0,     0,     0,     0,    29,     0,     0,     0,     0,   101,
   110,   111,   112,   108,   109,   105,   103,   104,   106,   107,
   102,    88,    97,     0,     0,    86,    87,    99,     0,     0,
     0,    19,    26,     0,    82,     0,     0,    21,     0,     0,
     0,     0,     0,     0,     0,    30,     0,     0,    59,    84,
     0,    80,     0,     0,    89,    96,     0,    90,    98,    95,
     0,     0,   113,    85,   100,    94,    91,     0,     0,   122,
     0,   118,     0,     0,     0,    47,     0,   183,   180,   182,
     0,   170,     0,     0,   168,     0,   178,     0,     0,   174,
     0,     0,     0,     0,     0,     0,    81,     0,    54,    92,
     0,     0,   114,   115,    93,     0,     0,     0,   117,     0,
   121,     0,     0,     0,     0,     0,     0,    47,     0,     0,
    46,    45,     0,     0,     0,     0,   181,   166,     0,   176,
     0,   172,     0,     0,   127,   135,    78,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    61,     0,    57,    83,     0,     0,     0,     0,     0,   101,
    88,     0,     0,   148,   150,   152,   116,   125,     0,   120,
   119,     0,     0,     0,     0,    39,     0,     0,     0,     0,
    41,    43,    44,    48,    22,    22,    22,   167,   177,   173,
   126,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    58,     0,     0,     0,     0,    52,     0,
    89,    90,     0,   153,   138,     0,   123,     0,     0,     0,
     0,     0,    40,    49,   138,    42,    23,    25,    24,     0,
    62,    66,    67,    68,    69,   183,    65,    70,    64,    71,
    72,    73,    74,    75,    76,    77,    60,     0,    79,    53,
     0,   138,     0,     0,   145,   154,     0,     0,     0,   149,
   151,   124,     0,     0,   138,     0,     0,     0,     0,    56,
     0,     0,   147,   146,     0,     0,     0,   136,   139,   132,
   138,     0,     0,     0,   134,     0,     0,     0,    51,   130,
     0,   159,     0,     0,     0,     0,     0,   158,   140,     0,
     0,   138,   131,   138,    63,     0,     0,     0,     0,     0,
   160,     0,   161,     0,   155,   157,   137,   128,     0,     0,
    55,     0,   156,   164,   162,   163,   165,   133,   129,    50,
     0,     0,     0
};

static const short yydefgoto[] = {   391,
    11,    12,    13,    14,    98,    46,    47,    48,   181,   182,
   183,    49,    50,   217,    51,   155,   210,   292,   298,   211,
   113,    68,   111,   222,    86,    87,    88,    89,   124,   130,
   131,   132,   229,   196,    52,   319,   338,   223,   224,   225,
   226,   357,   358,    15,    55,    56,    16,    60,    17,    58,
   339
};

static const short yypact[] = {   168,
    18,    21,-32768,-32768,-32768,-32768,-32768,-32768,    41,    89,
-32768,   168,   213,    56,-32768,-32768,-32768,   138,    77,   109,
   110,-32768,   213,-32768,-32768,-32768,   213,   167,   123,   153,
   155,   189,   213,   230,-32768,-32768,-32768,-32768,   190,   156,
   309,   156,   161,-32768,-32768,   196,-32768,   275,-32768,-32768,
-32768,-32768,   162,   165,   -17,-32768,-32768,   -13,-32768,    91,
   164,   300,   201,   275,-32768,   206,   207,   217,   356,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,   247,   424,   373,   235,   199,-32768,   438,   238,   443,
   244,-32768,-32768,   373,   156,   253,   255,-32768,     6,   245,
    -1,   256,    26,   258,    73,-32768,   222,   276,   274,   242,
   254,   280,   292,   452,-32768,-32768,   317,-32768,   452,-32768,
   340,   311,     2,-32768,   452,-32768,   371,   157,   364,-32768,
   373,-32768,   337,   381,   391,    88,   224,-32768,-32768,-32768,
   397,-32768,   370,   410,-32768,   375,-32768,   412,   377,-32768,
   425,   -34,   392,   257,    -7,   207,-32768,   429,   405,-32768,
   406,   390,   199,-32768,-32768,   416,   453,   459,-32768,    14,
-32768,   460,   373,   426,    14,   373,    13,     9,   390,    59,
   422,   463,   427,   430,   431,   432,-32768,-32768,   428,-32768,
   433,-32768,   434,   465,-32768,-32768,-32768,   435,   436,   437,
   439,   440,   441,   442,   444,   445,   446,   447,   448,   122,
-32768,   454,-32768,-32768,   373,   464,   473,   390,   407,   455,
     5,   477,   456,-32768,   449,-32768,-32768,-32768,   124,-32768,
-32768,   458,   482,   390,   490,-32768,   486,   457,   461,   491,
-32768,-32768,-32768,-32768,   162,   162,   162,-32768,-32768,-32768,
-32768,    84,    84,     6,     6,    64,   207,   373,   497,   499,
   500,   501,   502,-32768,   257,   498,   467,   468,   472,   470,
   126,   128,   373,    63,   508,   339,-32768,   509,   390,   474,
   475,   478,-32768,-32768,   508,-32768,-32768,-32768,-32768,   479,
-32768,-32768,-32768,-32768,-32768,   479,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,    -2,-32768,-32768,
   506,   508,   373,   373,-32768,   480,   513,    70,   -34,-32768,
-32768,-32768,   481,   390,   508,   390,   -34,   510,   483,-32768,
    16,   -34,-32768,-32768,   519,   106,   515,   522,-32768,-32768,
   508,   487,   -34,   488,-32768,   489,   518,   493,-32768,-32768,
   106,-32768,   492,    76,    82,   494,    57,-32768,-32768,    70,
   -34,   508,-32768,   508,-32768,   496,   523,   103,     6,     6,
-32768,     6,-32768,     6,-32768,-32768,-32768,-32768,   -34,   -34,
-32768,   503,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
   548,   549,-32768
};

static const short yypgoto[] = {-32768,
    99,   125,   539,-32768,     1,-32768,   511,   -28,   372,   374,
   378,-32768,-32768,-32768,-32768,-32768,-32768,   -46,-32768,   293,
-32768,   -27,  -151,   -40,-32768,   -67,-32768,   -66,  -112,   450,
-32768,   -98,-32768,  -305,   -14,  -276,   202,  -175,  -216,-32768,
   283,   210,  -240,   104,-32768,   462,   127,-32768,   146,-32768,
   -99
};


#define	YYLAST		585


static const short yytable[] = {   142,
    85,   116,   117,   239,   214,    64,   163,    96,   327,   272,
   164,   212,    84,   340,    90,   120,   329,    54,   194,    65,
   126,   345,   195,   108,   138,   139,   350,   177,   140,   169,
   171,   236,   166,    64,   348,   332,   100,   363,    18,    19,
   102,   101,   270,   121,   147,   103,   116,   106,   343,   213,
   227,   116,   144,   134,   330,   378,   315,   116,   281,    20,
  -142,   129,   123,   273,   361,   237,   180,   135,   167,   230,
   141,   231,   349,   388,   389,   352,   169,   138,   139,   148,
   241,   140,   296,   139,   316,   379,   140,   380,   138,   139,
   172,   150,   140,   291,   138,   139,   333,   334,   140,   168,
   138,   139,   290,   323,   140,   300,   177,    21,    28,   178,
    22,   240,   375,   291,   353,    24,   376,   317,   354,   355,
   356,   352,   337,   141,   352,    22,   151,   376,   141,    30,
    24,    22,   233,   370,   141,   235,    24,    27,    25,   372,
   141,    29,   179,    53,   104,   180,   141,    33,   342,   105,
   344,   116,   117,    25,   294,   295,   299,    26,   383,    25,
   353,    31,    32,   353,   354,   355,   356,   354,   355,   356,
     1,    54,    26,    57,   267,   166,     2,   264,    26,   277,
   265,  -144,   278,  -143,   313,    34,   314,    35,    36,    37,
    38,     3,     4,     5,     6,     7,     8,    35,    36,    37,
    38,    39,    40,    41,    42,    43,   293,    59,    66,   297,
    67,   167,     9,    10,    34,    91,    97,   301,    63,   107,
    44,     2,    99,    45,   109,   110,    35,    36,    37,    38,
    39,    40,    41,    42,    43,   112,     3,     4,     5,     6,
     7,     8,   184,   185,   186,   287,   288,   289,    61,    92,
    62,   118,    45,   122,   371,   373,   127,     9,    10,   123,
    35,    36,    37,    38,   133,   143,    41,    42,    43,   384,
   385,   136,   386,   137,   387,   197,   146,   152,   149,    69,
    70,    71,    72,    73,    63,    74,    75,    76,    77,    78,
    79,    80,    81,    82,   153,    83,   198,   199,   200,   201,
   202,   156,   203,   204,   205,   206,   207,   208,   209,   157,
   159,    94,    95,    69,    70,    71,    72,    73,    61,    74,
    75,    76,    77,    78,    79,    80,    81,    82,   154,    83,
    35,    36,    37,    38,   158,   160,    41,    42,    43,    35,
    36,    37,    38,    69,    70,    71,    72,    73,   320,    74,
    75,    76,    77,    78,    79,    80,    81,    82,   161,    83,
   114,    70,    71,    72,    73,   162,    74,    75,    76,    77,
    78,    79,    80,    81,   115,   165,    83,    69,    70,    71,
    72,    73,   170,    74,    75,    76,    77,    78,    79,    80,
    81,    82,   173,    83,   219,   220,    71,    72,    73,   174,
    74,    75,    76,    77,    78,    79,    80,    81,   221,   175,
    83,   114,    70,    71,    72,    73,   187,    74,    75,    76,
    77,    78,    79,    80,    81,   271,   188,    83,   119,    70,
   189,   190,   191,   192,    74,    75,    76,    77,    78,    79,
    80,    81,   125,    70,    83,   193,   179,   215,    74,    75,
    76,    77,    78,    79,    80,    81,   114,    70,    83,   216,
   218,   128,    74,    75,    76,    77,    78,    79,    80,    81,
   167,   228,    83,    35,    36,    37,    38,   166,   232,   180,
   234,   177,   268,   244,   248,   245,   246,   247,   251,   249,
   250,   269,   252,   253,   254,   274,   255,   256,   257,   258,
   280,   259,   260,   261,   262,   263,   266,   276,   282,   283,
  -141,   275,   279,   284,   286,   302,   285,   303,   304,   305,
   306,   308,   309,   310,   311,   312,   318,   322,   324,   331,
   325,   336,   326,   328,   335,   347,   341,   351,   359,   346,
   360,   366,   362,   364,   365,   367,   382,   392,   393,   369,
    23,   374,   381,   243,   242,   238,    93,   307,   321,   390,
   368,   377,   145,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   176
};

static const short yycheck[] = {    99,
    41,    69,    69,   179,   156,    34,     5,    48,   285,     5,
   123,    19,    41,   319,    42,    83,    19,    19,    53,    34,
    88,   327,    57,    64,    19,    20,   332,    19,    23,   128,
   129,    19,    19,    62,    19,   312,    54,   343,    21,    19,
    54,    59,   218,    84,    19,    59,   114,    62,   325,    57,
   163,   119,    54,    94,    57,   361,   273,   125,   234,    19,
    56,    90,    61,    59,   341,    53,    58,    95,    55,   168,
    65,   170,    57,   379,   380,    19,   175,    19,    20,    54,
   180,    23,    19,    20,    22,   362,    23,   364,    19,    20,
   131,    19,    23,    30,    19,    20,   313,   314,    23,   128,
    19,    20,    19,   279,    23,   257,    19,    19,    53,    22,
    12,    53,    56,    30,    58,    12,   357,    55,    62,    63,
    64,    19,    53,    65,    19,    27,    54,   368,    65,    53,
    27,    33,   173,    58,    65,   176,    33,    13,    12,    58,
    65,     4,    55,    21,    54,    58,    65,    23,   324,    59,
   326,   219,   219,    27,   254,   255,   256,    12,    56,    33,
    58,    53,    53,    58,    62,    63,    64,    62,    63,    64,
     3,    19,    27,    19,   215,    19,     9,    56,    33,    56,
    59,    56,    59,    56,    59,    19,    59,    31,    32,    33,
    34,    24,    25,    26,    27,    28,    29,    31,    32,    33,
    34,    35,    36,    37,    38,    39,   253,    19,    19,   256,
    55,    55,    45,    46,    19,    55,    55,   258,    55,    19,
    54,     9,    58,    57,    19,    19,    31,    32,    33,    34,
    35,    36,    37,    38,    39,    19,    24,    25,    26,    27,
    28,    29,    19,    20,    21,   245,   246,   247,    19,    54,
    21,     5,    57,    19,   354,   355,    19,    45,    46,    61,
    31,    32,    33,    34,    21,    21,    37,    38,    39,   369,
   370,    19,   372,    19,   374,    19,    21,    56,    21,     5,
     6,     7,     8,     9,    55,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    19,    21,    40,    41,    42,    43,
    44,    60,    46,    47,    48,    49,    50,    51,    52,    56,
    19,    37,    38,     5,     6,     7,     8,     9,    19,    11,
    12,    13,    14,    15,    16,    17,    18,    19,    55,    21,
    31,    32,    33,    34,    55,    19,    37,    38,    39,    31,
    32,    33,    34,     5,     6,     7,     8,     9,    10,    11,
    12,    13,    14,    15,    16,    17,    18,    19,    19,    21,
     5,     6,     7,     8,     9,    55,    11,    12,    13,    14,
    15,    16,    17,    18,    19,     5,    21,     5,     6,     7,
     8,     9,    19,    11,    12,    13,    14,    15,    16,    17,
    18,    19,    56,    21,     5,     6,     7,     8,     9,    19,
    11,    12,    13,    14,    15,    16,    17,    18,    19,    19,
    21,     5,     6,     7,     8,     9,    20,    11,    12,    13,
    14,    15,    16,    17,    18,    19,    57,    21,     5,     6,
    21,    57,    21,    57,    11,    12,    13,    14,    15,    16,
    17,    18,     5,     6,    21,    21,    55,    19,    11,    12,
    13,    14,    15,    16,    17,    18,     5,     6,    21,    55,
    55,    19,    11,    12,    13,    14,    15,    16,    17,    18,
    55,    19,    21,    31,    32,    33,    34,    19,    19,    58,
    55,    19,    19,    57,    57,    56,    56,    56,    24,    57,
    57,    19,    58,    58,    58,    19,    58,    58,    58,    58,
    19,    58,    58,    58,    58,    58,    53,    59,    19,    24,
    56,    56,    55,    57,    24,    19,    56,    19,    19,    19,
    19,    24,    56,    56,    53,    56,    19,    19,    55,    24,
    56,    19,    55,    55,    55,    53,    56,    19,    24,    30,
    19,    24,    56,    56,    56,    53,    24,     0,     0,    58,
    12,    58,    57,   182,   181,   178,    46,   265,   276,    57,
   351,   360,   101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,   135
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/lib/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/lib/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 597 "parse.y"
{ ; ;
    break;}
case 2:
#line 598 "parse.y"
{ ; ;
    break;}
case 3:
#line 599 "parse.y"
{ ; ;
    break;}
case 4:
#line 600 "parse.y"
{ ; ;
    break;}
case 5:
#line 603 "parse.y"
{
			Node *node = node_new (CCODE_NODE,
					       "cctype", C_CCODE,
					       "cbuf:steal", (yyvsp[0].cbuf)->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free(yyvsp[0].cbuf,FALSE);
					;
    break;}
case 6:
#line 612 "parse.y"
{
			Node *node = node_new (CCODE_NODE,
					       "cctype", H_CCODE,
					       "cbuf:steal", (yyvsp[0].cbuf)->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free(yyvsp[0].cbuf,FALSE);
					;
    break;}
case 7:
#line 621 "parse.y"
{
			Node *node = node_new (CCODE_NODE,
					       "cctype", HT_CCODE,
					       "cbuf:steal", (yyvsp[0].cbuf)->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free(yyvsp[0].cbuf,FALSE);
					;
    break;}
case 8:
#line 630 "parse.y"
{
			Node *node = node_new (CCODE_NODE,
					       "cctype", PH_CCODE,
					       "cbuf:steal", (yyvsp[0].cbuf)->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free(yyvsp[0].cbuf,FALSE);
					;
    break;}
case 9:
#line 639 "parse.y"
{
			Node *node = node_new (CCODE_NODE,
					       "cctype", A_CCODE,
					       "cbuf:steal", (yyvsp[0].cbuf)->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free(yyvsp[0].cbuf,FALSE);
					;
    break;}
case 10:
#line 648 "parse.y"
{
			Node *node = node_new (CCODE_NODE,
					       "cctype", AT_CCODE,
					       "cbuf:steal", (yyvsp[0].cbuf)->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free(yyvsp[0].cbuf,FALSE);
					;
    break;}
case 11:
#line 659 "parse.y"
{ ; ;
    break;}
case 12:
#line 660 "parse.y"
{ ; ;
    break;}
case 13:
#line 661 "parse.y"
{ ; ;
    break;}
case 14:
#line 662 "parse.y"
{ ; ;
    break;}
case 15:
#line 663 "parse.y"
{ ; ;
    break;}
case 16:
#line 664 "parse.y"
{ ; ;
    break;}
case 17:
#line 665 "parse.y"
{ ; ;
    break;}
case 18:
#line 666 "parse.y"
{ ; ;
    break;}
case 19:
#line 669 "parse.y"
{
			((Class *)class)->nodes = class_nodes;
			class_nodes = NULL;
			nodes = g_list_append(nodes,class);
						;
    break;}
case 20:
#line 674 "parse.y"
{
			((Class *)class)->nodes = NULL;
			class_nodes = NULL;
			nodes = g_list_append(nodes,class);
						;
    break;}
case 21:
#line 681 "parse.y"
{
			class = node_new (CLASS_NODE,
					  "otype:steal", yyvsp[-3].id,
					  "ptype:steal", yyvsp[-1].id,
					  "bonobo_object_class:steal", bonobo_object_class,
					  "interfaces:steal", interfaces,
					  "chunk_size:steal", chunk_size,
					  NULL);
			bonobo_object_class = NULL;
			chunk_size = NULL;
			interfaces = NULL;
						;
    break;}
case 23:
#line 696 "parse.y"
{
			if(strcmp(yyvsp[-3].id,"chunks") == 0) {
				g_free (chunk_size);
				chunk_size = g_strdup(yyvsp[-2].id);
			} else if(strcmp(yyvsp[-3].id,"BonoboObject") == 0) {
				g_free (bonobo_object_class);
				bonobo_object_class = g_strdup(yyvsp[-2].id);
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
		;
    break;}
case 24:
#line 708 "parse.y"
{
			if (strcmp (yyvsp[-3].id, "interface") == 0) {
				interfaces = g_list_append (interfaces,
							    g_strdup (yyvsp[-2].id));
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
		;
    break;}
case 25:
#line 717 "parse.y"
{
			if(strcmp(yyvsp[-3].id,"chunks") == 0) {
				g_free (chunk_size);
				if(atoi(yyvsp[-2].id) != 0)
					chunk_size = g_strdup(yyvsp[-2].id);
				else
					chunk_size = NULL;
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
		;
    break;}
case 26:
#line 731 "parse.y"
{ ; ;
    break;}
case 27:
#line 732 "parse.y"
{ ; ;
    break;}
case 28:
#line 735 "parse.y"
{ ; ;
    break;}
case 29:
#line 736 "parse.y"
{
			if (strcmp (yyvsp[-1].id, "BonoboObject") != 0) {
				g_free (yyvsp[-1].id);
				yyerror (_("parse error"));
				YYERROR;
			}
			g_free (yyvsp[-1].id);
			last_added_method->bonobo_object_func = TRUE;
						;
    break;}
case 30:
#line 745 "parse.y"
{
			if (strcmp (yyvsp[-2].id, "interface") != 0) {
				g_free (yyvsp[-2].id);
				g_free (yyvsp[-1].id);
				yyerror (_("parse error"));
				YYERROR;
			}
			g_free (yyvsp[-2].id);
			node_set ((Node *)last_added_method,
				  "interface:steal", yyvsp[-1].id,
				  NULL);
						;
    break;}
case 31:
#line 757 "parse.y"
{ ; ;
    break;}
case 32:
#line 758 "parse.y"
{ ; ;
    break;}
case 33:
#line 759 "parse.y"
{ ; ;
    break;}
case 34:
#line 760 "parse.y"
{ ; ;
    break;}
case 35:
#line 763 "parse.y"
{ the_scope = PUBLIC_SCOPE; ;
    break;}
case 36:
#line 764 "parse.y"
{ the_scope = PRIVATE_SCOPE; ;
    break;}
case 37:
#line 765 "parse.y"
{ the_scope = PROTECTED_SCOPE; ;
    break;}
case 38:
#line 766 "parse.y"
{ the_scope = CLASS_SCOPE; ;
    break;}
case 39:
#line 769 "parse.y"
{
			if (strcmp (yyvsp[-1].id, "destroywith") == 0) {
				g_free (yyvsp[-1].id);
				destructor_unref = FALSE;
				destructor = yyvsp[0].id;
				destructor_line = line_no;
				destructor_simple = TRUE;
			} else if (strcmp (yyvsp[-1].id, "unrefwith") == 0) {
				g_free (yyvsp[-1].id);
				destructor_unref = TRUE;
				destructor = yyvsp[0].id;
				destructor_line = line_no;
				destructor_simple = TRUE;
			} else {
				g_free (yyvsp[-1].id);
				g_free (yyvsp[0].id);
				yyerror (_("parse error"));
				YYERROR;
			}
				;
    break;}
case 40:
#line 789 "parse.y"
{
			if (strcmp (yyvsp[-2].id, "destroy") == 0) {
				g_free(yyvsp[-2].id);
				destructor_unref = FALSE;
				destructor = (yyvsp[0].cbuf)->str;
				g_string_free(yyvsp[0].cbuf, FALSE);
				destructor_line = ccode_line;
				destructor_simple = FALSE;
			} else if (strcmp (yyvsp[-2].id, "unref") == 0) {
				g_free (yyvsp[-2].id);
				destructor_unref = TRUE;
				destructor = (yyvsp[0].cbuf)->str;
				g_string_free (yyvsp[0].cbuf, FALSE);
				destructor_line = ccode_line;
				destructor_simple = FALSE;
			} else {
				g_free (yyvsp[-2].id);
				g_string_free (yyvsp[0].cbuf, TRUE);
				yyerror (_("parse error"));
				YYERROR;
			}
					;
    break;}
case 41:
#line 813 "parse.y"
{
			initializer = yyvsp[0].id;
			initializer_line = ccode_line;
				;
    break;}
case 42:
#line 817 "parse.y"
{
			initializer = (yyvsp[0].cbuf)->str;
			initializer_line = ccode_line;
			g_string_free(yyvsp[0].cbuf, FALSE);
				;
    break;}
case 43:
#line 825 "parse.y"
{ ; ;
    break;}
case 44:
#line 826 "parse.y"
{ ; ;
    break;}
case 45:
#line 827 "parse.y"
{ destructor = NULL; ;
    break;}
case 46:
#line 828 "parse.y"
{ initializer = NULL; ;
    break;}
case 47:
#line 829 "parse.y"
{
			destructor = NULL;
			initializer = NULL;
					;
    break;}
case 48:
#line 835 "parse.y"
{
			push_variable(yyvsp[-2].id, the_scope,yyvsp[-4].line, NULL);
						;
    break;}
case 49:
#line 838 "parse.y"
{
			push_variable(yyvsp[-3].id, the_scope, yyvsp[-5].line, yyvsp[-2].id);
						;
    break;}
case 50:
#line 843 "parse.y"
{
			Node *node = NULL;
			if(strcmp(yyvsp[-6].id,"get")==0 &&
			   strcmp(yyvsp[-3].id,"set")==0) {
				Type *type = pop_type();
				g_free (yyvsp[-6].id); 
				g_free (yyvsp[-3].id);
				node = node_new (ARGUMENT_NODE,
						 "gtktype:steal", yyvsp[-9].id,
						 "atype:steal", type,
						 "flags:steal", yyvsp[-10].list,
						 "name:steal", yyvsp[-8].id,
						 "get:steal", (yyvsp[-4].cbuf)->str,
						 "get_line", yyvsp[-5].line,
						 "set:steal", (yyvsp[-1].cbuf)->str,
						 "set_line", yyvsp[-2].line,
						 "line_no", yyvsp[-11].line,
						 NULL);

				class_nodes = g_list_append(class_nodes,node);

				g_string_free (yyvsp[-4].cbuf, FALSE);
				g_string_free (yyvsp[-1].cbuf, FALSE);

			} else if(strcmp(yyvsp[-6].id,"set")==0 &&
				strcmp(yyvsp[-3].id,"get")==0) {
				Type *type = pop_type();
				g_free (yyvsp[-6].id); 
				g_free (yyvsp[-3].id);
				node = node_new (ARGUMENT_NODE,
						 "gtktype:steal", yyvsp[-9].id,
						 "atype:steal", type,
						 "flags:steal", yyvsp[-10].list,
						 "name:steal", yyvsp[-8].id,
						 "get:steal", (yyvsp[-1].cbuf)->str,
						 "get_line", yyvsp[-2].line,
						 "set:steal", (yyvsp[-4].cbuf)->str,
						 "set_line", yyvsp[-5].line,
						 "line_no", yyvsp[-11].line,
						 NULL);
				g_string_free (yyvsp[-1].cbuf, FALSE);
				g_string_free (yyvsp[-4].cbuf, FALSE);
				class_nodes = g_list_append(class_nodes,node);
			} else {
				g_free (yyvsp[-9].id); 
				g_free (yyvsp[-8].id);
				g_free (yyvsp[-6].id); 
				g_free (yyvsp[-3].id);
				g_list_foreach (yyvsp[-10].list, (GFunc)g_free, NULL);
				g_list_free (yyvsp[-10].list);
				g_string_free (yyvsp[-1].cbuf, TRUE);
				g_string_free (yyvsp[-4].cbuf, TRUE);
				yyerror (_("parse error"));
				YYERROR;
			}

			if (yyvsp[-7].id != NULL) {
				Argument *arg = (Argument *)node;
				export_accessors (arg->name,
						  arg->get != NULL, arg->get_line,
						  arg->set != NULL, arg->set_line,
						  arg->atype,
						  arg->gtktype,
						  arg->line_no);
				g_free (yyvsp[-7].id);
			} 

						;
    break;}
case 51:
#line 911 "parse.y"
{
			Node *node = NULL;
			if(strcmp(yyvsp[-3].id, "get") == 0) {
				Type *type = pop_type();
				g_free (yyvsp[-3].id);
				node = node_new (ARGUMENT_NODE,
						 "gtktype:steal", yyvsp[-6].id,
						 "atype:steal", type,
						 "flags:steal", yyvsp[-7].list,
						 "name:steal", yyvsp[-5].id,
						 "get:steal", (yyvsp[-1].cbuf)->str,
						 "get_line", yyvsp[-2].line,
						 "line_no", yyvsp[-8].line,
						 NULL);

				g_string_free (yyvsp[-1].cbuf, FALSE);
				class_nodes = g_list_append(class_nodes, node);
			} else if(strcmp(yyvsp[-3].id, "set") == 0) {
				Type *type = pop_type();
				g_free (yyvsp[-3].id);
				node = node_new (ARGUMENT_NODE,
						 "gtktype:steal", yyvsp[-6].id,
						 "atype:steal", type,
						 "flags:steal", yyvsp[-7].list,
						 "name:steal", yyvsp[-5].id,
						 "set:steal", (yyvsp[-1].cbuf)->str,
						 "set_line", yyvsp[-2].line,
						 "line_no", yyvsp[-8].line,
						 NULL);

				g_string_free (yyvsp[-1].cbuf, FALSE);
				class_nodes = g_list_append (class_nodes, node);
			} else {
				g_free (yyvsp[-3].id); 
				g_free (yyvsp[-6].id);
				g_free (yyvsp[-5].id);
				g_list_foreach (yyvsp[-7].list, (GFunc)g_free, NULL);
				g_list_free (yyvsp[-7].list);
				g_string_free (yyvsp[-1].cbuf, TRUE);
				yyerror(_("parse error"));
				YYERROR;
			}

			if (yyvsp[-4].id != NULL) {
				Argument *arg = (Argument *)node;
				export_accessors (arg->name,
						  arg->get != NULL, arg->get_line,
						  arg->set != NULL, arg->set_line,
						  arg->atype,
						  arg->gtktype,
						  arg->line_no);
				g_free (yyvsp[-4].id);
			} 
						;
    break;}
case 52:
#line 965 "parse.y"
{
			Node *node;
			char *get, *set = NULL;
			Variable *var;
			Type *type;
			char *root;
			
			if(strcmp(yyvsp[0].id, "link")!=0 &&
			   strcmp(yyvsp[0].id, "stringlink")!=0 && 
			   strcmp(yyvsp[0].id, "objectlink")!=0) {
				g_free(yyvsp[0].id); 
				g_free(yyvsp[-3].id);
				g_free(yyvsp[-2].id);
				g_list_foreach(yyvsp[-4].list,(GFunc)g_free,NULL);
				g_list_free(yyvsp[-4].list);
				yyerror(_("parse error"));
				YYERROR;
			}

			type = pop_type();

			var = find_var_or_die(yyvsp[-2].id, yyvsp[-5].line);
			if(var->scope == PRIVATE_SCOPE)
				root = "self->_priv";
			else if(var->scope == CLASS_SCOPE) {
				root = "SELF_GET_CLASS(self)";
				if(no_self_alias)
					error_print(GOB_ERROR, yyvsp[-5].line,
						    _("Self aliases needed when autolinking to a classwide member"));
			} else
				root = "self";

			if(strcmp(yyvsp[0].id, "link")==0) {
				set = g_strdup_printf("%s->%s = ARG;",
						      root, yyvsp[-2].id);
			} else if(strcmp(yyvsp[0].id, "stringlink")==0) {
				set = g_strdup_printf("g_free (%s->%s); "
						      "%s->%s = g_strdup (ARG);",
						      root, yyvsp[-2].id,
						      root, yyvsp[-2].id);
			} else if(strcmp(yyvsp[0].id, "objectlink")==0) {
				set = g_strdup_printf(
				  "if (ARG != NULL) "
				   "g_object_ref (G_OBJECT (ARG)); "
				  "if (%s->%s != NULL) "
				   "g_object_unref (G_OBJECT (%s->%s)); "
				  "%s->%s = ARG;",
				  root, yyvsp[-2].id,
				  root, yyvsp[-2].id,
				  root, yyvsp[-2].id);
			} else {
				g_assert_not_reached();
			}

			get = g_strdup_printf("ARG = %s->%s;", root, yyvsp[-2].id);
  
			g_free (yyvsp[0].id);

			if (type == NULL)
				type = (Type *)node_copy ((Node *)var->vtype);

			node = node_new (ARGUMENT_NODE,
					 "gtktype:steal", yyvsp[-3].id,
					 "atype:steal", type,
					 "flags:steal", yyvsp[-4].list,
					 "name:steal", yyvsp[-2].id,
					 "get:steal", get,
					 "get_line", yyvsp[-5].line,
					 "set:steal", set,
					 "set_line", yyvsp[-5].line,
					 "line_no", yyvsp[-5].line,
					 NULL);

			if (yyvsp[-1].id != NULL) {
				Argument *arg = (Argument *)node;
				export_accessors (arg->name,
						  arg->get != NULL, arg->get_line,
						  arg->set != NULL, arg->set_line,
						  arg->atype,
						  arg->gtktype,
						  arg->line_no);
				g_free (yyvsp[-1].id);
			} 

			class_nodes = g_list_append (class_nodes, node);
						;
    break;}
case 53:
#line 1053 "parse.y"
{
			if (strcmp (yyvsp[-1].id, "export")!=0) {
				g_free (yyvsp[-1].id); 
				yyerror (_("parse error"));
				YYERROR;
			}
			yyval.id = yyvsp[-1].id;
						;
    break;}
case 54:
#line 1061 "parse.y"
{
			yyval.id = NULL;
						;
    break;}
case 55:
#line 1066 "parse.y"
{
			ensure_property ();
			node_set ((Node *)property,
				  "line_no", yyvsp[-10].line,
				  "gtktype:steal", debool (yyvsp[-9].id),
				  "name:steal", yyvsp[-8].id,
				  NULL);
			if (strcmp (yyvsp[-6].id, "get") == 0 &&
			    strcmp (yyvsp[-3].id, "set") == 0) {
				node_set ((Node *)property,
					  "get:steal", (yyvsp[-4].cbuf)->str,
					  "get_line", yyvsp[-5].line,
					  "set:steal", (yyvsp[-1].cbuf)->str,
					  "set_line", yyvsp[-2].line,
					  NULL);
				g_string_free (yyvsp[-4].cbuf, FALSE);
				g_string_free (yyvsp[-1].cbuf, FALSE);
				g_free (yyvsp[-6].id); 
				g_free (yyvsp[-3].id);
			} else if (strcmp (yyvsp[-6].id, "set") == 0 &&
				   strcmp (yyvsp[-3].id, "get") == 0) {
				node_set ((Node *)property,
					  "get:steal", (yyvsp[-1].cbuf)->str,
					  "get_line", yyvsp[-2].line,
					  "set:steal", (yyvsp[-4].cbuf)->str,
					  "set_line", yyvsp[-5].line,
					  NULL);
				g_string_free (yyvsp[-4].cbuf, FALSE);
				g_string_free (yyvsp[-1].cbuf, FALSE);
				g_free (yyvsp[-6].id); 
				g_free (yyvsp[-3].id);
			} else {
				g_string_free (yyvsp[-4].cbuf, TRUE);
				g_string_free (yyvsp[-1].cbuf, TRUE);
				g_free (yyvsp[-6].id); 
				g_free (yyvsp[-3].id);
				node_free ((Node *)property);
				property = NULL;
				yyerror (_("parse error"));
				YYERROR;
			}
			property_link_and_export ((Node *)property);
			if (property != NULL) {
				class_nodes = g_list_append (class_nodes,
							     property);
				property = NULL;
			}
		;
    break;}
case 56:
#line 1114 "parse.y"
{
			ensure_property ();
			node_set ((Node *)property,
				  "line_no", yyvsp[-7].line,
				  "gtktype:steal", debool (yyvsp[-6].id),
				  "name:steal", yyvsp[-5].id,
				  NULL);
			if (strcmp (yyvsp[-3].id, "get") == 0) {
				node_set ((Node *)property,
					  "get:steal", (yyvsp[-1].cbuf)->str,
					  "get_line", yyvsp[-2].line,
					  NULL);
				g_string_free (yyvsp[-1].cbuf, FALSE);
				g_free (yyvsp[-3].id); 
			} else if (strcmp (yyvsp[-3].id, "set") == 0) {
				node_set ((Node *)property,
					  "set:steal", (yyvsp[-1].cbuf)->str,
					  "set_line", yyvsp[-2].line,
					  NULL);
				g_string_free (yyvsp[-1].cbuf, FALSE);
				g_free (yyvsp[-3].id); 
			} else {
				g_string_free (yyvsp[-1].cbuf, TRUE);
				g_free (yyvsp[-3].id); 
				node_free ((Node *)property);
				property = NULL;
				yyerror (_("parse error"));
				YYERROR;
			}
			property_link_and_export ((Node *)property);
			if (property != NULL) {
				class_nodes = g_list_append (class_nodes,
							     property);
				property = NULL;
			}
		;
    break;}
case 57:
#line 1150 "parse.y"
{
			ensure_property ();
			node_set ((Node *)property,
				  "line_no", yyvsp[-4].line,
				  "gtktype:steal", debool (yyvsp[-3].id),
				  "name:steal", yyvsp[-2].id,
				  NULL);
			property_link_and_export ((Node *)property);
			if (property != NULL) {
				class_nodes = g_list_append (class_nodes,
							     property);
				property = NULL;
			}
		;
    break;}
case 58:
#line 1166 "parse.y"
{ ; ;
    break;}
case 59:
#line 1167 "parse.y"
{ ; ;
    break;}
case 60:
#line 1170 "parse.y"
{ ; ;
    break;}
case 61:
#line 1171 "parse.y"
{ ; ;
    break;}
case 62:
#line 1174 "parse.y"
{ yyval.id = yyvsp[0].id; ;
    break;}
case 63:
#line 1175 "parse.y"
{
			if (strcmp (yyvsp[-3].id, "_") != 0) {
				g_free (yyvsp[-3].id);
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free (yyvsp[-3].id);
			yyval.id = g_strconcat ("_(", yyvsp[-1].id, ")", NULL);
			g_free (yyvsp[-1].id);
		;
    break;}
case 64:
#line 1187 "parse.y"
{ yyval.id = yyvsp[0].id; ;
    break;}
case 65:
#line 1188 "parse.y"
{ yyval.id = yyvsp[0].id; ;
    break;}
case 66:
#line 1191 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "nick:steal", yyvsp[0].id,
			  NULL);
		  ;
    break;}
case 67:
#line 1197 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "blurb:steal", yyvsp[0].id,
			  NULL);
		  ;
    break;}
case 68:
#line 1203 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "maximum:steal", yyvsp[0].id,
			  NULL);
		  ;
    break;}
case 69:
#line 1209 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "minimum:steal", yyvsp[0].id,
			  NULL);
		  ;
    break;}
case 70:
#line 1215 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "default_value:steal", yyvsp[0].id,
			  NULL);
		  ;
    break;}
case 71:
#line 1221 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "flags:steal", yyvsp[0].list,
			  NULL);
		  ;
    break;}
case 72:
#line 1227 "parse.y"
{
		Type *type = pop_type ();
		ensure_property ();
		node_set ((Node *)property,
			  "ptype:steal", type,
			  NULL);
		  ;
    break;}
case 73:
#line 1234 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", yyvsp[0].id,
			  NULL);
		  ;
    break;}
case 74:
#line 1240 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", yyvsp[0].id,
			  NULL);
		  ;
    break;}
case 75:
#line 1246 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", yyvsp[0].id,
			  NULL);
		  ;
    break;}
case 76:
#line 1252 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", yyvsp[0].id,
			  NULL);
		  ;
    break;}
case 77:
#line 1258 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", yyvsp[0].id,
			  NULL);
		  ;
    break;}
case 78:
#line 1264 "parse.y"
{
		ensure_property ();
		if (strcmp (yyvsp[0].id, "link") == 0) {
			g_free(yyvsp[0].id);
			node_set ((Node *)property,
				  "link", TRUE,
				  NULL);
		} else if (strcmp (yyvsp[0].id, "export") == 0) {
			g_free(yyvsp[0].id);
			node_set ((Node *)property,
				  "export", TRUE,
				  NULL);
		} else {
			g_free(yyvsp[0].id);
			yyerror(_("parse error"));
			YYERROR;
		}
		  ;
    break;}
case 79:
#line 1284 "parse.y"
{
			if(strcmp(yyvsp[-2].id,"type")!=0) {
				g_free(yyvsp[-4].id);
				g_free(yyvsp[-2].id);
				yyerror(_("parse error"));
				YYERROR;
			}
			yyval.id = debool (yyvsp[-4].id);
						;
    break;}
case 80:
#line 1293 "parse.y"
{
			yyval.id = debool (yyvsp[0].id);
			typestack = g_list_prepend(typestack,NULL);
						;
    break;}
case 81:
#line 1299 "parse.y"
{ yyval.list = yyvsp[-1].list; ;
    break;}
case 82:
#line 1300 "parse.y"
{ yyval.list = NULL; ;
    break;}
case 83:
#line 1303 "parse.y"
{
			yyval.list = g_list_append(yyvsp[0].list,yyvsp[-2].id);
						;
    break;}
case 84:
#line 1306 "parse.y"
{
			yyval.list = g_list_append(NULL,yyvsp[0].id);
						;
    break;}
case 85:
#line 1312 "parse.y"
{
			Node *node = node_new (TYPE_NODE, 
					       "name:steal", yyvsp[-1].id,
					       "pointer:steal", yyvsp[0].id,
					       NULL);
			typestack = g_list_prepend(typestack,node);
							;
    break;}
case 86:
#line 1319 "parse.y"
{
			Node *node = node_new (TYPE_NODE, 
					       "name:steal", yyvsp[0].id,
					       NULL);
			typestack = g_list_prepend(typestack,node);
							;
    break;}
case 87:
#line 1328 "parse.y"
{
			yyval.id = yyvsp[0].id;
							;
    break;}
case 88:
#line 1331 "parse.y"
{
			yyval.id = yyvsp[0].id;
							;
    break;}
case 89:
#line 1334 "parse.y"
{
			yyval.id = g_strconcat("const ", yyvsp[0].id, NULL);
			g_free(yyvsp[0].id);
							;
    break;}
case 90:
#line 1338 "parse.y"
{
			yyval.id = g_strconcat(yyvsp[-1].id, " const", NULL);
			g_free(yyvsp[-1].id);
							;
    break;}
case 91:
#line 1342 "parse.y"
{
			yyval.id = g_strconcat(yyvsp[-1].id, " ", yyvsp[0].id, NULL);
			g_free(yyvsp[0].id);
							;
    break;}
case 92:
#line 1346 "parse.y"
{
			yyval.id = g_strconcat("const ", yyvsp[-1].id, " ",
					     yyvsp[0].id, NULL);
			g_free(yyvsp[0].id);
							;
    break;}
case 93:
#line 1351 "parse.y"
{
			yyval.id = g_strconcat(yyvsp[-2].id, " ",
					     yyvsp[-1].id, " const", NULL);
			g_free(yyvsp[-1].id);
							;
    break;}
case 94:
#line 1359 "parse.y"
{
			yyval.id = g_strconcat(yyvsp[-1].id, " ", yyvsp[0].id, NULL);
			g_free(yyvsp[0].id);
							;
    break;}
case 95:
#line 1363 "parse.y"
{
			yyval.id = g_strconcat(yyvsp[-1].id, " ", yyvsp[0].id, NULL);
			g_free(yyvsp[-1].id);
			g_free(yyvsp[0].id);
							;
    break;}
case 96:
#line 1368 "parse.y"
{
			yyval.id = g_strconcat("const ", yyvsp[0].id, NULL);
			g_free(yyvsp[0].id);
							;
    break;}
case 97:
#line 1372 "parse.y"
{
			yyval.id = yyvsp[0].id;
							;
    break;}
case 98:
#line 1375 "parse.y"
{
			yyval.id = g_strconcat(yyvsp[-1].id, " const", NULL);
			g_free(yyvsp[-1].id);
							;
    break;}
case 99:
#line 1379 "parse.y"
{
			yyval.id = g_strdup(yyvsp[0].id);
							;
    break;}
case 100:
#line 1382 "parse.y"
{
			yyval.id = g_strconcat(yyvsp[-1].id, " const", NULL);
							;
    break;}
case 101:
#line 1387 "parse.y"
{ yyval.id = "void"; ;
    break;}
case 102:
#line 1388 "parse.y"
{ yyval.id = "char"; ;
    break;}
case 103:
#line 1389 "parse.y"
{ yyval.id = "short"; ;
    break;}
case 104:
#line 1390 "parse.y"
{ yyval.id = "int"; ;
    break;}
case 105:
#line 1391 "parse.y"
{ yyval.id = "long"; ;
    break;}
case 106:
#line 1392 "parse.y"
{ yyval.id = "float"; ;
    break;}
case 107:
#line 1393 "parse.y"
{ yyval.id = "double"; ;
    break;}
case 108:
#line 1394 "parse.y"
{ yyval.id = "signed"; ;
    break;}
case 109:
#line 1395 "parse.y"
{ yyval.id = "unsigned"; ;
    break;}
case 110:
#line 1398 "parse.y"
{ yyval.id = "struct"; ;
    break;}
case 111:
#line 1399 "parse.y"
{ yyval.id = "union"; ;
    break;}
case 112:
#line 1400 "parse.y"
{ yyval.id = "enum"; ;
    break;}
case 113:
#line 1403 "parse.y"
{ yyval.id = g_strdup("*"); ;
    break;}
case 114:
#line 1404 "parse.y"
{ yyval.id = g_strdup("* const"); ;
    break;}
case 115:
#line 1405 "parse.y"
{
				yyval.id = g_strconcat("*", yyvsp[0].id, NULL);
				g_free(yyvsp[0].id);
					;
    break;}
case 116:
#line 1409 "parse.y"
{
				yyval.id = g_strconcat("* const", yyvsp[0].id, NULL);
				g_free(yyvsp[0].id);
					;
    break;}
case 117:
#line 1416 "parse.y"
{
			if(strcmp(yyvsp[-1].id, "first")==0)
				yyval.sigtype = SIGNAL_FIRST_METHOD;
			else if(strcmp(yyvsp[-1].id, "last")==0)
				yyval.sigtype = SIGNAL_LAST_METHOD;
			else {
				yyerror(_("signal must be 'first' or 'last'"));
				g_free(yyvsp[-1].id);
				YYERROR;
			}
			g_free(yyvsp[-1].id);
					;
    break;}
case 118:
#line 1428 "parse.y"
{
			yyval.sigtype = SIGNAL_LAST_METHOD;
					;
    break;}
case 119:
#line 1434 "parse.y"
{
			if(strcmp(yyvsp[-1].id,"first")==0)
				yyval.sigtype = SIGNAL_FIRST_METHOD;
			else if(strcmp(yyvsp[-1].id,"last")==0)
				yyval.sigtype = SIGNAL_LAST_METHOD;
			else {
				yyerror(_("signal must be 'first' or 'last'"));
				g_free(yyvsp[-1].id);
				YYERROR;
			}
			g_free(yyvsp[-1].id);
					;
    break;}
case 120:
#line 1446 "parse.y"
{
			if(strcmp(yyvsp[-2].id,"first")==0)
				yyval.sigtype = SIGNAL_FIRST_METHOD;
			else if(strcmp(yyvsp[-2].id,"last")==0)
				yyval.sigtype = SIGNAL_LAST_METHOD;
			else {
				yyerror(_("signal must be 'first' or 'last'"));
				g_free(yyvsp[-2].id);
				YYERROR;
			}
			g_free(yyvsp[-2].id);
					;
    break;}
case 121:
#line 1458 "parse.y"
{
			yyval.sigtype = SIGNAL_LAST_METHOD;
					;
    break;}
case 122:
#line 1461 "parse.y"
{
			/* the_scope was default thus public */
			the_scope = PUBLIC_SCOPE;
					;
    break;}
case 123:
#line 1467 "parse.y"
{
			gtktypes = g_list_prepend(gtktypes, debool (yyvsp[-3].id));
						;
    break;}
case 124:
#line 1472 "parse.y"
{
			gtktypes = g_list_append(gtktypes, debool (yyvsp[0].id));
						;
    break;}
case 125:
#line 1475 "parse.y"
{ 
			gtktypes = g_list_append(gtktypes, debool (yyvsp[0].id));
       						;
    break;}
case 126:
#line 1480 "parse.y"
{ yyval.cbuf = yyvsp[0].cbuf; ;
    break;}
case 127:
#line 1481 "parse.y"
{ yyval.cbuf = NULL; ;
    break;}
case 128:
#line 1485 "parse.y"
{
			if(!has_self) {
				yyerror(_("signal without 'self' as "
					  "first parameter"));
				free_all_global_state();
				YYERROR;
			}
			if(the_scope == CLASS_SCOPE) {
				yyerror(_("a method cannot be of class scope"));
				free_all_global_state();
				YYERROR;
			}
			push_function(the_scope, yyvsp[-7].sigtype,NULL,
				      yyvsp[-5].id, yyvsp[0].cbuf,yyvsp[-9].line,
				      ccode_line, vararg, yyvsp[-8].list);
									;
    break;}
case 129:
#line 1501 "parse.y"
{
			if(!has_self) {
				yyerror(_("signal without 'self' as "
					  "first parameter"));
				free_all_global_state();
				YYERROR;
			}
			if(the_scope == CLASS_SCOPE) {
				yyerror(_("a method cannot be of class scope"));
				free_all_global_state();
				YYERROR;
			}
			push_function(the_scope, yyvsp[-7].sigtype, NULL,
				      yyvsp[-5].id, yyvsp[0].cbuf, yyvsp[-9].line,
				      ccode_line, vararg, yyvsp[-8].list);
									;
    break;}
case 130:
#line 1517 "parse.y"
{
			if(!has_self) {
				yyerror(_("virtual method without 'self' as "
					  "first parameter"));
				free_all_global_state();
				YYERROR;
			}
			if(the_scope == CLASS_SCOPE) {
				yyerror(_("a method cannot be of class scope"));
				free_all_global_state();
				YYERROR;
			}
			push_function(the_scope, VIRTUAL_METHOD, NULL, yyvsp[-5].id,
				      yyvsp[0].cbuf, yyvsp[-8].line,
				      ccode_line, vararg, NULL);
									;
    break;}
case 131:
#line 1533 "parse.y"
{
			if(!has_self) {
				yyerror(_("virtual method without 'self' as "
					  "first parameter"));
				free_all_global_state();
				YYERROR;
			}
			if(the_scope == CLASS_SCOPE) {
				yyerror(_("a method cannot be of class scope"));
				free_all_global_state();
				YYERROR;
			}
			push_function(the_scope, VIRTUAL_METHOD, NULL, yyvsp[-5].id,
				      yyvsp[0].cbuf, yyvsp[-7].line,
				      ccode_line, vararg, NULL);
									;
    break;}
case 132:
#line 1549 "parse.y"
{
			if(!has_self) {
				yyerror(_("virtual method without 'self' as "
					  "first parameter"));
				free_all_global_state();
				YYERROR;
			}
			push_function(PUBLIC_SCOPE, VIRTUAL_METHOD, NULL,
				      yyvsp[-5].id, yyvsp[0].cbuf, yyvsp[-7].line,
				      ccode_line, vararg, NULL);
									;
    break;}
case 133:
#line 1560 "parse.y"
{
			push_function(NO_SCOPE, OVERRIDE_METHOD, yyvsp[-8].id,
				      yyvsp[-5].id, yyvsp[0].cbuf,
				      yyvsp[-10].line, ccode_line,
				      vararg, NULL);
									;
    break;}
case 134:
#line 1566 "parse.y"
{
			if(the_scope == CLASS_SCOPE) {
				yyerror(_("a method cannot be of class scope"));
				free_all_global_state();
				YYERROR;
			}
			push_function(the_scope, REGULAR_METHOD, NULL, yyvsp[-5].id,
				      yyvsp[0].cbuf, yyvsp[-7].line, ccode_line,
				      vararg, NULL);
								;
    break;}
case 135:
#line 1576 "parse.y"
{
			if(strcmp(yyvsp[-4].id, "init")==0) {
				push_init_arg(yyvsp[-2].id,FALSE);
				push_function(NO_SCOPE, INIT_METHOD, NULL,
					      yyvsp[-4].id, yyvsp[0].cbuf, yyvsp[-3].line,
					      ccode_line, FALSE, NULL);
			} else if(strcmp(yyvsp[-4].id, "class_init")==0) {
				push_init_arg(yyvsp[-2].id,TRUE);
				push_function(NO_SCOPE, CLASS_INIT_METHOD, NULL,
					      yyvsp[-4].id, yyvsp[0].cbuf, yyvsp[-3].line,
					      ccode_line, FALSE, NULL);
			} else {
				g_free(yyvsp[-4].id);
				g_free(yyvsp[-2].id);
				g_string_free(yyvsp[0].cbuf,TRUE);
				yyerror(_("parse error "
					  "(untyped blocks must be init or "
					  "class_init)"));
				YYERROR;
			}
						;
    break;}
case 136:
#line 1599 "parse.y"
{
			g_free(onerror); onerror = NULL;
			g_free(defreturn); defreturn = NULL;
			if(!set_return_value(yyvsp[-1].id, yyvsp[0].id)) {
				g_free(yyvsp[-1].id);
				g_free(yyvsp[0].id);
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free(yyvsp[-1].id);
					;
    break;}
case 137:
#line 1610 "parse.y"
{
			g_free(onerror); onerror = NULL;
			g_free(defreturn); defreturn = NULL;
			if(!set_return_value(yyvsp[-3].id, yyvsp[-2].id)) {
				g_free(yyvsp[-3].id); g_free(yyvsp[-2].id);
				g_free(yyvsp[-1].id); g_free(yyvsp[0].id);
				yyerror(_("parse error"));
				YYERROR;
			}
			if(!set_return_value(yyvsp[-1].id, yyvsp[0].id)) {
				onerror = defreturn = NULL;
				g_free(yyvsp[-3].id); g_free(yyvsp[-2].id);
				g_free(yyvsp[-1].id); g_free(yyvsp[0].id);
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free(yyvsp[-3].id);
			g_free(yyvsp[-1].id);
						;
    break;}
case 138:
#line 1629 "parse.y"
{
			g_free(onerror); onerror = NULL;
			g_free(defreturn); defreturn = NULL;
					;
    break;}
case 139:
#line 1635 "parse.y"
{ yyval.id = yyvsp[0].id; ;
    break;}
case 140:
#line 1636 "parse.y"
{
			yyval.id = (yyvsp[1].cbuf)->str;
			g_string_free(yyvsp[1].cbuf, FALSE);
					;
    break;}
case 141:
#line 1642 "parse.y"
{ vararg = FALSE; has_self = FALSE; ;
    break;}
case 142:
#line 1643 "parse.y"
{
			vararg = FALSE;
			has_self = TRUE;
			if(strcmp(yyvsp[0].id,"self")==0)
				push_self(yyvsp[0].id, FALSE);
			else {
				g_free(yyvsp[0].id);
				yyerror(_("parse error"));
				YYERROR;
			}
       					;
    break;}
case 143:
#line 1654 "parse.y"
{
			vararg = FALSE;
			has_self = TRUE;
			if(strcmp(yyvsp[-1].id,"self")==0)
				push_self(yyvsp[-1].id, TRUE);
			else {
				g_free(yyvsp[-1].id);
				yyerror(_("parse error"));
				YYERROR;
			}
       					;
    break;}
case 144:
#line 1665 "parse.y"
{
			vararg = FALSE;
			has_self = TRUE;
			if(strcmp(yyvsp[0].id,"self")==0)
				push_self(yyvsp[0].id, TRUE);
			else {
				g_free(yyvsp[0].id);
				yyerror(_("parse error"));
				YYERROR;
			}
       					;
    break;}
case 145:
#line 1676 "parse.y"
{
			has_self = TRUE;
			if(strcmp(yyvsp[-2].id,"self")==0)
				push_self(yyvsp[-2].id, FALSE);
			else {
				g_free(yyvsp[-2].id);
				yyerror(_("parse error"));
				YYERROR;
			}
					;
    break;}
case 146:
#line 1686 "parse.y"
{
			has_self = TRUE;
			if(strcmp(yyvsp[-3].id,"self")==0)
				push_self(yyvsp[-3].id, TRUE);
			else {
				g_free(yyvsp[-3].id);
				yyerror(_("parse error"));
				YYERROR;
			}
					;
    break;}
case 147:
#line 1696 "parse.y"
{
			has_self = TRUE;
			if(strcmp(yyvsp[-2].id,"self")==0)
				push_self(yyvsp[-2].id, TRUE);
			else {
				g_free(yyvsp[-2].id);
				yyerror(_("parse error"));
				YYERROR;
			}
					;
    break;}
case 148:
#line 1706 "parse.y"
{ has_self = FALSE; ;
    break;}
case 149:
#line 1709 "parse.y"
{ vararg = TRUE; ;
    break;}
case 150:
#line 1710 "parse.y"
{ vararg = FALSE; ;
    break;}
case 151:
#line 1713 "parse.y"
{ ; ;
    break;}
case 152:
#line 1714 "parse.y"
{ ; ;
    break;}
case 153:
#line 1717 "parse.y"
{
			push_funcarg(yyvsp[0].id,NULL);
								;
    break;}
case 154:
#line 1720 "parse.y"
{
			push_funcarg(yyvsp[-1].id,yyvsp[0].id);
								;
    break;}
case 155:
#line 1723 "parse.y"
{
			if(strcmp(yyvsp[-2].id,"check")!=0) {
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free(yyvsp[-2].id);
			push_funcarg(yyvsp[-4].id,NULL);
								;
    break;}
case 156:
#line 1731 "parse.y"
{
			if(strcmp(yyvsp[-2].id,"check")!=0) {
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free(yyvsp[-2].id);
			push_funcarg(yyvsp[-5].id,yyvsp[-4].id);
								;
    break;}
case 157:
#line 1741 "parse.y"
{ ; ;
    break;}
case 158:
#line 1742 "parse.y"
{ ; ;
    break;}
case 159:
#line 1745 "parse.y"
{
			if(strcmp(yyvsp[0].id,"type")==0) {
				Node *node = node_new (CHECK_NODE,
						       "chtype", TYPE_CHECK,
						       NULL);
				checks = g_list_append(checks,node);
			} else if(strcmp(yyvsp[0].id,"null")==0) {
				Node *node = node_new (CHECK_NODE,
						       "chtype", NULL_CHECK,
						       NULL);
				checks = g_list_append(checks,node);
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free(yyvsp[0].id);
					;
    break;}
case 160:
#line 1762 "parse.y"
{
			Node *node = node_new (CHECK_NODE,
					       "chtype", GT_CHECK,
					       "number:steal", yyvsp[0].id,
					       NULL);
			checks = g_list_append(checks,node);
					;
    break;}
case 161:
#line 1769 "parse.y"
{
			Node *node = node_new (CHECK_NODE,
					       "chtype", LT_CHECK,
					       "number:steal", yyvsp[0].id,
					       NULL);
			checks = g_list_append(checks,node);
					;
    break;}
case 162:
#line 1776 "parse.y"
{
			Node *node = node_new (CHECK_NODE,
					       "chtype", GE_CHECK,
					       "number:steal", yyvsp[0].id,
					       NULL);
			checks = g_list_append(checks,node);
					;
    break;}
case 163:
#line 1783 "parse.y"
{
			Node *node = node_new (CHECK_NODE,
					       "chtype", LE_CHECK,
					       "number:steal", yyvsp[0].id,
					       NULL);
			checks = g_list_append(checks,node);
					;
    break;}
case 164:
#line 1790 "parse.y"
{
			Node *node = node_new (CHECK_NODE,
					       "chtype", EQ_CHECK,
					       "number:steal", yyvsp[0].id,
					       NULL);
			checks = g_list_append(checks,node);
					;
    break;}
case 165:
#line 1797 "parse.y"
{
			Node *node = node_new (CHECK_NODE,
					       "chtype", NE_CHECK,
					       "number:steal", yyvsp[0].id,
					       NULL);
			checks = g_list_append(checks,node);
					;
    break;}
case 166:
#line 1806 "parse.y"
{
			Node *node = node_new (ENUMDEF_NODE,
					       "etype:steal", yyvsp[-1].id,
					       "prefix:steal", yyvsp[-5].id,
					       "values:steal", enum_vals,
					       NULL);
			enum_vals = NULL;
			nodes = g_list_append (nodes, node);
			;
    break;}
case 167:
#line 1815 "parse.y"
{
			Node *node = node_new (ENUMDEF_NODE,
					       "etype:steal", yyvsp[-1].id,
					       "prefix:steal", yyvsp[-6].id,
					       "values:steal", enum_vals,
					       NULL);
			enum_vals = NULL;
			nodes = g_list_append (nodes, node);
			;
    break;}
case 168:
#line 1826 "parse.y"
{;;
    break;}
case 169:
#line 1827 "parse.y"
{;;
    break;}
case 170:
#line 1830 "parse.y"
{
			Node *node;
			char *num = yyvsp[0].id;

			/* A float value, that's a bad enum */
			if (num[0] >= '0' &&
			    num[0] <= '9' &&
			    strchr (num, '.') != NULL) {
				g_free (yyvsp[-2].id);
				g_free (num);
				yyerror(_("parse error (enumerator value not integer constant)"));
				YYERROR;
			}
		       
			node = node_new (ENUMVALUE_NODE,
					 "name:steal", yyvsp[-2].id,
					 "value:steal", num,
					 NULL);
			enum_vals = g_list_append (enum_vals, node);
			;
    break;}
case 171:
#line 1850 "parse.y"
{
			Node *node;

			node = node_new (ENUMVALUE_NODE,
					 "name:steal", yyvsp[0].id,
					 NULL);
			enum_vals = g_list_append (enum_vals, node);
	;
    break;}
case 172:
#line 1860 "parse.y"
{
			Node *node = node_new (FLAGS_NODE,
					       "ftype:steal", yyvsp[-1].id,
					       "prefix:steal", yyvsp[-5].id,
					       "values:steal", flag_vals,
					       NULL);
			flag_vals = NULL;
			nodes = g_list_append (nodes, node);
			;
    break;}
case 173:
#line 1869 "parse.y"
{
			Node *node = node_new (FLAGS_NODE,
					       "ftype:steal", yyvsp[-1].id,
					       "prefix:steal", yyvsp[-6].id,
					       "values:steal", flag_vals,
					       NULL);
			flag_vals = NULL;
			nodes = g_list_append (nodes, node);
			;
    break;}
case 174:
#line 1880 "parse.y"
{
			flag_vals = g_list_append (flag_vals, yyvsp[0].id);
		;
    break;}
case 175:
#line 1883 "parse.y"
{
			flag_vals = g_list_append (flag_vals, yyvsp[0].id);
		;
    break;}
case 176:
#line 1888 "parse.y"
{
			Node *node = node_new (ERROR_NODE,
					       "etype:steal", yyvsp[-1].id,
					       "prefix:steal", yyvsp[-5].id,
					       "values:steal", error_vals,
					       NULL);
			error_vals = NULL;
			nodes = g_list_append (nodes, node);
			;
    break;}
case 177:
#line 1897 "parse.y"
{
			Node *node = node_new (ERROR_NODE,
					       "etype:steal", yyvsp[-1].id,
					       "prefix:steal", yyvsp[-6].id,
					       "values:steal", error_vals,
					       NULL);
			error_vals = NULL;
			nodes = g_list_append (nodes, node);
			;
    break;}
case 178:
#line 1908 "parse.y"
{
			error_vals = g_list_append (error_vals, yyvsp[0].id);
		;
    break;}
case 179:
#line 1911 "parse.y"
{
			error_vals = g_list_append (error_vals, yyvsp[0].id);
		;
    break;}
case 180:
#line 1917 "parse.y"
{ yyval.id = yyvsp[0].id; ;
    break;}
case 181:
#line 1918 "parse.y"
{
			yyval.id = g_strconcat("-",yyvsp[0].id,NULL);
			g_free(yyvsp[0].id);
					;
    break;}
case 182:
#line 1922 "parse.y"
{ yyval.id = yyvsp[0].id; ;
    break;}
case 183:
#line 1923 "parse.y"
{ yyval.id = yyvsp[0].id; ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 1926 "parse.y"

