// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GOOCANVASMM_ITEMMODEL_H
#define _GOOCANVASMM_ITEMMODEL_H


#include <glibmm.h>


/* Copyright (C) 1998-2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cairomm/cairomm.h>
#include <goocanvasitemmodel.h>
#include <goocanvasmm/style.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef union _GooCanvasPathCommand GooCanvasPathCommand; }
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GooCanvasItemModel GooCanvasItemModel;
typedef struct _GooCanvasItemModelClass GooCanvasItemModelClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Goocanvas
{ class ItemModel_Class; } // namespace Goocanvas
namespace Goocanvas
{

/** @addtogroup goocanvasmmEnums Enums and Flags */

/**
 * @ingroup goocanvasmmEnums
 */
enum AnimateType
{
  CANVAS_ANIMATE_FREEZE,
  CANVAS_ANIMATE_RESET,
  CANVAS_ANIMATE_RESTART,
  CANVAS_ANIMATE_BOUNCE
};

} // namespace Goocanvas


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Goocanvas::AnimateType> : public Glib::Value_Enum<Goocanvas::AnimateType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Goocanvas
{


class ItemModel : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ItemModel CppObjectType;
  typedef ItemModel_Class CppClassType;
  typedef GooCanvasItemModel BaseObjectType;
  typedef GooCanvasItemModelIface BaseClassType;

private:
  friend class ItemModel_Class;
  static CppClassType itemmodel_class_;

  // noncopyable
  ItemModel(const ItemModel&);
  ItemModel& operator=(const ItemModel&);

protected:
  ItemModel(); // you must derive from this class

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit ItemModel(GooCanvasItemModel* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ItemModel();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GooCanvasItemModel*       gobj()       { return reinterpret_cast<GooCanvasItemModel*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GooCanvasItemModel* gobj() const { return reinterpret_cast<GooCanvasItemModel*>(gobject_); }

private:


public:

  
  int get_n_children();
  
  int get_n_children() const;
  
  Glib::RefPtr<ItemModel> get_child(int child_num);
  
  Glib::RefPtr<const ItemModel> get_child(int child_num) const;

  
  void add_child(const Glib::RefPtr<ItemModel>& child, int position);
   void add_child(const Glib::RefPtr<ItemModel>& child);

  
  void move_child(int old_position, int new_position);
  
  void remove_child(int child_num);
  
  int find_child(const Glib::RefPtr<ItemModel>& child);

  
  Glib::RefPtr<ItemModel> get_parent();
  
  Glib::RefPtr<const ItemModel> get_parent() const;
  
  void set_parent(const Glib::RefPtr<ItemModel>& parent);

  
  void remove();
  
  bool is_container() const;

  
  void raise(const Glib::RefPtr<ItemModel>& above);

  /** Raise the item to the top of the stack.
   */
  void raise();

  
  void lower(const Glib::RefPtr<ItemModel>& below);

  /** Lower the item to the bottom of the stack.
   */
  void lower();

  //TODO: Use Cairo::RefPtr?
  
  bool get_transform(Cairo::Matrix* transform);
  
  void set_transform(const Cairo::Matrix* transform);
  
  void set_simple_transform(double x, double y, double scale, double rotation);
  
  void translate(double tx, double ty);
  
  void scale(double sx, double sy);
  
  void rotate(double degrees, double cx, double cy);
  
  void skew_x(double degrees, double cx, double cy);
  
  void skew_y(double degrees, double cx, double cy);

  
  Glib::RefPtr<Style> get_style();
  
  Glib::RefPtr<const Style> get_style() const;
  
  void set_style(const Glib::RefPtr<Style>& style);

  
  void animate(double x, double y, double scale, double degrees, bool absolute, int duration, int step_time, AnimateType animate_type);
  
  void stop_animation();

protected:


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

}


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Goocanvas::ItemModel
   */
  Glib::RefPtr<Goocanvas::ItemModel> wrap(GooCanvasItemModel* object, bool take_copy = false);

} // namespace Glib


#endif /* _GOOCANVASMM_ITEMMODEL_H */

