/* GStreamer - Matroska Demuxer
 * Copyright (C) <2003> Ronald Bultje <rbultje@ronald.bitfreak.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_MATROSKA_DEMUX_H__
#define __GST_MATROSKA_DEMUX_H__

#include <gst/gst.h>
#include <gst/gstbytestream.h>
#include "gstmatroska-io.h"

using namespace std;
using namespace LIBMATROSKA_NAMESPACE;

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GST_TYPE_MATROSKA_DEMUX \
  (gst_matroska_demux_get_type())
#define GST_MATROSKA_DEMUX(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_MATROSKA_DEMUX,GstMatroskaDemux))
#define GST_MATROSKA_DEMUX_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_MATROSKA_DEMUX,GstMatroskaDemux))
#define GST_IS_MATROSKA_DEMUX(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_MATROSKA_DEMUX))
#define GST_IS_MATROSKA_DEMUX_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_MATROSKA_DEMUX))

#define GST_MATROSKA_DEMUX_MAX_STREAMS	64	

typedef struct _GstMatroskaDemux GstMatroskaDemux;
typedef struct _GstMatroskaDemuxClass GstMatroskaDemuxClass;

typedef struct {
  GstPad       *pad;
  gint 		index;

  /* the track and some often-used info */
  gchar        *name, *language;
  track_type    type;
  guint         uid, num;
  guint32       flags;
  guint64       default_duration;

  /* current position */
  guint64       pos;
} GstMatroskaSrcContext;

/* flags */

/* should this track be shown? */
#define GST_MATROSKA_SRC_ENABLED (1<<0)
/* is this the default track of its type? */
#define GST_MATROSKA_SRC_DEFAULT (1<<1)
/* are there multiple buffers per block? */
#define GST_MATROSKA_SRC_LACING  (1<<1)

#define GST_MATROSKA_SUBTYPE_SHIFT 16

typedef enum {
  eye_mode_mono  = 0x0,
  eye_mode_right = 0x1,
  eye_mode_left  = 0x2,
  eye_mode_both  = 0x3,
} eye_mode;

typedef enum {
  aspect_free  = 0x0,
  keep_aspect  = 0x1,
  aspect_fixed = 0x2,
} aspect_ratio_type;

typedef struct {
  GstMatroskaSrcContext parent;

  guint         pixel_width, pixel_height,
                display_width, display_height;
  gfloat        framerate;
  eye_mode      mode;
  aspect_ratio_type asr;
  guint32       fourcc;
} GstMatroskaVideoSrcContext;

/* more flags */

/* is the video interlaced? */
#define GST_MATROSKA_SRC_VIDEO_INTERLACED (1<<(0+GST_MATROSKA_SUBTYPE_SHIFT))

typedef struct {
  GstMatroskaSrcContext parent;

  gint          samplerate, channels, bitdepth;
} GstMatroskaAudioSrcContext;

typedef struct {
  GstMatroskaSrcContext parent;

  /* nothing special goes here, apparently */
} GstMatroskaComplexSrcContext;

typedef struct {
  GstMatroskaSrcContext parent;

  /* or here... */
} GstMatroskaSubtitleSrcContext;

typedef enum {
  GST_MATROSKA_DEMUX_START,
  GST_MATROSKA_DEMUX_HEADER,
  GST_MATROSKA_DEMUX_FILE
} GstMatroskaDemuxState;

typedef struct {
  guint64        pos;   /* of the corresponding *cluster*! */
  guint16        track; /* reference to 'num' */
  guint64        time;  /* in nanoseconds */
} GstMatroskaDemuxIndex;

struct _GstMatroskaDemux {
  GstElement 	 element;

  /* pads */
  GstPad 	*sinkpad;
  GstMatroskaIO *io;
  GstMatroskaSrcContext *src[GST_MATROSKA_DEMUX_MAX_STREAMS];
  guint          num_streams,
                 num_v_streams, num_a_streams, num_t_streams;

  /* metadata */
  GstCaps       *metadata,
		*streaminfo;
  gchar         *muxing_app, *writing_app; /* cache */

  /* state */
  GstMatroskaDemuxState state;

  /* file data */
  EbmlStream    *str;
  KaxSegment    *segment;

  /* cache element info */
  EbmlElement   *last_el;
  gint           last_level;

  /* and at last, a cue (index) table */
  GstMatroskaDemuxIndex *index;
  guint          num_indexes;

  /* timescale in the file */
  guint64        time_scale;

  /* length */
  guint64        duration;

  /* a possible pending seek */
  guint64 seek_pending;
};

struct _GstMatroskaDemuxClass {
  GstElementClass parent_class;
};

GType 		gst_matroska_demux_get_type	(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GST_MATROSKA_DEMUX_H__ */
