/* GStreamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_XWINDOW_H__
#define __GST_XWINDOW_H__

#include <glib.h>
#include <X11/Xlib.h>

G_BEGIN_DECLS

typedef struct _GstXWindow	      GstXWindow;

#define GST_XWINDOW_XID(window)	((window)->win)

struct _GstXWindow
{
  Screen *screen;
  Display *disp;
  Window root, win;
  gulong white, black;
  gint screen_num;
  gint width, height;
  gint depth;
  GC gc;

  gboolean die;
  gboolean imagecount;

  gboolean have_xvideo;
  gboolean have_shm;

  GPtrArray *image_formats;
};


GstXWindow* 	_gst_xwindow_new 	(gint width, gint height, gboolean toplevel);
void 		_gst_xwindow_destroy 	(GstXWindow *window);

void		_gst_xwindow_ref	(GstXWindow * window);
void		_gst_xwindow_unref	(GstXWindow * window);


void 		_gst_xwindow_resize 	(GstXWindow *window, gint width, gint height);

G_END_DECLS

#endif /* __GST_XWINDOW_H__ */
