
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <gstreamermm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "audioclock.h"
#include "audiofilter.h"
#include "audiosink.h"
#include "audiosrc.h"
#include "baseaudiosink.h"
#include "baseaudiosrc.h"
#include "basesink.h"
#include "basesrc.h"
#include "basetransform.h"
#include "bin.h"
#include "buffer.h"
#include "bufferlist.h"
#include "bus.h"
#include "caps.h"
#include "cddabasesrc.h"
#include "childproxy.h"
#include "clock.h"
#include "colorbalancechannel.h"
#include "colorbalance.h"
#include "elementfactory.h"
#include "element.h"
#include "enums.h"
#include "error.h"
#include "event.h"
#include "filter.h"
#include "format.h"
#include "ghostpad.h"
#include "indexfactory.h"
#include "index.h"
#include "interface.h"
#include "iterator.h"
#include "message.h"
#include "mixer.h"
#include "mixeroptions.h"
#include "mixertrack.h"
#include "navigation.h"
#include "object.h"
#include "pad.h"
#include "padtemplate.h"
#include "parse.h"
#include "pipeline.h"
#include "pluginfeature.h"
#include "plugin.h"
#include "preset.h"
#include "propertyprobe.h"
#include "pushsrc.h"
#include "query.h"
#include "registry.h"
#include "ringbuffer.h"
#include "segment.h"
#include "streamvolume.h"
#include "structure.h"
#include "systemclock.h"
#include "taglist.h"
#include "tagsetter.h"
#include "task.h"
#include "taskpool.h"
#include "tunerchannel.h"
#include "tuner.h"
#include "tunernorm.h"
#include "typefindfactory.h"
#include "typefind.h"
#include "urihandler.h"
#include "value.h"
#include "videoorientation.h"
#include "videosink.h"
#include "xml.h"
#include "xoverlay.h"
#include "adder.h"
#include "alsamixer.h"
#include "alsasink.h"
#include "alsasrc.h"
#include "audioconvert.h"
#include "audiorate.h"
#include "audioresample.h"
#include "audiotestsrc.h"
#include "capsfilter.h"
#include "cdparanoiasrc.h"
#include "clockoverlay.h"
#include "decodebin2.h"
#include "decodebin.h"
#include "fakesink.h"
#include "fakesrc.h"
#include "fdsink.h"
#include "fdsrc.h"
#include "ffmpegcolorspace.h"
#include "filesink.h"
#include "filesrc.h"
#include "gdpdepay.h"
#include "gdppay.h"
#include "giosink.h"
#include "giosrc.h"
#include "giostreamsink.h"
#include "giostreamsrc.h"
#include "identity.h"
#include "multifdsink.h"
#include "multiqueue.h"
#include "oggdemux.h"
#include "oggmux.h"
#include "playbin2.h"
#include "playbin.h"
#include "queue.h"
#include "queue2.h"
#include "subtitleoverlay.h"
#include "tcpclientsink.h"
#include "tcpclientsrc.h"
#include "tcpserversink.h"
#include "tcpserversrc.h"
#include "tee.h"
#include "textoverlay.h"
#include "textrender.h"
#include "theoradec.h"
#include "theoraenc.h"
#include "theoraparse.h"
#include "timeoverlay.h"
#include "typefindelement.h"
#include "uridecodebin.h"
#include "videorate.h"
#include "videoscale.h"
#include "videotestsrc.h"
#include "volume.h"
#include "vorbisdec.h"
#include "vorbisenc.h"
#include "vorbisparse.h"
#include "vorbistag.h"
#include "ximagesink.h"
#include "xvimagesink.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType gst_adder_get_type(void);
GType gst_alsa_mixer_element_get_type(void);
GType gst_alsa_sink_get_type(void);
GType gst_alsa_src_get_type(void);
GType gst_audio_clock_get_type(void);
GType gst_audio_convert_get_type(void);
GType gst_audio_filter_get_type(void);
GType gst_audio_rate_get_type(void);
GType gst_audio_resample_get_type(void);
GType gst_audio_sink_get_type(void);
GType gst_audio_src_get_type(void);
GType gst_audio_test_src_get_type(void);
GType gst_base_audio_sink_get_type(void);
GType gst_base_audio_src_get_type(void);
GType gst_base_sink_get_type(void);
GType gst_base_src_get_type(void);
GType gst_base_transform_get_type(void);
GType gst_bin_get_type(void);
GType gst_bus_get_type(void);
GType gst_caps_filter_get_type(void);
GType gst_cd_paranoia_src_get_type(void);
GType gst_cdda_base_src_get_type(void);
GType gst_clock_get_type(void);
GType gst_clock_overlay_get_type(void);
GType gst_color_balance_channel_get_type(void);
GType gst_decode_bin_get_type(void);
GType gst_decode_bin2_get_type(void);
GType gst_element_get_type(void);
GType gst_element_factory_get_type(void);
GType gst_fake_sink_get_type(void);
GType gst_fake_src_get_type(void);
GType gst_fd_sink_get_type(void);
GType gst_fd_src_get_type(void);
GType gst_ff_mpeg_csp_get_type(void);
GType gst_file_sink_get_type(void);
GType gst_file_src_get_type(void);
GType gst_gdp_depay_get_type(void);
GType gst_gdp_pay_get_type(void);
GType gst_ghost_pad_get_type(void);
GType gst_gio_sink_get_type(void);
GType gst_gio_src_get_type(void);
GType gst_gio_stream_sink_get_type(void);
GType gst_gio_stream_src_get_type(void);
GType gst_identity_get_type(void);
GType gst_index_get_type(void);
GType gst_index_factory_get_type(void);
GType gst_mixer_options_get_type(void);
GType gst_mixer_track_get_type(void);
GType gst_multi_fd_sink_get_type(void);
GType gst_multi_queue_get_type(void);
GType gst_object_get_type(void);
GType gst_ogg_demux_get_type(void);
GType gst_ogg_mux_get_type(void);
GType gst_pad_get_type(void);
GType gst_pad_template_get_type(void);
GType gst_pipeline_get_type(void);
GType gst_play_bin_get_type(void);
GType gst_play_bin2_get_type(void);
GType gst_plugin_get_type(void);
GType gst_plugin_feature_get_type(void);
GType gst_push_src_get_type(void);
GType gst_queue_get_type(void);
GType gst_queue2_get_type(void);
GType gst_registry_get_type(void);
GType gst_ring_buffer_get_type(void);
GType gst_subtitle_overlay_get_type(void);
GType gst_system_clock_get_type(void);
GType gst_tcp_client_sink_get_type(void);
GType gst_tcp_client_src_get_type(void);
GType gst_tcp_server_src_get_type(void);
GType gst_task_get_type(void);
GType gst_task_pool_get_type(void);
GType gst_tcp_server_sink_get_type(void);
GType gst_tee_get_type(void);
GType gst_text_overlay_get_type(void);
GType gst_text_render_get_type(void);
GType gst_theora_dec_get_type(void);
GType gst_theora_enc_get_type(void);
GType gst_theora_parse_get_type(void);
GType gst_time_overlay_get_type(void);
GType gst_tuner_channel_get_type(void);
GType gst_tuner_norm_get_type(void);
GType gst_type_find_element_get_type(void);
GType gst_type_find_factory_get_type(void);
GType gst_uri_decode_bin_get_type(void);
GType gst_video_rate_get_type(void);
GType gst_video_scale_get_type(void);
GType gst_video_sink_get_type(void);
GType gst_video_test_src_get_type(void);
GType gst_volume_get_type(void);
GType gst_vorbis_dec_get_type(void);
GType gst_vorbis_enc_get_type(void);
GType gst_vorbis_parse_get_type(void);
GType gst_vorbis_tag_get_type(void);
GType gst_x_image_sink_get_type(void);
GType gst_xml_get_type(void);
GType gst_xv_image_sink_get_type(void);

//Declarations of the *_error_quark() functions:

GQuark gst_core_error_quark(void);
GQuark gst_library_error_quark(void);
GQuark gst_parse_error_quark(void);
GQuark gst_plugin_error_quark(void);
GQuark gst_resource_error_quark(void);
GQuark gst_stream_error_quark(void);
} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Gst {  class Adder_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class AlsaMixer_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class AlsaSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class AlsaSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class AudioClock_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class AudioConvert_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class AudioFilter_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class AudioRate_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class AudioResample_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class AudioSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class AudioSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class AudioTestSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class BaseAudioSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class BaseAudioSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class BaseSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class BaseSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class BaseTransform_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Bin_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Bus_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class CapsFilter_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class CdParanoiaSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class CddaBaseSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Clock_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class ClockOverlay_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class ColorBalanceChannel_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class DecodeBin_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class DecodeBin2_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Element_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class ElementFactory_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class FakeSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class FakeSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class FdSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class FdSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class FfmpegColorSpace_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class FileSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class FileSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class GDPDepay_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class GDPPay_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class GhostPad_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class GioSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class GioSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class GioStreamSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class GioStreamSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Identity_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Index_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class IndexFactory_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class MixerOptions_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class MixerTrack_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class MultiFdSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class MultiQueue_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Object_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class OggDemux_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class OggMux_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Pad_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class PadTemplate_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Pipeline_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class PlayBin_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class PlayBin2_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Plugin_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class PluginFeature_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class PushSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Queue_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Queue2_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Registry_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class RingBuffer_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class SubtitleOverlay_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class SystemClock_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class TCPClientSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class TCPClientSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class TCPServerSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Task_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class TaskPool_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class TcpServerSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Tee_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class TextOverlay_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class TextRender_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class TheoraDec_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class TheoraEnc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class TheoraParse_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class TimeOverlay_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class TunerChannel_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class TunerNorm_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class TypeFindElement_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class TypeFindFactory_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class UriDecodeBin_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class VideoRate_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class VideoScale_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class VideoSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class VideoTestSrc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class Volume_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class VorbisDec_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class VorbisEnc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class VorbisParse_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class VorbisTag_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class XImageSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class XML_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gst {  class XvImageSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }

namespace Gst { 

void wrap_init()
{
  // Register Error domains:
  Glib::Error::register_domain(gst_core_error_quark(), &::Gst::CoreError::throw_func);
  Glib::Error::register_domain(gst_library_error_quark(), &::Gst::LibraryError::throw_func);
  Glib::Error::register_domain(gst_parse_error_quark(), &::Gst::ParseError::throw_func);
  Glib::Error::register_domain(gst_plugin_error_quark(), &::Gst::PluginError::throw_func);
  Glib::Error::register_domain(gst_resource_error_quark(), &::Gst::ResourceError::throw_func);
  Glib::Error::register_domain(gst_stream_error_quark(), &::Gst::StreamError::throw_func);

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(gst_adder_get_type(), &Gst::Adder_Class::wrap_new);
  Glib::wrap_register(gst_alsa_mixer_element_get_type(), &Gst::AlsaMixer_Class::wrap_new);
  Glib::wrap_register(gst_alsa_sink_get_type(), &Gst::AlsaSink_Class::wrap_new);
  Glib::wrap_register(gst_alsa_src_get_type(), &Gst::AlsaSrc_Class::wrap_new);
  Glib::wrap_register(gst_audio_clock_get_type(), &Gst::AudioClock_Class::wrap_new);
  Glib::wrap_register(gst_audio_convert_get_type(), &Gst::AudioConvert_Class::wrap_new);
  Glib::wrap_register(gst_audio_filter_get_type(), &Gst::AudioFilter_Class::wrap_new);
  Glib::wrap_register(gst_audio_rate_get_type(), &Gst::AudioRate_Class::wrap_new);
  Glib::wrap_register(gst_audio_resample_get_type(), &Gst::AudioResample_Class::wrap_new);
  Glib::wrap_register(gst_audio_sink_get_type(), &Gst::AudioSink_Class::wrap_new);
  Glib::wrap_register(gst_audio_src_get_type(), &Gst::AudioSrc_Class::wrap_new);
  Glib::wrap_register(gst_audio_test_src_get_type(), &Gst::AudioTestSrc_Class::wrap_new);
  Glib::wrap_register(gst_base_audio_sink_get_type(), &Gst::BaseAudioSink_Class::wrap_new);
  Glib::wrap_register(gst_base_audio_src_get_type(), &Gst::BaseAudioSrc_Class::wrap_new);
  Glib::wrap_register(gst_base_sink_get_type(), &Gst::BaseSink_Class::wrap_new);
  Glib::wrap_register(gst_base_src_get_type(), &Gst::BaseSrc_Class::wrap_new);
  Glib::wrap_register(gst_base_transform_get_type(), &Gst::BaseTransform_Class::wrap_new);
  Glib::wrap_register(gst_bin_get_type(), &Gst::Bin_Class::wrap_new);
  Glib::wrap_register(gst_bus_get_type(), &Gst::Bus_Class::wrap_new);
  Glib::wrap_register(gst_caps_filter_get_type(), &Gst::CapsFilter_Class::wrap_new);
  Glib::wrap_register(gst_cd_paranoia_src_get_type(), &Gst::CdParanoiaSrc_Class::wrap_new);
  Glib::wrap_register(gst_cdda_base_src_get_type(), &Gst::CddaBaseSrc_Class::wrap_new);
  Glib::wrap_register(gst_clock_get_type(), &Gst::Clock_Class::wrap_new);
  Glib::wrap_register(gst_clock_overlay_get_type(), &Gst::ClockOverlay_Class::wrap_new);
  Glib::wrap_register(gst_color_balance_channel_get_type(), &Gst::ColorBalanceChannel_Class::wrap_new);
  Glib::wrap_register(gst_decode_bin_get_type(), &Gst::DecodeBin_Class::wrap_new);
  Glib::wrap_register(gst_decode_bin2_get_type(), &Gst::DecodeBin2_Class::wrap_new);
  Glib::wrap_register(gst_element_get_type(), &Gst::Element_Class::wrap_new);
  Glib::wrap_register(gst_element_factory_get_type(), &Gst::ElementFactory_Class::wrap_new);
  Glib::wrap_register(gst_fake_sink_get_type(), &Gst::FakeSink_Class::wrap_new);
  Glib::wrap_register(gst_fake_src_get_type(), &Gst::FakeSrc_Class::wrap_new);
  Glib::wrap_register(gst_fd_sink_get_type(), &Gst::FdSink_Class::wrap_new);
  Glib::wrap_register(gst_fd_src_get_type(), &Gst::FdSrc_Class::wrap_new);
  Glib::wrap_register(gst_ff_mpeg_csp_get_type(), &Gst::FfmpegColorSpace_Class::wrap_new);
  Glib::wrap_register(gst_file_sink_get_type(), &Gst::FileSink_Class::wrap_new);
  Glib::wrap_register(gst_file_src_get_type(), &Gst::FileSrc_Class::wrap_new);
  Glib::wrap_register(gst_gdp_depay_get_type(), &Gst::GDPDepay_Class::wrap_new);
  Glib::wrap_register(gst_gdp_pay_get_type(), &Gst::GDPPay_Class::wrap_new);
  Glib::wrap_register(gst_ghost_pad_get_type(), &Gst::GhostPad_Class::wrap_new);
  Glib::wrap_register(gst_gio_sink_get_type(), &Gst::GioSink_Class::wrap_new);
  Glib::wrap_register(gst_gio_src_get_type(), &Gst::GioSrc_Class::wrap_new);
  Glib::wrap_register(gst_gio_stream_sink_get_type(), &Gst::GioStreamSink_Class::wrap_new);
  Glib::wrap_register(gst_gio_stream_src_get_type(), &Gst::GioStreamSrc_Class::wrap_new);
  Glib::wrap_register(gst_identity_get_type(), &Gst::Identity_Class::wrap_new);
  Glib::wrap_register(gst_index_get_type(), &Gst::Index_Class::wrap_new);
  Glib::wrap_register(gst_index_factory_get_type(), &Gst::IndexFactory_Class::wrap_new);
  Glib::wrap_register(gst_mixer_options_get_type(), &Gst::MixerOptions_Class::wrap_new);
  Glib::wrap_register(gst_mixer_track_get_type(), &Gst::MixerTrack_Class::wrap_new);
  Glib::wrap_register(gst_multi_fd_sink_get_type(), &Gst::MultiFdSink_Class::wrap_new);
  Glib::wrap_register(gst_multi_queue_get_type(), &Gst::MultiQueue_Class::wrap_new);
  Glib::wrap_register(gst_object_get_type(), &Gst::Object_Class::wrap_new);
  Glib::wrap_register(gst_ogg_demux_get_type(), &Gst::OggDemux_Class::wrap_new);
  Glib::wrap_register(gst_ogg_mux_get_type(), &Gst::OggMux_Class::wrap_new);
  Glib::wrap_register(gst_pad_get_type(), &Gst::Pad_Class::wrap_new);
  Glib::wrap_register(gst_pad_template_get_type(), &Gst::PadTemplate_Class::wrap_new);
  Glib::wrap_register(gst_pipeline_get_type(), &Gst::Pipeline_Class::wrap_new);
  Glib::wrap_register(gst_play_bin_get_type(), &Gst::PlayBin_Class::wrap_new);
  Glib::wrap_register(gst_play_bin2_get_type(), &Gst::PlayBin2_Class::wrap_new);
  Glib::wrap_register(gst_plugin_get_type(), &Gst::Plugin_Class::wrap_new);
  Glib::wrap_register(gst_plugin_feature_get_type(), &Gst::PluginFeature_Class::wrap_new);
  Glib::wrap_register(gst_push_src_get_type(), &Gst::PushSrc_Class::wrap_new);
  Glib::wrap_register(gst_queue_get_type(), &Gst::Queue_Class::wrap_new);
  Glib::wrap_register(gst_queue2_get_type(), &Gst::Queue2_Class::wrap_new);
  Glib::wrap_register(gst_registry_get_type(), &Gst::Registry_Class::wrap_new);
  Glib::wrap_register(gst_ring_buffer_get_type(), &Gst::RingBuffer_Class::wrap_new);
  Glib::wrap_register(gst_subtitle_overlay_get_type(), &Gst::SubtitleOverlay_Class::wrap_new);
  Glib::wrap_register(gst_system_clock_get_type(), &Gst::SystemClock_Class::wrap_new);
  Glib::wrap_register(gst_tcp_client_sink_get_type(), &Gst::TCPClientSink_Class::wrap_new);
  Glib::wrap_register(gst_tcp_client_src_get_type(), &Gst::TCPClientSrc_Class::wrap_new);
  Glib::wrap_register(gst_tcp_server_src_get_type(), &Gst::TCPServerSrc_Class::wrap_new);
  Glib::wrap_register(gst_task_get_type(), &Gst::Task_Class::wrap_new);
  Glib::wrap_register(gst_task_pool_get_type(), &Gst::TaskPool_Class::wrap_new);
  Glib::wrap_register(gst_tcp_server_sink_get_type(), &Gst::TcpServerSink_Class::wrap_new);
  Glib::wrap_register(gst_tee_get_type(), &Gst::Tee_Class::wrap_new);
  Glib::wrap_register(gst_text_overlay_get_type(), &Gst::TextOverlay_Class::wrap_new);
  Glib::wrap_register(gst_text_render_get_type(), &Gst::TextRender_Class::wrap_new);
  Glib::wrap_register(gst_theora_dec_get_type(), &Gst::TheoraDec_Class::wrap_new);
  Glib::wrap_register(gst_theora_enc_get_type(), &Gst::TheoraEnc_Class::wrap_new);
  Glib::wrap_register(gst_theora_parse_get_type(), &Gst::TheoraParse_Class::wrap_new);
  Glib::wrap_register(gst_time_overlay_get_type(), &Gst::TimeOverlay_Class::wrap_new);
  Glib::wrap_register(gst_tuner_channel_get_type(), &Gst::TunerChannel_Class::wrap_new);
  Glib::wrap_register(gst_tuner_norm_get_type(), &Gst::TunerNorm_Class::wrap_new);
  Glib::wrap_register(gst_type_find_element_get_type(), &Gst::TypeFindElement_Class::wrap_new);
  Glib::wrap_register(gst_type_find_factory_get_type(), &Gst::TypeFindFactory_Class::wrap_new);
  Glib::wrap_register(gst_uri_decode_bin_get_type(), &Gst::UriDecodeBin_Class::wrap_new);
  Glib::wrap_register(gst_video_rate_get_type(), &Gst::VideoRate_Class::wrap_new);
  Glib::wrap_register(gst_video_scale_get_type(), &Gst::VideoScale_Class::wrap_new);
  Glib::wrap_register(gst_video_sink_get_type(), &Gst::VideoSink_Class::wrap_new);
  Glib::wrap_register(gst_video_test_src_get_type(), &Gst::VideoTestSrc_Class::wrap_new);
  Glib::wrap_register(gst_volume_get_type(), &Gst::Volume_Class::wrap_new);
  Glib::wrap_register(gst_vorbis_dec_get_type(), &Gst::VorbisDec_Class::wrap_new);
  Glib::wrap_register(gst_vorbis_enc_get_type(), &Gst::VorbisEnc_Class::wrap_new);
  Glib::wrap_register(gst_vorbis_parse_get_type(), &Gst::VorbisParse_Class::wrap_new);
  Glib::wrap_register(gst_vorbis_tag_get_type(), &Gst::VorbisTag_Class::wrap_new);
  Glib::wrap_register(gst_x_image_sink_get_type(), &Gst::XImageSink_Class::wrap_new);
  Glib::wrap_register(gst_xml_get_type(), &Gst::XML_Class::wrap_new);
  Glib::wrap_register(gst_xv_image_sink_get_type(), &Gst::XvImageSink_Class::wrap_new);

  // Register the gtkmm gtypes:
  Gst::Adder::get_type();
  Gst::AlsaMixer::get_type();
  Gst::AlsaSink::get_type();
  Gst::AlsaSrc::get_type();
  Gst::AudioClock::get_type();
  Gst::AudioConvert::get_type();
  Gst::AudioFilter::get_type();
  Gst::AudioRate::get_type();
  Gst::AudioResample::get_type();
  Gst::AudioSink::get_type();
  Gst::AudioSrc::get_type();
  Gst::AudioTestSrc::get_type();
  Gst::BaseAudioSink::get_type();
  Gst::BaseAudioSrc::get_type();
  Gst::BaseSink::get_type();
  Gst::BaseSrc::get_type();
  Gst::BaseTransform::get_type();
  Gst::Bin::get_type();
  Gst::Bus::get_type();
  Gst::CapsFilter::get_type();
  Gst::CdParanoiaSrc::get_type();
  Gst::CddaBaseSrc::get_type();
  Gst::Clock::get_type();
  Gst::ClockOverlay::get_type();
  Gst::ColorBalanceChannel::get_type();
  Gst::DecodeBin::get_type();
  Gst::DecodeBin2::get_type();
  Gst::Element::get_type();
  Gst::ElementFactory::get_type();
  Gst::FakeSink::get_type();
  Gst::FakeSrc::get_type();
  Gst::FdSink::get_type();
  Gst::FdSrc::get_type();
  Gst::FfmpegColorSpace::get_type();
  Gst::FileSink::get_type();
  Gst::FileSrc::get_type();
  Gst::GDPDepay::get_type();
  Gst::GDPPay::get_type();
  Gst::GhostPad::get_type();
  Gst::GioSink::get_type();
  Gst::GioSrc::get_type();
  Gst::GioStreamSink::get_type();
  Gst::GioStreamSrc::get_type();
  Gst::Identity::get_type();
  Gst::Index::get_type();
  Gst::IndexFactory::get_type();
  Gst::MixerOptions::get_type();
  Gst::MixerTrack::get_type();
  Gst::MultiFdSink::get_type();
  Gst::MultiQueue::get_type();
  Gst::Object::get_type();
  Gst::OggDemux::get_type();
  Gst::OggMux::get_type();
  Gst::Pad::get_type();
  Gst::PadTemplate::get_type();
  Gst::Pipeline::get_type();
  Gst::PlayBin::get_type();
  Gst::PlayBin2::get_type();
  Gst::Plugin::get_type();
  Gst::PluginFeature::get_type();
  Gst::PushSrc::get_type();
  Gst::Queue::get_type();
  Gst::Queue2::get_type();
  Gst::Registry::get_type();
  Gst::RingBuffer::get_type();
  Gst::SubtitleOverlay::get_type();
  Gst::SystemClock::get_type();
  Gst::TCPClientSink::get_type();
  Gst::TCPClientSrc::get_type();
  Gst::TCPServerSrc::get_type();
  Gst::Task::get_type();
  Gst::TaskPool::get_type();
  Gst::TcpServerSink::get_type();
  Gst::Tee::get_type();
  Gst::TextOverlay::get_type();
  Gst::TextRender::get_type();
  Gst::TheoraDec::get_type();
  Gst::TheoraEnc::get_type();
  Gst::TheoraParse::get_type();
  Gst::TimeOverlay::get_type();
  Gst::TunerChannel::get_type();
  Gst::TunerNorm::get_type();
  Gst::TypeFindElement::get_type();
  Gst::TypeFindFactory::get_type();
  Gst::UriDecodeBin::get_type();
  Gst::VideoRate::get_type();
  Gst::VideoScale::get_type();
  Gst::VideoSink::get_type();
  Gst::VideoTestSrc::get_type();
  Gst::Volume::get_type();
  Gst::VorbisDec::get_type();
  Gst::VorbisEnc::get_type();
  Gst::VorbisParse::get_type();
  Gst::VorbisTag::get_type();
  Gst::XImageSink::get_type();
  Gst::XML::get_type();
  Gst::XvImageSink::get_type();

} // wrap_init()

} //Gst


