/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2004, 2005 Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef GTH_BROWSER_UI_H
#define GTH_BROWSER_UI_H


#include <config.h>
#include "gth-window-actions-callbacks.h"
#include "gth-window-actions-entries.h"
#include "gth-browser-actions-callbacks.h"
#include "gth-browser-actions-entries.h"


static const gchar *main_ui_info =
"<ui>"
"  <menubar name='MenuBar'>"
"    <menu name='File' action='FileMenu'>"
"      <menuitem action='File_NewWindow'/>"
"      <separator name='sep01'/>"
"      <menuitem action='File_ViewImage'/>"
"      <menuitem action='File_OpenWith'/>"
"      <menuitem action='File_Save'/>"
"      <menuitem action='File_SaveAs'/>"
"      <menuitem action='File_Revert'/>"
"      <menuitem action='File_Print'/>"
"      <menuitem action='File_ImageProp'/>"
"      <separator name='sep02'/>"
"      <placeholder name='ContentPlaceholder'/>"
"      <separator name='sep03'/>"
"      <menuitem action='File_CameraImport'/>"
"      <menuitem action='File_WriteToCD'/>"
"      <separator name='sep04'/>"
"      <menuitem action='File_CloseWindow'/>"
"    </menu>"
"    <menu name='Edit' action='EditMenu'>"
"      <menuitem action='Edit_Undo'/>"
"      <menuitem action='Edit_Redo'/>"
"      <separator/>"
"      <menuitem action='Edit_RenameFile'/>"
"      <menuitem action='Edit_CopyFiles'/>"
"      <menuitem action='Edit_MoveFiles'/>"
"      <menuitem action='Edit_DuplicateFile'/>"
"      <menuitem action='Edit_DeleteFiles'/>"
"      <separator/>"
"      <menuitem action='Edit_SelectAll'/>"
"      <separator/>"
"      <menuitem action='Tools_FindImages'/>"
"      <menuitem action='Tools_FindDuplicates'/>"
"      <separator/>"
"      <menuitem action='Edit_EditComment'/>"
"      <menuitem action='Edit_EditCategories'/>"
"      <menuitem action='Edit_DeleteComment'/>"
"      <separator/>"
"      <menuitem action='Edit_AddToCatalog'/>"
"      <menuitem action='Edit_RemoveFromCatalog'/>"
"      <separator/>"
"      <menuitem action='Tools_Preferences'/>"
"    </menu>"
"    <menu name='View' action='ViewMenu'>"
"      <menu name='ShowHide' action='ViewShowHideMenu'>"
"        <menuitem action='View_ShowPreview'/>"
"        <menuitem action='View_ShowInfo'/>"
"        <separator/>"
"        <menuitem action='View_Toolbar'/>"
"        <menuitem action='View_Statusbar'/>"
"      </menu>"
"      <separator/>"
"      <menuitem action='View_Fullscreen'/>"
"      <menuitem action='Tools_Slideshow'/>"
"      <separator/>"
"      <menuitem action='View_AsSlides'/>"
"      <menuitem action='View_AsList'/>"
"      <separator/>"
"      <menuitem action='View_ShowFolders'/>"
"      <menuitem action='View_ShowCatalogs'/>"
"      <menuitem action='View_ShowImage'/>"
"      <separator/>"
"      <menu name='ViewSort' action='ViewSortMenu'>"
"        <menuitem action='SortByName'/>"
"        <menuitem action='SortByPath'/>"
"        <menuitem action='SortBySize'/>"
"        <menuitem action='SortByTime'/>"
"	 <menuitem action='SortByExifDate'/>"
"        <menuitem action='SortByComment'/>"
"        <menuitem action='SortManual'/>"
"        <separator/>"
"        <menuitem action='SortReversed'/>"
"      </menu>"
"      <separator/>"
"      <menu name='ZoomType' action='ViewZoomMenu'>"
"        <menuitem action='View_ZoomIn'/>"
"        <menuitem action='View_ZoomOut'/>"
"        <menuitem action='View_Zoom100'/>"
"        <menuitem action='View_ZoomFit'/>"
"        <menuitem action='View_ZoomWidth'/>"
"        <separator/>"
"        <menuitem action='View_ZoomQualityHigh'/>"
"        <menuitem action='View_ZoomQualityLow'/>"
"      </menu>"
"      <menuitem action='View_PlayAnimation'/>"
"      <menuitem action='View_StepAnimation'/>"
"      <separator/>"
"      <menuitem action='Go_Stop'/>"
"      <menuitem action='Go_Refresh'/>"
"    </menu>"
"    <menu name='Go' action='GoMenu'>"
"      <menuitem action='Go_Back'/>"
"      <menuitem action='Go_Forward'/>"
"      <menuitem action='Go_Up'/>"
"      <separator/>"
"      <menuitem action='Go_Home'/>"
"      <menuitem action='Go_ToContainer'/>"
"      <menuitem action='Go_Location'/>"
"      <separator/>"
"      <menuitem action='Go_DeleteHistory'/>"
"      <separator/>"
"      <placeholder name='HistoryList'/>"
"    </menu>"
"    <menu name='Bookmarks' action='BookmarksMenu'>"
"      <menuitem action='Bookmarks_Add'/>"
"      <menuitem action='Bookmarks_Edit'/>"
"      <separator/>"
"      <placeholder name='BookmarkList'/>"
"    </menu>"
"    <menu name='Image' action='ImageMenu'>"
"      <menuitem action='AlterImage_AdjustLevels'/>"
"      <menuitem action='AlterImage_Resize'/>"
"      <menuitem action='AlterImage_Crop'/>"
"      <menu name='Transform' action='ImageTransformMenu'>"
"        <menuitem action='AlterImage_Rotate90'/>"
"        <menuitem action='AlterImage_Rotate90CC'/>"
"        <menuitem action='AlterImage_Flip'/>"
"        <menuitem action='AlterImage_Mirror'/>"
"      </menu>"
"      <separator/>"
"      <menuitem action='AlterImage_Desaturate'/>"
"      <menuitem action='AlterImage_Invert'/>"
"      <menuitem action='AlterImage_ColorBalance'/>"
"      <menuitem action='AlterImage_HueSaturation'/>"
"      <menuitem action='AlterImage_BrightnessContrast'/>"
"      <menuitem action='AlterImage_Equalize'/>"
"      <menu name='DitherMenu' action='DitherMenu'>"
"        <menuitem action='AlterImage_Dither_Web'/>"
"        <menuitem action='AlterImage_Dither_BW'/>"
"        <separator/>"
"        <menuitem action='AlterImage_Posterize'/>"
"      </menu>"
"      <separator/>"
"      <menuitem action='AlterImage_RedeyeRemoval'/>"
"    </menu>"
"    <menu name='Tools' action='ToolsMenu'>"
"      <menu name='Wallpaper' action='ToolsWallpaperMenu'>"
"        <menuitem action='Wallpaper_Centered'/>"
"        <menuitem action='Wallpaper_Tiled'/>"
"        <menuitem action='Wallpaper_Scaled'/>"
"        <menuitem action='Wallpaper_Stretched'/>"
"        <separator/>"
"        <menuitem action='Wallpaper_Restore'/>"
"      </menu>"
"      <separator/>"
"      <menuitem action='Tools_JPEGRotate'/>"
"      <menuitem action='Tools_ResetExif'/>"
"      <separator/>"
"      <menuitem action='Tools_ScaleSeries'/>"
"      <menuitem action='Tools_ConvertFormat'/>"
"      <menuitem action='Tools_ChangeDate'/>"
"      <separator/>"
"      <menuitem action='Tools_IndexImage'/>"
"      <menuitem action='Tools_WebExporter'/>"
"    </menu>"
"    <menu name='Help' action='HelpMenu'>"
"      <menuitem action='Help_Help'/>"
"      <menuitem action='Help_Shortcuts'/>"
"      <separator/>"
"      <menuitem action='Help_About'/>"
"    </menu>"
"  </menubar>"
"  <toolbar name='ToolBar'>"
"    <placeholder name='ModeCommands'/>"
"  </toolbar>"
"  <popup name='FilePopup'>"
"    <menuitem action='File_ViewImage'/>"
"    <menuitem action='File_OpenWith'/>"
"    <menuitem action='File_Print'/>"
"    <menuitem action='Go_ToContainer'/>"
"    <separator/>"
"    <menu action='ToolsWallpaperMenu'>"
"      <menuitem action='Wallpaper_Centered'/>"
"      <menuitem action='Wallpaper_Tiled'/>"
"      <menuitem action='Wallpaper_Scaled'/>"
"      <menuitem action='Wallpaper_Stretched'/>"
"      <separator/>"
"      <menuitem action='Wallpaper_Restore'/>"
"    </menu>"
"    <separator/>"
"    <menuitem action='Edit_RenameFile'/>"
"    <menuitem action='Edit_CopyFiles'/>"
"    <menuitem action='Edit_MoveFiles'/>"
"    <menuitem action='Edit_DuplicateFile'/>"
"    <menuitem action='Edit_DeleteFiles'/>"
"    <separator/>"
"    <menuitem action='Edit_EditComment'/>"
"    <menuitem action='Edit_EditCategories'/>"
"    <menuitem action='Edit_DeleteComment'/>"
"    <separator/>"
"    <menuitem action='Edit_AddToCatalog'/>"
"    <menuitem action='Edit_RemoveFromCatalog'/>"
"    <separator/>"
"    <menuitem action='File_ImageProp'/>"
"  </popup>"
"  <popup name='ImagePopup'>"
"    <menuitem action='File_ViewImage'/>"
"    <menuitem action='Image_OpenWith'/>"
"    <menuitem action='File_Save'/>"
"    <menuitem action='File_SaveAs'/>"
"    <menuitem action='File_Print'/>"
"    <menuitem action='Go_ToContainer'/>"
"    <separator/>"
"    <menuitem action='View_Fullscreen'/>"
"    <separator/>"
"    <menu action='ToolsWallpaperMenu'>"
"      <menuitem action='Wallpaper_Centered'/>"
"      <menuitem action='Wallpaper_Tiled'/>"
"      <menuitem action='Wallpaper_Scaled'/>"
"      <menuitem action='Wallpaper_Stretched'/>"
"      <separator/>"
"      <menuitem action='Wallpaper_Restore'/>"
"    </menu>"
"    <separator/>"
"    <menuitem action='Image_Rename'/>"
"    <menuitem action='Image_Copy'/>"
"    <menuitem action='Image_Move'/>"
"    <menuitem action='Image_Delete'/>"
"    <separator/>"
"    <menuitem action='File_ImageProp'/>"
"  </popup>"
"  <popup name='FullscreenImagePopup'>"
"    <menuitem action='View_ExitFullscreen'/>"
"    <separator/>"
"    <menuitem action='Edit_EditComment'/>"
"    <menuitem action='Edit_EditCategories'/>"
"    <menuitem action='Edit_DeleteComment'/>"
"  </popup>"
"  <popup name='CatalogPopup'>"
"    <menuitem action='EditCatalog_View'/>"
"    <menuitem action='EditCatalog_View_NewWindow'/>"
"    <separator/>"
"    <menuitem action='EditCatalog_RedoSearch'/>"
"    <menuitem action='EditCatalog_EditSearch'/>"
"    <separator/>"
"    <menuitem action='EditCatalog_Rename'/>"
"    <menuitem action='EditCatalog_Delete'/>"
"    <menuitem action='EditCatalog_Move'/>"
"  </popup>"
"  <popup name='LibraryPopup'>"
"    <menuitem action='EditCatalog_View'/>"
"    <separator/>"
"    <menuitem action='EditCatalog_Rename'/>"
"    <menuitem action='EditCatalog_Delete'/>"
"    <menuitem action='EditCatalog_Move'/>"
"  </popup>"
"  <popup name='DirPopup'>"
"    <menuitem action='EditDir_View'/>"
"    <menuitem action='EditDir_View_NewWindow'/>"
"    <menuitem action='EditDir_Open'/>"
"    <separator/>"
"    <menuitem action='EditDir_Rename'/>"
"    <menuitem action='EditDir_Delete'/>"
"    <menuitem action='EditDir_Copy'/>"
"    <menuitem action='EditDir_Move'/>"
"    <separator/>"
"    <menuitem action='EditDir_Categories'/>"
"  </popup>"
"  <popup name='DirListPopup'>"
"    <menuitem action='EditCurrentDir_New'/>"
"  </popup>"
"  <popup name='CatalogListPopup'>"
"    <menuitem action='EditCurrentCatalog_New'/>"
"    <menuitem action='EditCurrentCatalog_NewLibrary'/>"
"  </popup>"
"  <popup name='HistoryListPopup'>"
"  </popup>"
"  <popup name='RotateImageMenu'>"
"    <menuitem action='Tools_JPEGRotate_Right'/>"
"    <menuitem action='Tools_JPEGRotate_Left'/>"
"    <separator/>"
"    <menuitem action='Tools_ResetExif'/>"
"  </popup>"
"  <accelerator name='ControlEqualAccel' action='ControlEqual'/>"
"</ui>";


static const gchar *folder_ui_info =
"<ui>"
"  <menubar name='MenuBar'>"
"    <menu name='File' action='FileMenu'>"
"      <placeholder name='ContentPlaceholder'>"
"        <menuitem action='EditCurrentDir_New'/>"
"        <menu name='Folder' action='FileFolderMenu'>"
"          <menuitem action='EditCurrentDir_Open'/>"
"          <separator/>"
"          <menuitem action='EditCurrentDir_Rename'/>"
"          <menuitem action='EditCurrentDir_Delete'/>"
"          <menuitem action='EditCurrentDir_Copy'/>"
"          <menuitem action='EditCurrentDir_Move'/>"
"          <separator/>"
"          <menuitem action='EditCurrentDir_Categories'/>"
"        </menu>"
"      </placeholder>"
"    </menu>"
"  </menubar>"
"</ui>";


static const gchar *catalog_ui_info =
"<ui>"
"  <menubar name='MenuBar'>"
"    <menu name='File' action='FileMenu'>"
"      <placeholder name='ContentPlaceholder'>"
"        <menuitem action='EditCurrentCatalog_New'/>"
"        <menuitem action='EditCurrentCatalog_NewLibrary'/>"
"        <menu name='Catalog' action='FileCatalogMenu'>"
"          <menuitem action='EditCurrentCatalog_Rename'/>"
"          <menuitem action='EditCurrentCatalog_Delete'/>"
"          <menuitem action='EditCurrentCatalog_Move'/>"
"        </menu>"
"      </placeholder>"
"    </menu>"
"  </menubar>"
"</ui>";


static const gchar *search_ui_info =
"<ui>"
"  <menubar name='MenuBar'>"
"    <menu name='File' action='FileMenu'>"
"      <placeholder name='ContentPlaceholder'>"
"        <menuitem action='EditCurrentCatalog_New'/>"
"        <menuitem action='EditCurrentCatalog_NewLibrary'/>"
"        <menu name='Search' action='FileSearchMenu'>"
"          <menuitem action='EditCurrentCatalog_RedoSearch'/>"
"          <menuitem action='EditCurrentCatalog_EditSearch'/>"
"          <separator name='EditCurrentCatalog_Sep'/>"
"          <menuitem action='EditCurrentCatalog_Rename'/>"
"          <menuitem action='EditCurrentCatalog_Delete'/>"
"          <menuitem action='EditCurrentCatalog_Move'/>"
"        </menu>"
"      </placeholder>"
"    </menu>"
"  </menubar>"
"</ui>";


static const gchar *browser_ui_info =
"<ui>"
"  <toolbar name='ToolBar'>"
"    <placeholder name='ModeCommands'>"
"      <toolitem action='View_ShowFolders'/>"
"      <toolitem action='View_ShowCatalogs'/>"
"      <separator/>"
"      <toolitem action='View_Fullscreen'/>"
"      <toolitem action='Tools_Slideshow'/>"
"      <separator/>"
"      <toolitem action='ToolBar_FindImages'/>"
"      <separator/>"
"      <toolitem action='ToolBar_EditComment'/>"
"      <toolitem action='ToolBar_EditCategories'/>"
"    </placeholder>"
"  </toolbar>"
"</ui>";

static const gchar *viewer_ui_info =
"<ui>"
"  <toolbar name='ToolBar'>"
"    <placeholder name='ModeCommands'>"
"      <toolitem action='View_CloseImageMode'/>"
"      <toolitem action='File_Save'/>"
"      <separator/>"
"      <toolitem action='View_PrevImage'/>"
"      <toolitem action='View_NextImage'/>"
"      <separator/>"
"      <toolitem action='View_Fullscreen'/>"
"      <separator/>"
"      <toolitem action='View_ZoomIn'/>"
"      <toolitem action='View_ZoomOut'/>"
"      <toolitem action='View_Zoom100'/>"
"      <toolitem action='View_ZoomFit'/>"
"      <toolitem action='View_ZoomWidth'/>"
"    </placeholder>"
"  </toolbar>"
"</ui>";

#endif /* GTH_BROWSER_UI_H */
