/* The Cairo CSS Drawing Library.
 * Copyright (C) 2008 Robert Staudinger
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#include <stdio.h>
#include <string.h>
#include "ccd-property.h"

ccd_property_spec_t
ccd_property_parse_spec (CRTerm const **value)
{
	char const *str;

	if (!*value) {
		return CCD_PROPERTY_SPEC_UNSET;
	} else if (TERM_IDENT == (*value)->type) {
		str = cr_string_peek_raw_str ((*value)->content.str);
		if (0 == strcmp ("none", str)) {
			*value = (*value)->next;
			return CCD_PROPERTY_SPEC_NONE;
		} else if (0 == strcmp ("inherit", str)) {
			g_warning ("Property `inherit' not supported yet.");
			*value = (*value)->next;
			return CCD_PROPERTY_SPEC_INHERIT;
		}
	}

	return CCD_PROPERTY_SPEC_SET;
}

void
ccd_property_spec_dump (ccd_property_spec_t const spec)
{
	switch (spec) {
	case CCD_PROPERTY_SPEC_UNSET:
		printf ("<unset>");
		break;
	case CCD_PROPERTY_SPEC_NONE:
		printf ("none");
		break;
	case CCD_PROPERTY_SPEC_INHERIT:
		printf ("<inherit>");
		break;
	case CCD_PROPERTY_SPEC_SET:
		/* Needs custom printing. */
		break;
	}
}

