/* The Cairo CSS Drawing Library.
 * Copyright (C) 2008 Robert Staudinger
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifndef CCD_PROPERTY_H
#define CCD_PROPERTY_H

#include <glib.h>
#include <libcroco/libcroco.h>
#include <ccd/ccd-features.h>

G_BEGIN_DECLS

#define CCD_PROPERTY_DUMP_PREFIX "    "

typedef enum {
	CCD_PROPERTY_SPEC_UNSET = 0,
	CCD_PROPERTY_SPEC_NONE,
	CCD_PROPERTY_SPEC_INHERIT,
	CCD_PROPERTY_SPEC_SET
} ccd_property_spec_t;

ccd_property_spec_t ccd_property_parse_spec (CRTerm const **value);

void ccd_property_spec_dump (ccd_property_spec_t const spec);

G_END_DECLS

#endif /* CCD_PROPERTY_H */

