// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_GL_CONFIG_H
#define _GDKMM_GL_CONFIG_H

#include <glibmm.h>

// -*- C++ -*-
/* gdkglextmm - C++ Wrapper for GdkGLExt
 * Copyright (C) 2002-2003  Naofumi Yasufuku
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.
 */

#include <gdkmm/gl/defs.h>

#ifdef GDKGLEXTMM_MULTIHEAD_SUPPORT
#include <gdkmm/screen.h>
#endif // GDKGLEXTMM_MULTIHEAD_SUPPORT
#include <gdkmm/visual.h>
#include <gdkmm/colormap.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkGLConfig GdkGLConfig;
typedef struct _GdkGLConfigClass GdkGLConfigClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

namespace GL
{ class Config_Class; } // namespace GL

} // namespace Gdk
namespace Gdk
{
namespace GL
{

/** @addtogroup gdkmm_glEnums Enums and Flags */

/**
 * @ingroup gdkmm_glEnums
 * @par Bitwise operators:
 * <tt>%ConfigMode operator|(ConfigMode, ConfigMode)</tt><br>
 * <tt>%ConfigMode operator&(ConfigMode, ConfigMode)</tt><br>
 * <tt>%ConfigMode operator^(ConfigMode, ConfigMode)</tt><br>
 * <tt>%ConfigMode operator~(ConfigMode)</tt><br>
 * <tt>%ConfigMode& operator|=(ConfigMode&, ConfigMode)</tt><br>
 * <tt>%ConfigMode& operator&=(ConfigMode&, ConfigMode)</tt><br>
 * <tt>%ConfigMode& operator^=(ConfigMode&, ConfigMode)</tt><br>
 */
enum ConfigMode
{
  MODE_RGB = 0,
  MODE_RGBA = 0,
  MODE_INDEX = 1 << 0,
  MODE_SINGLE = 0,
  MODE_DOUBLE = 1 << 1,
  MODE_STEREO = 1 << 2,
  MODE_ALPHA = 1 << 3,
  MODE_DEPTH = 1 << 4,
  MODE_STENCIL = 1 << 5,
  MODE_ACCUM = 1 << 6,
  MODE_MULTISAMPLE = 1 << 7
};

/** @ingroup gdkmm_glEnums */
inline ConfigMode operator|(ConfigMode lhs, ConfigMode rhs)
  { return static_cast<ConfigMode>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmm_glEnums */
inline ConfigMode operator&(ConfigMode lhs, ConfigMode rhs)
  { return static_cast<ConfigMode>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmm_glEnums */
inline ConfigMode operator^(ConfigMode lhs, ConfigMode rhs)
  { return static_cast<ConfigMode>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmm_glEnums */
inline ConfigMode operator~(ConfigMode flags)
  { return static_cast<ConfigMode>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmm_glEnums */
inline ConfigMode& operator|=(ConfigMode& lhs, ConfigMode rhs)
  { return (lhs = static_cast<ConfigMode>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmm_glEnums */
inline ConfigMode& operator&=(ConfigMode& lhs, ConfigMode rhs)
  { return (lhs = static_cast<ConfigMode>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmm_glEnums */
inline ConfigMode& operator^=(ConfigMode& lhs, ConfigMode rhs)
  { return (lhs = static_cast<ConfigMode>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace GL

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::GL::ConfigMode> : public Glib::Value_Flags<Gdk::GL::ConfigMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

namespace GL
{


  /** OpenGL frame buffer configuration.
   *
   *
   */


class Config : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Config CppObjectType;
  typedef Config_Class CppClassType;
  typedef GdkGLConfig BaseObjectType;
  typedef GdkGLConfigClass BaseClassType;

private:
  friend class Config_Class;
  static CppClassType config_class_;

  // noncopyable
  Config(const Config&);
  Config& operator=(const Config&);

protected:
  explicit Config(const Glib::ConstructParams& construct_params);
  explicit Config(GdkGLConfig* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Config();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GdkGLConfig*       gobj()       { return reinterpret_cast<GdkGLConfig*>(gobject_); }
  const GdkGLConfig* gobj() const { return reinterpret_cast<GdkGLConfig*>(gobject_); }

  GdkGLConfig* gobj_copy();

private:


protected:

  explicit Config(const int* attrib_list);
#ifdef GDKGLEXTMM_MULTIHEAD_SUPPORT
  Config(const Glib::RefPtr<const Gdk::Screen>& screen,
         const int* attrib_list);
#endif // GDKGLEXTMM_MULTIHEAD_SUPPORT
  explicit Config(ConfigMode mode);
#ifdef GDKGLEXTMM_MULTIHEAD_SUPPORT
  Config(const Glib::RefPtr<const Gdk::Screen>& screen,
         ConfigMode mode);
#endif // GDKGLEXTMM_MULTIHEAD_SUPPORT

public:

  /** Returns an OpenGL frame buffer configuration that match
   * the specified attributes.
   *
   * @param attrib_list  a list of attribute/value pairs. The last
   *                     attribute must be Gdk::GL::ATTRIB_LIST_NONE.
   * @return  the new Gdk::GL::Config if it is successful,
   *          NULL RefPtr otherwise.
   */
  static Glib::RefPtr<Config> create(const int* attrib_list);

#ifdef GDKGLEXTMM_MULTIHEAD_SUPPORT
  static Glib::RefPtr<Config> create(const Glib::RefPtr<const Gdk::Screen>& screen,
                                     const int* attrib_list);
#endif // GDKGLEXTMM_MULTIHEAD_SUPPORT

  /** Returns an OpenGL frame buffer configuration that match
   * the specified display mode.
   *
   * @param mode  display mode bit mask.
   * @return  the new Gdk::GL::Config if it is successful,
   *          NULL RefPtr otherwise.
   */
  static Glib::RefPtr<Config> create(ConfigMode mode);

#ifdef GDKGLEXTMM_MULTIHEAD_SUPPORT
  static Glib::RefPtr<Config> create(const Glib::RefPtr<const Gdk::Screen>& screen,
                                     ConfigMode mode);
#endif // GDKGLEXTMM_MULTIHEAD_SUPPORT

public:

#ifdef GDKGLEXTMM_MULTIHEAD_SUPPORT
  
  /** Get Gdk::Screen.
   * @return The Gdk::Screen.
   */
  Glib::RefPtr<Gdk::Screen> get_screen();
  
  /** Get Gdk::Screen.
   * @return The Gdk::Screen.
   */
  Glib::RefPtr<const Gdk::Screen> get_screen() const;

#endif // GDKGLEXTMM_MULTIHEAD_SUPPORT

  
  /** Gets information about a OpenGL frame buffer configuration.
   * @param attribute The attribute to be returned.
   * @param value Returns the requested value.
   * @return <tt>true</tt> if it succeeded, <tt>false</tt> otherwise.
   */
  bool get_attrib(int attribute, int& value) const;

  
  /** Gets the Gdk::Colormap that is appropriate for the OpenGL frame buffer
   * configuration.
   * @return The appropriate Gdk::Colormap.
   */
  Glib::RefPtr<Gdk::Colormap> get_colormap();
  
  /** Gets the Gdk::Colormap that is appropriate for the OpenGL frame buffer
   * configuration.
   * @return The appropriate Gdk::Colormap.
   */
  Glib::RefPtr<const Gdk::Colormap> get_colormap() const;

  
  /** Gets the Gdk::Visual that is appropriate for the OpenGL frame buffer
   * configuration.
   * @return The appropriate Gdk::Visual.
   */
  Glib::RefPtr<Gdk::Visual> get_visual();
  
  /** Gets the Gdk::Visual that is appropriate for the OpenGL frame buffer
   * configuration.
   * @return The appropriate Gdk::Visual.
   */
  Glib::RefPtr<const Gdk::Visual> get_visual() const;

  
  /** Gets the color depth of the OpenGL-capable visual.
   * @return Number of bits per pixel.
   */
  int get_depth() const;

  
  /** Gets the layer plane (level) of the frame buffer.
   * Zero is the default frame buffer.
   * Positive layer planes correspond to frame buffers that overlay the default
   * buffer, and negative layer planes correspond to frame buffers that underlie
   * the default frame buffer.
   * @return Layer plane.
   */
  int get_layer_plane() const;

  
  /** Gets the number of auxiliary color buffers.
   * @return Number of auxiliary color buffers.
   */
  int get_n_aux_buffers() const;

  
  /** Gets the number of multisample buffers.
   * @return Number of multisample buffers.
   */
  int get_n_sample_buffers() const;

  
  /** Returns whether the configured frame buffer is RGBA mode.
   * @return <tt>true</tt> if the configured frame buffer is RGBA mode, <tt>false</tt>
   * otherwise.
   */
  bool is_rgba() const;

  
  /** Returns whether the configuration supports the double-buffered visual.
   * @return <tt>true</tt> if the double-buffered visual is supported, <tt>false</tt>
   * otherwise.
   */
  bool is_double_buffered() const;

  
  /** Returns whether the configuration supports the stereo visual.
   * @return <tt>true</tt> if the stereo visual is supported, <tt>false</tt> otherwise.
   */
  bool is_stereo() const;

  
  /** Returns whether the configured color buffer has alpha bits.
   * @return <tt>true</tt> if the color buffer has alpha bits, <tt>false</tt> otherwise.
   */
  bool has_alpha() const;

  
  /** Returns whether the configured frame buffer has depth buffer.
   * @return <tt>true</tt> if the frame buffer has depth buffer, <tt>false</tt> otherwise.
   */
  bool has_depth_buffer() const;

  
  /** Returns whether the configured frame buffer has stencil buffer.
   * @return <tt>true</tt> if the frame buffer has stencil buffer, <tt>false</tt> otherwise.
   */
  bool has_stencil_buffer() const;

  
  /** Returns whether the configured frame buffer has accumulation buffer.
   * @return <tt>true</tt> if the frame buffer has accumulation buffer, <tt>false</tt>
   * otherwise.
   */
  bool has_accum_buffer() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace GL
} // namespace Gdk


namespace Glib
{
  /** @relates Gdk::GL::Config */
  Glib::RefPtr<Gdk::GL::Config> wrap(GdkGLConfig* object, bool take_copy = false);
}


#endif /* _GDKMM_GL_CONFIG_H */

