// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_GL_PIXMAP_H
#define _GDKMM_GL_PIXMAP_H

#include <glibmm.h>

// -*- C++ -*-
/* gdkglextmm - C++ Wrapper for GdkGLExt
 * Copyright (C) 2002-2003  Naofumi Yasufuku
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.
 */

#include <gdkmm/gl/defs.h>

#include <gdkmm/drawable.h>
#include <gdkmm/pixmap.h>

#include <gdkmm/gl/config.h>
#include <gdkmm/gl/drawable.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkGLPixmap GdkGLPixmap;
typedef struct _GdkGLPixmapClass GdkGLPixmapClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

namespace GL
{ class Pixmap_Class; } // namespace GL

} // namespace Gdk
namespace Gdk
{
namespace GL
{

  /** OpenGL pixmap which is maintained offscreen.
   *
   * @ingroup GLDrawables
   */


class Pixmap : public Gdk::Drawable,
               public Gdk::GL::Drawable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Pixmap CppObjectType;
  typedef Pixmap_Class CppClassType;
  typedef GdkGLPixmap BaseObjectType;
  typedef GdkGLPixmapClass BaseClassType;

private:
  friend class Pixmap_Class;
  static CppClassType pixmap_class_;

  // noncopyable
  Pixmap(const Pixmap&);
  Pixmap& operator=(const Pixmap&);

protected:
  explicit Pixmap(const Glib::ConstructParams& construct_params);
  explicit Pixmap(GdkGLPixmap* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Pixmap();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GdkGLPixmap*       gobj()       { return reinterpret_cast<GdkGLPixmap*>(gobject_); }
  const GdkGLPixmap* gobj() const { return reinterpret_cast<GdkGLPixmap*>(gobject_); }

  GdkGLPixmap* gobj_copy();

private:


protected:
  Pixmap(const Glib::RefPtr<const Config>& glconfig,
         const Glib::RefPtr<const Gdk::Pixmap>& pixmap,
         const int* attrib_list = 0);

public:
  
  static Glib::RefPtr<Pixmap> create(const Glib::RefPtr<const Config>& glconfig, const Glib::RefPtr<const Gdk::Pixmap>& pixmap, const int* attrib_list);


public:

  
  /** Returns the Gdk::Pixmap associated with @a glpixmap .
   * 
   * Notice that Gdk::GLPixmap is not Gdk::Pixmap, but another
   * Gdk::Drawable which have an associated Gdk::Pixmap.
   * @return The Gdk::Pixmap associated with @a glpixmap .
   */
  Glib::RefPtr<Gdk::Pixmap> get_pixmap();

  
  /** Returns the Gdk::Pixmap associated with @a glpixmap .
   * 
   * Notice that Gdk::GLPixmap is not Gdk::Pixmap, but another
   * Gdk::Drawable which have an associated Gdk::Pixmap.
   * @return The Gdk::Pixmap associated with @a glpixmap .
   */
  Glib::RefPtr<const Gdk::Pixmap> get_pixmap() const;

public:

  
  /** Set the OpenGL-capability to the @a pixmap .
   * The call creates a new Gdk::GLPixmap.
   * attrib_list is currently unused. This must be set to <tt>0</tt> or empty
   * (first attribute of None).
   * @param glconfig A Gdk::GLConfig.
   * @param attrib_list This must be set to <tt>0</tt> or empty (first attribute of None).
   * @return The Gdk::GLPixmap used by the @a pixmap  if it is successful,
   * <tt>0</tt> otherwise.
   */
  static Glib::RefPtr<Pixmap> set_gl_capability(const Glib::RefPtr<Gdk::Pixmap>& pixmap, const Glib::RefPtr<const Config>& glconfig, const int* attrib_list = 0);

  
  /** Unset the OpenGL-capability of the @a pixmap .
   * This function destroys the Gdk::GLPixmap held by the @a pixmap .
   */
  static void unset_gl_capability(const Glib::RefPtr<Gdk::Pixmap>& pixmap);

  
  /** Returns whether the @a pixmap  is OpenGL-capable.
   * @return <tt>true</tt> if the @a pixmap  is OpenGL-capable, <tt>false</tt> otherwise.
   */
  static bool is_gl_capable(const Glib::RefPtr<const Gdk::Pixmap>& pixmap);

  
  /** Returns the Gdk::GLPixmap held by the @a pixmap .
   * @return The Gdk::GLPixmap.
   */
  static Glib::RefPtr<Pixmap> get_gl_pixmap(const Glib::RefPtr<const Gdk::Pixmap>& pixmap);

  
  static Glib::RefPtr<Gdk::GL::Drawable> get_gl_drawable(const Glib::RefPtr<const Gdk::Pixmap>& pixmap);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

  /** @example pixmap.cc
   *
   * Simple offscreen OpenGL rendering example.
   * 
   */

  /** @example pixmap-mixed.cc
   *
   * Simple offscreen rendering example for mixing OpenGL and
   * GDK rendering.
   *
   */

} // namespace GL
} // namespace Gdk


namespace Glib
{
  /** @relates Gdk::GL::Pixmap */
  Glib::RefPtr<Gdk::GL::Pixmap> wrap(GdkGLPixmap* object, bool take_copy = false);
}


#endif /* _GDKMM_GL_PIXMAP_H */

