
#include <gtkmm/optionmenu.h>
#include <gtkmm/private/optionmenu_p.h>

// -*- c++ -*-
/* $Id: optionmenu.ccg,v 1.4 2002/03/09 00:53:11 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/menu.h>
#include <gtkmm/window.h>
#include <gtk/gtkoptionmenu.h>

namespace Gtk
{

void OptionMenu::on_realize()
{
  Button::on_realize();

  if(get_toplevel()->is_toplevel())
  {
    Gtk::Window* window = dynamic_cast<Gtk::Window*>(get_toplevel());
    if(window && get_menu())
      get_menu()->accelerate(*window);
  }
}


} /* namespace Gtk */


namespace
{

const Glib::SignalProxyInfo OptionMenu_signal_changed_info =
{
  "changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::OptionMenu* wrap(GtkOptionMenu* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::OptionMenu *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType OptionMenu_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_option_menu_get_type(), "gtkmm__OptionMenu", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void OptionMenu_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->changed = &changed_callback;
}


void OptionMenu_Class::changed_callback(GtkOptionMenu* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_changed();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->changed)
      (*base->changed)(self);
  }
}


Glib::ObjectBase* OptionMenu_Class::wrap_new(GObject* o)
{
  return manage(new OptionMenu((GtkOptionMenu*)(o)));
}


/* The implementation: */

OptionMenu::OptionMenu(GtkOptionMenu* castitem)
: Gtk::Button((GtkButton*)(castitem))
{}

OptionMenu::~OptionMenu()
{
  destroy_();
}

OptionMenu::CppClassType OptionMenu::optionmenu_class_; //Initialize static member.

GType OptionMenu::get_type()
{
  return optionmenu_class_.get_type();
}

GType OptionMenu::get_base_type()
{
  return gtk_option_menu_get_type();
}

OptionMenu::OptionMenu()
: Gtk::Button((GtkButton*)(g_object_new(get_type(), (char*)0)))
{}

void OptionMenu::set_menu(Menu & menu)
{
  gtk_option_menu_set_menu(gobj(), (menu).Gtk::Widget::gobj());
}

Menu* OptionMenu::get_menu()
{
  return Glib::wrap((GtkMenu*)(gtk_option_menu_get_menu(gobj())));
}

const Menu* OptionMenu::get_menu() const
{
  return Glib::wrap((GtkMenu*)(gtk_option_menu_get_menu(const_cast<GtkOptionMenu*>(gobj()))));
}

void OptionMenu::remove_menu()
{
  gtk_option_menu_remove_menu(gobj());
}

int OptionMenu::get_history() const
{
  return gtk_option_menu_get_history(const_cast<GtkOptionMenu*>(gobj()));
}

void OptionMenu::set_history(guint index)
{
  gtk_option_menu_set_history(gobj(), index);
}


Glib::SignalProxy0<void> OptionMenu::signal_changed()
{
  return Glib::SignalProxy0<void>(this, &OptionMenu_signal_changed_info);
}


void Gtk::OptionMenu::on_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->changed)
    (*base->changed)(gobj());
}


} // namespace Gtk

