
#include <gtkmm/stockitem.h>
#include <gtkmm/private/stockitem_p.h>

// -*- c++ -*-
/* $Id: stockitem.ccg,v 1.3 2001/11/16 19:03:40 murrayc Exp $ */

/*
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/texttag.h>
#include <gtkmm/textbuffer.h>


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::StockItem wrap(GtkStockItem* object, bool take_copy /* = false */)
{
  return Gtk::StockItem(object, take_copy);
}

} // namespace Glib


namespace Gtk
{


StockItem::StockItem()
:
  gobject_ (0) // Allows creation of invalid wrapper, e.g. for output arguments to methods.
{}

StockItem::StockItem(const StockItem& src)
:
  gobject_ ((src.gobject_) ? gtk_stock_item_copy(src.gobject_) : 0)
{}

StockItem::StockItem(GtkStockItem* castitem, bool make_a_copy /* = false */)
{
  if(!make_a_copy)
  {
    // It was given to us by a function which has already made a copy for us to keep.
    gobject_ = castitem;
  }
  else
  {
    // We are probably getting it via direct access to a struct,
    // so we can not just take it - we have to take a copy of it.
    if(castitem)
      gobject_ = gtk_stock_item_copy(castitem);
    else
      gobject_ = 0;
  }
}

StockItem& StockItem::operator=(const StockItem& src)
{
  GtkStockItem *const new_gobject = (src.gobject_) ? gtk_stock_item_copy(src.gobject_) : 0;

  if(gobject_)
    gtk_stock_item_free(gobject_);

  gobject_ = new_gobject;

  return *this;
}

StockItem::~StockItem()
{
  if(gobject_)
    gtk_stock_item_free(gobject_);
}

GtkStockItem* StockItem::gobj_copy() const
{
  return gtk_stock_item_copy(gobject_);
}

Glib::ustring StockItem::get_stock_id() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gobj()->stock_id);
}

Glib::ustring StockItem::get_label() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gobj()->label);
}

Gdk::ModifierType StockItem::get_modifier() const
{
  return ((Gdk::ModifierType)(gobj()->modifier));
}

guint StockItem::get_keyval() const
{
  return gobj()->keyval;
}

Glib::ustring StockItem::get_translation_domain() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gobj()->translation_domain);
}


} // namespace Gtk


