/* example-start buttonbox buttonbox.c */

#include <gtkmm/box.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/frame.h>
#include <gtkmm/button.h>
#include <gtkmm/window.h>
#include <gtkmm/main.h>

class BBox : public Gtk::Frame
{
public:
  BBox(gint horizontal,
       const Glib::ustring& title,
       gint  spacing,
       Gtk::ButtonBoxStyle  layout);
};

BBox::BBox(gint horizontal,
      const Glib::ustring& title,
      gint  spacing,
      Gtk::ButtonBoxStyle  layout)
  : Gtk::Frame(title)
{
  Gtk::ButtonBox *bbox;
  Gtk::Button *button;

  if (horizontal)
    bbox = manage( new Gtk::HButtonBox () );
  else
    bbox = manage( new Gtk::VButtonBox () );

  bbox->set_border_width (5);

  add (*bbox);

  /* Set the appearance of the Button Box */
  bbox->set_layout (layout);
  bbox->set_spacing (spacing);

  button = manage( new Gtk::Button ("OK"));
  bbox->add (*button);

  button = manage( new Gtk::Button ("Cancel"));
  bbox->add (*button);

  button = manage( new Gtk::Button ("Help"));
  bbox->add (*button);

}

class AppWindow : public Gtk::Window
{
public:
  AppWindow ();
  virtual ~AppWindow ();
};

AppWindow::AppWindow()
{
  Gtk::Box *main_vbox;
  Gtk::Box *vbox;
  Gtk::Box *hbox;
  Gtk::Frame *frame_horz;
  Gtk::Frame *frame_vert;

  set_title ("Button Boxes");
  set_border_width (10);

  main_vbox = manage( new Gtk::VBox(false, 0) );
  add (*main_vbox);

  frame_horz = manage( new Gtk::Frame ("Horizontal Button Boxes") );
  main_vbox->pack_start (*frame_horz, true, true, 10);

  vbox = manage( new Gtk::VBox (false, 0) );
  vbox -> set_border_width (10);
  frame_horz-> add (*vbox);

  vbox->pack_start (*manage( new BBox (true, "Spread (spacing 40)", 
                                      40, Gtk::BUTTONBOX_SPREAD)),
		      true, true, 0);

  vbox->pack_start (*manage( new BBox (true, "Edge (spacing 30)", 
	                              30, Gtk::BUTTONBOX_EDGE)),
		      true, true, 5);

  vbox->pack_start (*manage( new BBox (true, "Start (spacing 20)", 
                                      20, Gtk::BUTTONBOX_START)),
		      true, true, 5);

  vbox->pack_start (*manage( new BBox (true, "end (spacing 10)", 
                                      10, Gtk::BUTTONBOX_END)),
		      true, true, 5);

  frame_vert = manage( new Gtk::Frame ("Vertical Button Boxes") );
  main_vbox->pack_start (*frame_vert, true, true, 10);

  hbox = manage( new Gtk::HBox (false, 0) );
  hbox->set_border_width (10);
  frame_vert->add (*hbox);

  hbox->pack_start (*manage( new BBox (false, "Spread (spacing 5)", 
                                      5, Gtk::BUTTONBOX_SPREAD)),
		      true, true, 0);

  hbox->pack_start (*manage( new BBox (false, "Edge (spacing 30)", 
	                              30, Gtk::BUTTONBOX_EDGE)),
		      true, true, 5);

  hbox->pack_start (*manage( new BBox (false, "Start (spacing 20)", 
                                      20, Gtk::BUTTONBOX_START)),
		      true, true, 5);

  hbox->pack_start (*manage( new BBox (false, "End (spacing 10)", 
                                      10, Gtk::BUTTONBOX_END)),
		      true, true, 5);

  show_all ();

}

AppWindow::~AppWindow() {}


int main( int   argc,
          char *argv[] )
{
  Gtk::Main main (argc,argv);
  AppWindow window;

  /* Enter the event loop */
  Gtk::Main::run(window);
    
  return(0);
}

