
extern "C"
{
#include <glib-object.h>
#include <gdk/gdkenumtypes.h>
}

#include <gdkmm/bitmap.h>
#include <gdkmm/private/bitmap_p.h>

// -*- c++ -*-
/* $Id: bitmap.ccg,v 1.7 2002/04/02 13:23:10 daniel Exp $ */

/*
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdkpixmap.h>
#include <gdkmm/window.h>


namespace Gdk
{

Bitmap::Bitmap(const char* data, int width, int height)
:
  Pixmap((GdkPixmap*) gdk_bitmap_create_from_data(0, data, width, height))
{
  //TODO: We need a construct function if we really want to use our own GClass.
}

Bitmap::Bitmap(const Glib::RefPtr<Window>& window, const char* data, int width, int height)
:
  Pixmap((GdkPixmap*) gdk_bitmap_create_from_data(window->gobj(), data, width, height))
{
  //TODO: We need a construct function if we really want to use our own GClass.
}

} // namespace Gdk


namespace
{
} // anonymous namespace


namespace Gdk
{


/* The *_Class implementation: */

GType Bitmap_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gdk_pixmap_get_type(), "gdkmm__Bitmap", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Bitmap_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Bitmap_Class::wrap_new(GObject* o)
{
  return new Bitmap((GdkBitmap*)(o));
}


/* The implementation: */

GdkBitmap* Bitmap::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<Bitmap> Bitmap::wrap_specific_type(GdkBitmap* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<Bitmap> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    Bitmap* pCppObject = dynamic_cast<Bitmap*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<Bitmap>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<Bitmap>( new Bitmap(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

Bitmap::Bitmap(GdkBitmap* castitem)
: Gdk::Pixmap((GdkPixmap*)(castitem))
{}

Bitmap::~Bitmap()
{
}

Bitmap::CppClassType Bitmap::bitmap_class_; //Initialize static member.

GType Bitmap::get_type()
{
  return bitmap_class_.get_type();
}

GType Bitmap::get_base_type()
{
  return gdk_pixmap_get_type();
}

Bitmap::Bitmap()
: Gdk::Pixmap((GdkPixmap*)(g_object_new(get_type(), (char*)0)))
{}

Glib::RefPtr<Bitmap> Bitmap::create()
{
  return Glib::RefPtr<Bitmap>( new Bitmap() );
}
Glib::RefPtr<Bitmap> Bitmap::create(const char* data, int width, int height)
{
  return Glib::RefPtr<Bitmap>( new Bitmap(data, width, height) );
}
Glib::RefPtr<Bitmap> Bitmap::create(const Glib::RefPtr<Window>& window, const char* data, int width, int height)
{
  return Glib::RefPtr<Bitmap>( new Bitmap(window, data, width, height) );
}


} // namespace Gdk

