
#include <gtkmm/treepath.h>
#include <gtkmm/private/treepath_p.h>

// -*- c++ -*-
/* $Id: treepath.ccg,v 1.9 2002/03/26 18:43:28 daniel Exp $ */

/*
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/utility.h>


namespace Gtk
{

TreePath::TreePath(bool root /* = false */)
{
  if(root)
    gobject_ = gtk_tree_path_new_root();
  else
    gobject_ = gtk_tree_path_new();
}

TreePath::TreePath(const Glib::ustring& path)
{
  gobject_ = gtk_tree_path_new_from_string(path.c_str());
}

Glib::ArrayHandle<int> TreePath::get_indices()
{
  return Glib::ArrayHandle<int>(
      gtk_tree_path_get_indices(gobj()),
      gtk_tree_path_get_depth(gobj()),
      Glib::OWNERSHIP_NONE); //It seems like we don't need to free this.
}

} /* namespace Gtk */


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::TreePath wrap(GtkTreePath* object, bool take_copy /* = false */)
{
  return Gtk::TreePath(object, take_copy);
}

} // namespace Glib


namespace Gtk
{


// static
GType TreePath::get_type()
{
  return gtk_tree_path_get_type();
}


TreePath::TreePath(const TreePath& src)
:
  gobject_ ((src.gobject_) ? gtk_tree_path_copy(src.gobject_) : 0)
{}

TreePath::TreePath(GtkTreePath* castitem, bool make_a_copy /* = true */)
{
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.

  if(make_a_copy)
  {
    if(castitem)
      gobject_ = gtk_tree_path_copy(castitem);
    else
      gobject_ = 0;
  }
  else
  {
    // It was given to us by a function which has already made a copy for us to keep.
    gobject_ = castitem;
  }
}

TreePath& TreePath::operator=(const TreePath& src)
{
  GtkTreePath *const new_gobject = (src.gobject_) ? gtk_tree_path_copy(src.gobject_) : 0;

  if(gobject_)
    gtk_tree_path_free(gobject_);
  gobject_ = new_gobject;

  return *this;
}

TreePath::~TreePath()
{
  if(gobject_)
    gtk_tree_path_free(gobject_);}


GtkTreePath* TreePath::gobj_copy() const
{
  return gtk_tree_path_copy(gobject_);
}

Glib::ustring TreePath::to_string()
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_tree_path_to_string(gobj()));
}

void TreePath::append_index(int index)
{
  gtk_tree_path_append_index(gobj(), index);
}

void TreePath::prepend_index(int index)
{
  gtk_tree_path_prepend_index(gobj(), index);
}

int TreePath::get_depth()
{
  return gtk_tree_path_get_depth(gobj());
}

void TreePath::next()
{
  gtk_tree_path_next(gobj());
}

bool TreePath::prev()
{
  return gtk_tree_path_prev(gobj());
}

bool TreePath::up()
{
  return gtk_tree_path_up(gobj());
}

void TreePath::down()
{
  gtk_tree_path_down(gobj());
}

bool TreePath::is_ancestor(TreePath& descendant)
{
  return gtk_tree_path_is_ancestor(gobj(), (descendant).gobj());
}

bool TreePath::is_descendant(TreePath& ancestor)
{
  return gtk_tree_path_is_descendant(gobj(), (ancestor).gobj());
}


bool operator==(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) == 0);
}

bool operator!=(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) != 0);
}

bool operator<(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) < 0);
}

bool operator>(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) > 0);
}

bool operator<=(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) <= 0);
}

bool operator>=(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) >= 0);
}


} // namespace Gtk


