
#include <pangomm/font.h>
#include <pangomm/private/font_p.h>

// -*- c++ -*-
/* $Id: font.ccg,v 1.3 2001/12/14 13:19:35 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Pango
{

void Font::get_glyph_extents_ink_rect_only(PangoGlyph glyph, PangoRectangle& ink_rect)
{
  pango_font_get_glyph_extents(gobj(), glyph, &ink_rect, 0);
}

void Font::get_glyph_extents_logical_rect_only(PangoGlyph glyph, PangoRectangle& logical_rect)
{
  pango_font_get_glyph_extents(gobj(), glyph, 0, &logical_rect);
}

} /* namespace Pango */


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Pango::Font> wrap(PangoFont* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Pango::Font>( dynamic_cast<Pango::Font*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Pango
{


/* The *_Class implementation: */

GType Font_Class::get_type()
  {
    gtype_ = pango_font_get_type(); //The actual struct definition is hidden, so we can not derive one.
    return gtype_;
  }


Glib::ObjectBase* Font_Class::wrap_new(GObject* o)
{
  return new Font((PangoFont*)(o));
}


/* The implementation: */

PangoFont* Font::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<Font> Font::wrap_specific_type(PangoFont* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<Font> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    Font* pCppObject = dynamic_cast<Font*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<Font>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<Font>( new Font(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

Font::Font(PangoFont* castitem)
: Glib::Object((GObject*)(castitem))
{}

Font::~Font()
{
}

Font::CppClassType Font::font_class_; //Initialize static member.

GType Font::get_type()
{
  return font_class_.get_type();
}

GType Font::get_base_type()
{
  return pango_font_get_type();
}

FontDescription Font::describe()
{
  return FontDescription(pango_font_describe(gobj()));
}

Glib::RefPtr<Coverage> Font::get_coverage(const PangoLanguage* language)
{
  return Glib::wrap(pango_font_get_coverage(gobj(), const_cast<PangoLanguage*>(language)));
}

PangoEngineShape* Font::find_shaper(const PangoLanguage* language, guint32 ch)
{
  return pango_font_find_shaper(gobj(), const_cast<PangoLanguage*>(language), ch);
}

FontMetrics Font::get_metrics(const PangoLanguage* language)
{
  return FontMetrics(pango_font_get_metrics(gobj(), const_cast<PangoLanguage*>(language)));
}

void Font::get_glyph_extents(PangoGlyph glyph, PangoRectangle& ink_rect, PangoRectangle& logical_rect)
{
  pango_font_get_glyph_extents(gobj(), glyph, &ink_rect, &logical_rect);
}


} // namespace Pango

