
extern "C"
{
#include <glib-object.h>
#include <gdk/gdkenumtypes.h>
}

#include <gdkmm/pixbufanimationiter.h>
#include <gdkmm/private/pixbufanimationiter_p.h>

// -*- c++ -*-
/* $Id: pixbufanimationiter.ccg,v 1.1 2001/12/12 14:30:53 murrayc Exp $ */

/*
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gdk::PixbufAnimationIter> wrap(GdkPixbufAnimationIter* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gdk::PixbufAnimationIter>( dynamic_cast<Gdk::PixbufAnimationIter*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gdk
{


/* The *_Class implementation: */

GType PixbufAnimationIter_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // The actual struct definition is hidden, so we can not derive one.
    gtype_ = gdk_pixbuf_animation_iter_get_type();

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}


Glib::ObjectBase* PixbufAnimationIter_Class::wrap_new(GObject* o)
{
  return new PixbufAnimationIter((GdkPixbufAnimationIter*)(o));
}


/* The implementation: */

GdkPixbufAnimationIter* PixbufAnimationIter::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<PixbufAnimationIter> PixbufAnimationIter::wrap_specific_type(GdkPixbufAnimationIter* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<PixbufAnimationIter> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    PixbufAnimationIter* pCppObject = dynamic_cast<PixbufAnimationIter*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<PixbufAnimationIter>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<PixbufAnimationIter>( new PixbufAnimationIter(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

PixbufAnimationIter::PixbufAnimationIter(GdkPixbufAnimationIter* castitem)
: Glib::Object((GObject*)(castitem))
{}

PixbufAnimationIter::~PixbufAnimationIter()
{
}

PixbufAnimationIter::CppClassType PixbufAnimationIter::pixbufanimationiter_class_; //Initialize static member.

GType PixbufAnimationIter::get_type()
{
  return pixbufanimationiter_class_.get_type();
}

GType PixbufAnimationIter::get_base_type()
{
  return gdk_pixbuf_animation_iter_get_type();
}


} // namespace Gdk

