
#include <gtkmm/togglebutton.h>
#include <gtkmm/private/togglebutton_p.h>

// -*- c++ -*-
/* $Id: togglebutton.ccg,v 1.9 2002/03/09 18:10:46 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtktogglebutton.h>

namespace Gtk
{

ToggleButton::ToggleButton(const Glib::ustring & label, bool mnemonic /* = false */)
: Gtk::Button((GtkButton*)( g_object_new( get_type() , "label", label.c_str(), "use_underline", (gboolean)mnemonic, 0 ) ))
{
}

} /* namespace Gtk */

namespace
{

const Glib::SignalProxyInfo ToggleButton_signal_toggled_info =
{
  "toggled",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::ToggleButton* wrap(GtkToggleButton* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::ToggleButton *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType ToggleButton_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_toggle_button_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void ToggleButton_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->toggled = &toggled_callback;
}


void ToggleButton_Class::toggled_callback(GtkToggleButton* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_toggled();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->toggled)
      (*base->toggled)(self);
  }
}


Glib::ObjectBase* ToggleButton_Class::wrap_new(GObject* o)
{
  return manage(new ToggleButton((GtkToggleButton*)(o)));
}


/* The implementation: */

ToggleButton::ToggleButton(GtkToggleButton* castitem)
: Gtk::Button((GtkButton*)(castitem))
{}

ToggleButton::~ToggleButton()
{
  destroy_();
}

ToggleButton::CppClassType ToggleButton::togglebutton_class_; //Initialize static member.

GType ToggleButton::get_type()
{
  return togglebutton_class_.get_type();
}

GType ToggleButton::get_base_type()
{
  return gtk_toggle_button_get_type();
}

ToggleButton::ToggleButton()
: Gtk::Button((GtkButton*)(g_object_new(get_type(), (char*)0)))
{}

void ToggleButton::set_mode(bool draw_indicator)
{
  gtk_toggle_button_set_mode(gobj(), static_cast<int>(draw_indicator));
}

bool ToggleButton::get_mode() const
{
  return gtk_toggle_button_get_mode(const_cast<GtkToggleButton*>(gobj()));
}

void ToggleButton::set_active(bool is_active)
{
  gtk_toggle_button_set_active(gobj(), static_cast<int>(is_active));
}

bool ToggleButton::get_active() const
{
  return gtk_toggle_button_get_active(const_cast<GtkToggleButton*>(gobj()));
}

void ToggleButton::set_inconsistent(bool setting)
{
  gtk_toggle_button_set_inconsistent(gobj(), static_cast<int>(setting));
}

bool ToggleButton::get_inconsistent() const
{
  return gtk_toggle_button_get_inconsistent(const_cast<GtkToggleButton*>(gobj()));
}

void ToggleButton::toggled()
{
  gtk_toggle_button_toggled(gobj());
}


Glib::SignalProxy0<void> ToggleButton::signal_toggled()
{
  return Glib::SignalProxy0<void>(this, &ToggleButton_signal_toggled_info);
}


Glib::PropertyProxy<bool> ToggleButton::property_active()
{
  return Glib::PropertyProxy<bool>(this, "active");
}

Glib::PropertyProxy<bool> ToggleButton::property_inconsistent()
{
  return Glib::PropertyProxy<bool>(this, "inconsistent");
}

Glib::PropertyProxy<bool> ToggleButton::property_draw_indicator()
{
  return Glib::PropertyProxy<bool>(this, "draw_indicator");
}


void Gtk::ToggleButton::on_toggled()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->toggled)
    (*base->toggled)(gobj());
}


} // namespace Gtk

