// -*- c++ -*-
#ifndef _GLIBMM_CLOSURE_H
#define _GLIBMM_CLOSURE_H

/* $Id: closure.h,v 1.21 2002/02/25 02:21:14 murrayc Exp $ */

/* closure.h
 *
 * Copyright 2001 Free Software Foundation
 * Copyright (C) 1998-2001 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <sigc++/sigc++.h>

#include <glibmmconfig.h>
#include <glib-object.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS

namespace Glib
{

class Object;

//Derived SigC::ConnectionNode (Connetction impl).
//which knows how to disconnect itself.
class GSigConnectionNode : public SigC::ConnectionNode
{
public:
  GSigConnectionNode(SigC::SlotNode* slot_data, Object* cppObject, gulong connection_id);
  virtual ~GSigConnectionNode();
  virtual void notify(bool from_child); //overridden.

protected:
  gulong connection_id_;
  Object* pCppObject_;
};

class Closure;

struct GClosure_Glibmm
{
  GCClosure closure; //GCClosure rather than just the GClosure.

  SigC::SlotNode* sigc_slot_; //SlotNode is used by SigC::SlotBase to hold SlotBase data.
  SigC::Connection connection;
  Closure* pCppClosure_;
};

class Closure
{
public:
  Closure(Object* cppObject, const char* signal_name, GCallback callback_func,
          const SigC::SlotBase& slot, bool after, GClosureMarshal marshal = 0);

	virtual ~Closure();

  SigC::Connection get_connection();

  //void* get_sigc_callback();
	GClosure* gobj();

  void clear_gobj();
  void discard_slot_data();

protected:
  GClosure_Glibmm* pCClosure_;

};

/*
void
glibmm_closure_marshal(GClosure *closure, GValue *return_value,
                       guint n_param_values, const GValue *param_values,
                       gpointer invocation_hint, gpointer marshal_data);
*/		

} /* namespace Glib */

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#endif /* _GLIBMM_CLOSURE_H */
