
#include <gtkmm/layout.h>
#include <gtkmm/private/layout_p.h>

// -*- c++ -*-
/* $Id: layout.ccg,v 1.10 2002/04/15 18:48:42 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtklayout.h>

namespace Gtk
{

/* layout.cc
 * 
 * Copyright (C) 1998 EMC Capital Management Inc.
 * Developed by Havoc Pennington <hp@pobox.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

Layout::Layout()
  : Container((GtkContainer*)(g_object_new(get_type(),0)))
{
  set_hadjustment();
  set_vadjustment();
}

Layout::Layout(Adjustment &hadjustment,
		       Adjustment &vadjustment)
  : Container((GtkContainer*)(g_object_new(get_type(),0)))
{
  set_hadjustment(hadjustment);
  set_vadjustment(vadjustment);
}

void Layout::set_hadjustment()
{
  gtk_layout_set_hadjustment(gobj(), 0);
}

void Layout::set_vadjustment()
{
  gtk_layout_set_vadjustment(gobj(), 0);
}

} /* namespace Gtk */


namespace
{


void Layout_signal_set_scroll_adjustments_callback(GtkLayout*, GtkAdjustment* p0,GtkAdjustment* p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,Adjustment*,Adjustment*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0)
,Glib::wrap(p1)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Layout_signal_set_scroll_adjustments_info =
{
  "set_scroll_adjustments",
  (GCallback) &Layout_signal_set_scroll_adjustments_callback,
  (GCallback) &Layout_signal_set_scroll_adjustments_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::Layout* wrap(GtkLayout* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Layout *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Layout_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_layout_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void Layout_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->set_scroll_adjustments = &set_scroll_adjustments_callback;
}


void Layout_Class::set_scroll_adjustments_callback(GtkLayout* self, GtkAdjustment* p0, GtkAdjustment* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_set_scroll_adjustments(Glib::wrap(p0)
, Glib::wrap(p1)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->set_scroll_adjustments)
      (*base->set_scroll_adjustments)(self, p0, p1);
  }
}


Glib::ObjectBase* Layout_Class::wrap_new(GObject* o)
{
  return manage(new Layout((GtkLayout*)(o)));
}


/* The implementation: */

Layout::Layout(GtkLayout* castitem)
: Gtk::Container((GtkContainer*)(castitem))
{}

Layout::~Layout()
{
  destroy_();
}

Layout::CppClassType Layout::layout_class_; //Initialize static member.

GType Layout::get_type()
{
  return layout_class_.get_type();
}

GType Layout::get_base_type()
{
  return gtk_layout_get_type();
}

void Layout::put(Widget & widget, int x, int y)
{
  gtk_layout_put(gobj(), (widget).Gtk::Widget::gobj(), x, y);
}

void Layout::move(Widget & widget, int x, int y)
{
  gtk_layout_move(gobj(), (widget).Gtk::Widget::gobj(), x, y);
}

void Layout::set_size(guint width, guint height)
{
  gtk_layout_set_size(gobj(), width, height);
}

void Layout::get_size(guint& width, guint& height) const
{
  gtk_layout_get_size(const_cast<GtkLayout*>(gobj()), &(width), &(height));
}

void Layout::set_hadjustment(Adjustment& hadj)
{
  gtk_layout_set_hadjustment(gobj(), (hadj).gobj());
}

Adjustment* Layout::get_hadjustment()
{
  return Glib::wrap(gtk_layout_get_hadjustment(gobj()));
}

void Layout::set_vadjustment(Adjustment& vadj)
{
  gtk_layout_set_vadjustment(gobj(), (vadj).gobj());
}

Adjustment* Layout::get_vadjustment()
{
  return Glib::wrap(gtk_layout_get_vadjustment(gobj()));
}

Glib::RefPtr<Gdk::Window> Layout::get_bin_window()
{
  Glib::RefPtr<Gdk::Window> ref_ptr(Gdk::Window::wrap_specific_type(gobj()->bin_window));

  if(!ref_ptr.is_null())
    ref_ptr->reference();

  return ref_ptr;
}

Glib::RefPtr<const Gdk::Window> Layout::get_bin_window() const
{
  Glib::RefPtr<const Gdk::Window> ref_ptr(Gdk::Window::wrap_specific_type(gobj()->bin_window));

  if(!ref_ptr.is_null())
    ref_ptr->reference();

  return ref_ptr;
}


Glib::SignalProxy2<void,Adjustment*,Adjustment*> Layout::signal_set_scroll_adjustments()
{
  return Glib::SignalProxy2<void,Adjustment*,Adjustment*>(this, &Layout_signal_set_scroll_adjustments_info);
}


Glib::PropertyProxy<Adjustment*> Layout::property_hadjustment()
{
  return Glib::PropertyProxy<Adjustment*>(this, "hadjustment");
}

Glib::PropertyProxy<Adjustment*> Layout::property_vadjustment()
{
  return Glib::PropertyProxy<Adjustment*>(this, "vadjustment");
}

Glib::PropertyProxy<guint> Layout::property_width()
{
  return Glib::PropertyProxy<guint>(this, "width");
}

Glib::PropertyProxy<guint> Layout::property_height()
{
  return Glib::PropertyProxy<guint>(this, "height");
}


void Gtk::Layout::on_set_scroll_adjustments(Adjustment* p1, Adjustment* p2)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->set_scroll_adjustments)
    (*base->set_scroll_adjustments)(gobj(),(GtkAdjustment*)Glib::unwrap(p1),(GtkAdjustment*)Glib::unwrap(p2));
}


} // namespace Gtk

