
#include <gtkmm/menubar.h>
#include <gtkmm/private/menubar_p.h>

// -*- c++ -*-
/* $Id: menubar.ccg,v 1.3 2002/03/07 23:33:13 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkmenubar.h>

namespace Gtk
{

void 
MenuBar::on_realize()
{
  MenuShell::on_realize();
  if(get_toplevel()->is_toplevel())
  {
    Gtk::Window* window = dynamic_cast<Gtk::Window*>(get_toplevel());
    if(window)
      accelerate(*window);
  }
}

} // namespace Gtk


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::MenuBar* wrap(GtkMenuBar* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::MenuBar *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType MenuBar_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_menu_bar_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void MenuBar_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* MenuBar_Class::wrap_new(GObject* o)
{
  return manage(new MenuBar((GtkMenuBar*)(o)));
}


/* The implementation: */

MenuBar::MenuBar(GtkMenuBar* castitem)
: Gtk::MenuShell((GtkMenuShell*)(castitem))
{}

MenuBar::~MenuBar()
{
  destroy_();
}

MenuBar::CppClassType MenuBar::menubar_class_; //Initialize static member.

GType MenuBar::get_type()
{
  return menubar_class_.get_type();
}

GType MenuBar::get_base_type()
{
  return gtk_menu_bar_get_type();
}

MenuBar::MenuBar()
: Gtk::MenuShell((GtkMenuShell*)(g_object_new(get_type(), (char*)0)))
{}


} // namespace Gtk

