
#include <gtkmm/menushell.h>
#include <gtkmm/private/menushell_p.h>

// -*- c++ -*-
/* $Id: menushell.ccg,v 1.25 2002/03/20 07:49:39 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <strings.h>

namespace Gtk
{

MenuShell::~MenuShell()
{
}

void MenuShell::accelerate(Window& window)
{
  // gtkmm-accel-window is used by menuitems that are added to thhe
  // menushell after it has been accelerated
  set_data("gtkmm-accel-window", &window); 

  for (MenuList::iterator i = items().begin(); i != items().end(); ++i)
    (*i)->accelerate(window);
}

MenuShell::MenuList& MenuShell::items()
{
  items_proxy_ = MenuList(gobj());
  return items_proxy_;
}


const MenuShell::MenuList& MenuShell::items() const
{
  items_proxy_ = MenuList(const_cast<GtkMenuShell*>(gobj()));
  return items_proxy_;
}

namespace Menu_Helpers
{

/*********************************************************************
***** List properties
*********************************************************************/
typedef Glib::List_Cpp_Iterator<GtkMenuItem, MenuItem> menu_iterator;


menu_iterator MenuList::insert(menu_iterator position, const Element& e)
{
  Glib::RefPtr<Gtk::MenuItem> item = e.get_child();
  if(!item)
    return position;

  // locate the items desired position
  if(!gparent())
    return iterator();

  int pos;
  if(!position.node)
    pos = -1;
  else
    pos = g_list_position(glist(),position.node);

  gtk_menu_shell_insert(GTK_MENU_SHELL(gparent()),
                        GTK_WIDGET(item->gobj()), pos);

  // if menushell is accelerated initialize accelerators of new menuitem
  Window* window = reinterpret_cast<Window*>(g_object_get_qdata(G_OBJECT(gparent()), g_quark_from_string("gtkmm-accel-window")));
  if(window)
    item->accelerate(*window);

  // return the right iterator
  if(pos == 0)
    return begin();

  if(!position.node)
    return --end();

  return --position;
}

} // namespace Menu_Helpers

} // namespace Gtk


namespace
{

const Glib::SignalProxyInfo MenuShell_signal_deactivate_info =
{
  "deactivate",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo MenuShell_signal_selection_done_info =
{
  "selection_done",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


void MenuShell_signal_move_current_callback(GtkMenuShell*, GtkMenuDirectionType p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,MenuDirectionType> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (((MenuDirectionType)(p0))
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo MenuShell_signal_move_current_info =
{
  "move_current",
  (GCallback) &MenuShell_signal_move_current_callback,
  (GCallback) &MenuShell_signal_move_current_callback
};


void MenuShell_signal_activate_current_callback(GtkMenuShell*, gboolean p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo MenuShell_signal_activate_current_info =
{
  "activate_current",
  (GCallback) &MenuShell_signal_activate_current_callback,
  (GCallback) &MenuShell_signal_activate_current_callback
};


const Glib::SignalProxyInfo MenuShell_signal_cancel_info =
{
  "cancel",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::MenuShell* wrap(GtkMenuShell* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::MenuShell *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType MenuShell_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_menu_shell_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void MenuShell_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->deactivate = &deactivate_callback;
  klass->selection_done = &selection_done_callback;
  klass->move_current = &move_current_callback;
  klass->activate_current = &activate_current_callback;
  klass->cancel = &cancel_callback;
}


void MenuShell_Class::deactivate_callback(GtkMenuShell* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_deactivate();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->deactivate)
      (*base->deactivate)(self);
  }
}

void MenuShell_Class::selection_done_callback(GtkMenuShell* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_selection_done();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->selection_done)
      (*base->selection_done)(self);
  }
}

void MenuShell_Class::move_current_callback(GtkMenuShell* self, GtkMenuDirectionType p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_move_current(((MenuDirectionType)(p0))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->move_current)
      (*base->move_current)(self, p0);
  }
}

void MenuShell_Class::activate_current_callback(GtkMenuShell* self, gboolean p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_activate_current(p0
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->activate_current)
      (*base->activate_current)(self, p0);
  }
}

void MenuShell_Class::cancel_callback(GtkMenuShell* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_cancel();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->cancel)
      (*base->cancel)(self);
  }
}


Glib::ObjectBase* MenuShell_Class::wrap_new(GObject* o)
{
  return manage(new MenuShell((GtkMenuShell*)(o)));
}


/* The implementation: */

MenuShell::MenuShell(GtkMenuShell* castitem)
: Gtk::Container((GtkContainer*)(castitem))
{}


MenuShell::CppClassType MenuShell::menushell_class_; //Initialize static member.

GType MenuShell::get_type()
{
  return menushell_class_.get_type();
}

GType MenuShell::get_base_type()
{
  return gtk_menu_shell_get_type();
}


namespace Menu_Helpers
{

void MenuList::remove(const_reference child)
{
  g_return_if_fail(child != 0);
  gtk_container_remove(GTK_CONTAINER(gparent_),
                       (GtkWidget*)(child->gobj()));
}

void MenuList::remove(Widget &w)
{
  gtk_container_remove(GTK_CONTAINER(gparent_), (GtkWidget*)(w.gobj()));
}

MenuList::iterator MenuList::erase(iterator position)
{
  if ( !position.node || (position == end()) )
    return end();

  iterator next = position;
  next++;

  gtk_container_remove(GTK_CONTAINER(gparent_),
      (GtkWidget*)((*position)->gobj()));
  return next;
}

} /* namespace Menu_Helpers */


namespace Menu_Helpers
{

MenuList::MenuList()
{}

MenuList::MenuList(GtkMenuShell* gparent)
: type_base((GObject*)gparent)
{}

MenuList::MenuList(const MenuList& src)
{
  operator=(src);
}

MenuList& MenuList::operator=(const MenuList& src)
{
  gparent_ = src.gparent_;
  return *this;
}

GList*& MenuList::glist() const
{
  return ((GtkMenuShell*)gparent_)->children;
}

void MenuList::erase(iterator start, iterator stop)
{
  type_base::erase(start, stop);
}

GtkMenuShell* MenuList::gparent()
{
  return (GtkMenuShell*)type_base::gparent();
}

const GtkMenuShell* MenuList::gparent() const
{
  return (GtkMenuShell*)type_base::gparent();
}

MenuList::value_type MenuList::operator[](size_type l) const
{
  return type_base::operator[](l);
}

} /* namespace Menu_Helpers */

void MenuShell::append(MenuItem& menu_item)
{
  gtk_menu_shell_append(gobj(), (menu_item).Gtk::Widget::gobj());
}

void MenuShell::prepend(MenuItem& menu_item)
{
  gtk_menu_shell_prepend(gobj(), (menu_item).Gtk::Widget::gobj());
}

void MenuShell::insert(MenuItem& menu_item, int position)
{
  gtk_menu_shell_insert(gobj(), (menu_item).Gtk::Widget::gobj(), position);
}

void MenuShell::select_item(MenuItem& menu_item)
{
  gtk_menu_shell_select_item(gobj(), (menu_item).Gtk::Widget::gobj());
}

void MenuShell::deselect()
{
  gtk_menu_shell_deselect(gobj());
}

void MenuShell::activate_item(MenuItem& menu_item, bool force_deactivate)
{
  gtk_menu_shell_activate_item(gobj(), (menu_item).Gtk::Widget::gobj(), static_cast<int>(force_deactivate));
}

void MenuShell::deactivate()
{
  gtk_menu_shell_deactivate(gobj());
}

MenuShell::MenuShell()
: Gtk::Container((GtkContainer*)(g_object_new(get_type(), (char*)0)))
{}


Glib::SignalProxy0<void> MenuShell::signal_deactivate()
{
  return Glib::SignalProxy0<void>(this, &MenuShell_signal_deactivate_info);
}

Glib::SignalProxy0<void> MenuShell::signal_selection_done()
{
  return Glib::SignalProxy0<void>(this, &MenuShell_signal_selection_done_info);
}

Glib::SignalProxy1<void,MenuDirectionType> MenuShell::signal_move_current()
{
  return Glib::SignalProxy1<void,MenuDirectionType>(this, &MenuShell_signal_move_current_info);
}

Glib::SignalProxy1<void,bool> MenuShell::signal_activate_current()
{
  return Glib::SignalProxy1<void,bool>(this, &MenuShell_signal_activate_current_info);
}

Glib::SignalProxy0<void> MenuShell::signal_cancel()
{
  return Glib::SignalProxy0<void>(this, &MenuShell_signal_cancel_info);
}


void Gtk::MenuShell::on_deactivate()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->deactivate)
    (*base->deactivate)(gobj());
}

void Gtk::MenuShell::on_selection_done()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->selection_done)
    (*base->selection_done)(gobj());
}

void Gtk::MenuShell::on_move_current(MenuDirectionType direction)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->move_current)
    (*base->move_current)(gobj(),((GtkMenuDirectionType)(direction)));
}

void Gtk::MenuShell::on_activate_current(bool force_hide)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->activate_current)
    (*base->activate_current)(gobj(),static_cast<int>(force_hide));
}

void Gtk::MenuShell::on_cancel()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->cancel)
    (*base->cancel)(gobj());
}


} // namespace Gtk

