
#include <gtkmm/textmark.h>
#include <gtkmm/private/textmark_p.h>

// -*- c++ -*-
/* $Id: textmark.ccg,v 1.2 2002/04/16 13:01:53 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <gtkmm/textbuffer.h>
#include <gtk/gtktextmark.h>

namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::TextMark> wrap(GtkTextMark* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gtk::TextMark>( dynamic_cast<Gtk::TextMark*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

GType TextMark_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_text_mark_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void TextMark_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* TextMark_Class::wrap_new(GObject* o)
{
  return new TextMark((GtkTextMark*)(o));
}


/* The implementation: */

GtkTextMark* TextMark::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<TextMark> TextMark::wrap_specific_type(GtkTextMark* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<TextMark> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    TextMark* pCppObject = dynamic_cast<TextMark*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<TextMark>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<TextMark>( new TextMark(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

TextMark::TextMark(GtkTextMark* castitem)
: Glib::Object((GObject*)(castitem))
{}

TextMark::~TextMark()
{
}

TextMark::CppClassType TextMark::textmark_class_; //Initialize static member.

GType TextMark::get_type()
{
  return textmark_class_.get_type();
}

GType TextMark::get_base_type()
{
  return gtk_text_mark_get_type();
}

void TextMark::set_visible(bool setting)
{
  gtk_text_mark_set_visible(gobj(), static_cast<int>(setting));
}

bool TextMark::get_visible() const
{
  return gtk_text_mark_get_visible(const_cast<GtkTextMark*>(gobj()));
}

Glib::ustring TextMark::get_name()
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_text_mark_get_name(gobj()));
}

bool TextMark::get_deleted()
{
  return gtk_text_mark_get_deleted(gobj());
}

Glib::RefPtr<TextBuffer> TextMark::get_buffer()
{
  Glib::RefPtr<TextBuffer> retvalue = Glib::wrap(gtk_text_mark_get_buffer(gobj()));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

bool TextMark::get_left_gravity()
{
  return gtk_text_mark_get_left_gravity(gobj());
}


} // namespace Gtk

