// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TREEVIEWCOLUMN_H
#define _GTKMM_TREEVIEWCOLUMN_H

#include <glibmm.h>

/* $Id: treeviewcolumn.hg,v 1.32 2002/05/09 14:09:59 murrayc Exp $ */


/* treeviewcolumn.h
 *
 * Copyright(C) 2001 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/object.h>
#include <gtkmm/treeiter.h>
#include <gtkmm/widget.h>
#include <gdkmm/window.h>
//#include <gtkmm/cellrenderer.h>
#include <gtkmm/cellrenderertext.h>
#include <gtkmm/cellrendererpixbuf.h>
#include <gtkmm/cellrenderertoggle.h>
#include <gtkmm/treemodel.h>
#include <glibmm/listhandle.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTreeViewColumn GtkTreeViewColumn;
typedef struct _GtkTreeViewColumnClass GtkTreeViewColumnClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class TreeViewColumn_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum TreeViewColumnSizing
{
  TREE_VIEW_COLUMN_GROW_ONLY,
  TREE_VIEW_COLUMN_AUTOSIZE,
  TREE_VIEW_COLUMN_FIXED
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TreeViewColumnSizing> : public Glib::Value_Enum<Gtk::TreeViewColumnSizing>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


namespace TreeViewColumn_CellRendererGeneration
{

template<class T_ModelColumnType> //e.g. bool or Glib::ustring.
CellRenderer* generate_cellrenderer()
{
  return new CellRendererText(); //the default - template specializations will use other renderers.
  //CellRendererText can render both strings and numerical values.
}

} //anoymous TreeViewColumn_CellRendererGeneration

/** This is a visible column in a Gtk::TreeView widget. It determines the geometry, type.
 * Typdefed as Gtk::TreeView::Column.
 * @ingroup TreeView
*/

class TreeViewColumn : public Gtk::Object
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TreeViewColumn CppObjectType;
  typedef TreeViewColumn_Class CppClassType;
  typedef GtkTreeViewColumn BaseObjectType;
  typedef GtkTreeViewColumnClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~TreeViewColumn();

private:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  friend class TreeViewColumn_Class;
  static CppClassType treeviewcolumn_class_;

  TreeViewColumn(const TreeViewColumn&);
  TreeViewColumn& operator=(const TreeViewColumn&); // not implemented

protected:
  explicit TreeViewColumn(GtkTreeViewColumn* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GtkTreeViewColumn* gobj()             { return (GtkTreeViewColumn*)(gobject_); }
  const GtkTreeViewColumn* gobj() const { return (GtkTreeViewColumn*)(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_clicked();


private:

  
public:
  typedef TreeViewColumn Column;

  TreeViewColumn();

  explicit TreeViewColumn(const Glib::ustring& title);
  TreeViewColumn(const Glib::ustring& title, CellRenderer& cell);

  /** Create a default view column for the given model column type.
   */
  template<class T_ModelColumnType>
  TreeViewColumn(const Glib::ustring& title, const TreeModelColumn<T_ModelColumnType>& column)
  : Gtk::Object((GtkObject*)(g_object_new(get_type(), "title", title.c_str(), (char*)0)))
  {
    pack_start(column); //true = expand.
  }

  
  void pack_start(CellRenderer& cell, bool expand = true);
  
  void pack_end(CellRenderer& cell, bool expand = true);


  template<class T_ModelColumnType>
  void pack_start(const TreeModelColumn<T_ModelColumnType>& column, bool expand = true)
  {
    //Generate appropriate Renderer for the column:
    CellRenderer* pCellRenderer= manage( TreeViewColumn_CellRendererGeneration::generate_cellrenderer<T_ModelColumnType>() );

    //Use the renderer:
    pack_start(*pCellRenderer, expand);
    set_renderer(*pCellRenderer, column);
  }

  template<class T_ModelColumnType>
  void pack_end(const TreeModelColumn<T_ModelColumnType>& column, bool expand = true)
  {
    //Generate appropriate Renderer for the column:
    CellRenderer* pCellRenderer= manage( TreeViewColumn_CellRendererGeneration::generate_cellrenderer<T_ModelColumnType>() );

    //Use the renderer:
    pack_end(*pCellRenderer, expand);
    set_renderer(*pCellRenderer, column);
  }

  
  void clear();
  
  Glib::ListHandle<CellRenderer*> get_cell_renderers();
  
  void add_attribute(CellRenderer& cell_renderer, const Glib::ustring& attribute, int column);

  void add_attribute(const Glib::PropertyProxy_Base& property, const TreeModelColumnBase& column);
  

  void set_renderer(Gtk::CellRenderer& renderer, const TreeModelColumnBase& column);

 // _WRAP_METHOD(void set_attributes(CellRenderer& cell_renderer, ...), )

  typedef SigC::Slot4<void, TreeViewColumn*, CellRenderer*, const Glib::RefPtr<Gtk::TreeModel>&, const Gtk::TreeModel::iterator&> SlotCellData;
  void set_cell_data_func(CellRenderer& cell_renderer, const SlotCellData& slot);

  
  void clear_attributes(CellRenderer& cell_renderer);
  
  void set_spacing(int spacing);
  
  int get_spacing() const;
  
  void set_visible(bool visible = true);
  
  bool get_visible() const;
  
  void set_resizable(bool resizable = true);
  
  bool get_resizable() const;
  
  void set_sizing(TreeViewColumnSizing type);
  
  TreeViewColumnSizing get_sizing();
  
  int get_width() const;
  
  int get_fixed_width() const;
  
  void set_fixed_width(int fixed_width);
  
  void set_min_width(int min_width);
  
  int get_min_width() const;
  
  void set_max_width(int max_width);
  
  int get_max_width() const;
  
  void clicked();

  
  void set_title(const Glib::ustring& title);
  
  Glib::ustring get_title() const;
  
  void set_clickable(bool clickable = true);
  
  bool get_clickable() const;
  
  void set_widget(GtkWidget* widget);
  
  Widget* get_widget();
  
  void set_alignment(float xalign);
  
  float get_alignment() const;
  
  void set_reorderable(bool reorderable = true);
  
  bool get_reorderable() const;

  
  void set_sort_column_id(int sort_column_id);
  
  int get_sort_column_id() const;
  
  void set_sort_indicator(bool setting);
  
  bool get_sort_indicator() const;
  
  void set_sort_order(SortType order);
  
  SortType get_sort_order() const;


  void cell_set_cell_data(const Glib::RefPtr<TreeModel>& tree_model, const TreeModel::iterator& iter, bool is_expander, bool is_expanded);
  
  void cell_get_size(Gdk::Rectangle& cell_area, int& x_offset, int& y_offset, int& width, int& height) const;
  
  bool cell_is_visible() const;

  
  /**
   * @par Prototype:
   * <tt>void %clicked()</tt>
   */
  Glib::SignalProxy0<void> signal_clicked();


  Glib::PropertyProxy<bool> property_visible();

  Glib::PropertyProxy_ReadOnly<int> property_width();

  Glib::PropertyProxy<TreeViewColumnSizing> property_sizing();

  Glib::PropertyProxy<int> property_fixed_width();

  Glib::PropertyProxy<int> property_min_width();

  Glib::PropertyProxy<int> property_max_width();

  Glib::PropertyProxy<Glib::ustring> property_title();

  Glib::PropertyProxy<bool> property_clickable();

  Glib::PropertyProxy<Widget*> property_widget();

  Glib::PropertyProxy<float> property_alignment();

  Glib::PropertyProxy<bool> property_reorderable();

  Glib::PropertyProxy<bool> property_sort_indicator();

  Glib::PropertyProxy<SortType> property_sort_order();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::TreeViewColumn */
  Gtk::TreeViewColumn* wrap(GtkTreeViewColumn* object, bool take_copy = false);
}
#endif /* _GTKMM_TREEVIEWCOLUMN_H */

