dnl $Id: class_gobject.m4,v 1.17 2002/04/22 00:09:36 murrayc Exp $


define(`_CLASS_GOBJECT',`dnl
_PUSH()
dnl
dnl  Define the args for later macros
define(`__CPPNAME__',`$1')
define(`__CNAME__',`$2')
define(`__CCAST__',`$3')
define(`__BASE__',_LOWER(__CPPNAME__))
define(`__CPPPARENT__',`$4')
define(`__CPARENT__',`$5')
define(`__PCAST__',`($5*)')

dnl Some C types, e.g. GdkWindow or GdkPixmap, are a typedef to their base type,
dnl rather than the real instance type.  That is really ugly, yes.  We get around
dnl the problem by supporting optional __REAL_* arguments to this macro.
define(`__REAL_CNAME__',ifelse(`$6',,__CNAME__,`$6'))
define(`__REAL_CPARENT__',ifelse(`$7',,__CPARENT__,`$7'))


_POP()
_SECTION(SECTION_CLASS2)
') dnl end of _CLASS_GOBJECT


dnl Some of the Gdk types are actually direct typedefs of their base type.
dnl This means that 2 wrap functions would have the same argument.
define(`_NO_WRAP_FUNCTION',`dnl
_PUSH()
dnl Define this macro to be tested for later.
define(`__BOOL_NO_WRAP_FUNCTION__',`$1')
_POP()
')

dnl GdkVisual's GdkVisualClass struct defintion is hidden,
dnl and different for X11, linux-fb, etc,
dnl so we can't derived from it.
dnl This means that we can't wrap signals or virtual funcs,
dnl But there aren't any, so that's OK.
define(`_NO_DERIVED_CLASS',`dnl
_PUSH()
dnl Define this macro to be tested for later.
define(`__BOOL_NO_DERIVED_CLASS__',`$1')
_POP()
')


dnl
dnl _CREATE_METHOD(args_type_and_name, args_name_only);
dnl
define(`_CREATE_METHOD',`
  static Glib::RefPtr<`'__CPPNAME__`'> create(`'$1`');
_PUSH(SECTION_CC)
Glib::RefPtr<`'__CPPNAME__`'> __CPPNAME__`'::create(`'$1`')
{
  return Glib::RefPtr<`'__CPPNAME__`'>( new __CPPNAME__`'(`'$2`') );
}
_POP()
')


dnl
dnl _END_CLASS_GOBJECT()
dnl   denotes the end of a class
dnl
define(`_END_CLASS_GOBJECT',`
_SECTION(SECTION_HEADER1)
ifdef(`__BOOL_NO_WRAP_FUNCTION__',`dnl
',`dnl
_STRUCT_PROTOTYPE()
')dnl

__NAMESPACE_BEGIN__ class __CPPNAME__`'_Class; __NAMESPACE_END__
_SECTION(SECTION_HEADER3)

ifdef(`__BOOL_NO_WRAP_FUNCTION__',`dnl
',`dnl
namespace Glib
{
  /** @relates __NAMESPACE__::__CPPNAME__ */
  Glib::RefPtr<__NAMESPACE__::__CPPNAME__> wrap(__CNAME__`'* object, bool take_copy = false);
}
')dnl


dnl
dnl
_SECTION(SECTION_PHEADER)

#include <glibmm/class.h>

__NAMESPACE_BEGIN__

_PH_CLASS_DECLARATION()

__NAMESPACE_END__

_SECTION(SECTION_SRC_GENERATED)

ifdef(`__BOOL_NO_WRAP_FUNCTION__',`dnl
',`dnl else
namespace Glib
{

Glib::RefPtr<__NAMESPACE__::__CPPNAME__> wrap(__CNAME__`'* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<__NAMESPACE__::__CPPNAME__>( dynamic_cast<__NAMESPACE__::__CPPNAME__*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */
')dnl endif




__NAMESPACE_BEGIN__


/* The *_Class implementation: */

_PCC_CLASS_IMPLEMENTATION()

Glib::ObjectBase* __CPPNAME__`'_Class::wrap_new(GObject* o)
{
  return new __CPPNAME__`'((__CNAME__*)`'(o));
}


/* The implementation: */

__CNAME__* __CPPNAME__::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<__CPPNAME__> __CPPNAME__::wrap_specific_type(__CNAME__* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<__CPPNAME__> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    __CPPNAME__* pCppObject = dynamic_cast<__CPPNAME__*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<__CPPNAME__>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<__CPPNAME__>( new __CPPNAME__`'(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

__CPPNAME__::__CPPNAME__`'(__CNAME__* castitem)
: __CPPPARENT__`'(__PCAST__`'(castitem))
{}

__CPPNAME__::~__CPPNAME__`'()
{
}

_CC_CLASS_IMPLEMENTATION()

__NAMESPACE_END__

dnl
dnl
dnl
dnl
_POP()
dnl
dnl The actual class, e.g. Gtk::Widget, declaration:
dnl _IMPORT(SECTION_H_SIGNALPROXIES_CUSTOM)

_IMPORT(SECTION_CLASS1)
public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef __CPPNAME__          CppObjectType;
  typedef __CPPNAME__`'_Class    CppClassType;
  typedef __CNAME__           BaseObjectType;
ifdef(`__BOOL_NO_DERIVED_CLASS__',`dnl
',`dnl
  typedef __REAL_CNAME__`'Class      BaseClassType;
')dnl

private:
  friend class __CPPNAME__`'_Class;
  static CppClassType `'__BASE__`'_class_;

  __CPPNAME__`'(const __CPPNAME__&);
  __CPPNAME__& operator=(const __CPPNAME__&); // not implemented

protected:
  explicit __CPPNAME__`'(__CNAME__* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~__CPPNAME__`'();

  static Glib::RefPtr<__CPPNAME__> wrap_specific_type(__CNAME__* gobject, bool take_copy = false); //Re-uses the existing wrapper, if it exists.

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  __CNAME__* gobj()             { return (__CNAME__*)`'(gobject_); }
  const __CNAME__* gobj() const { return (__CNAME__*)`'(gobject_); }

  __CNAME__* gobj_copy();

_H_VFUNCS_AND_SIGNALS()

private:
_IMPORT(SECTION_CLASS2)

')

