// -*- c++ -*-
/* $Id: menu_elems.cc,v 1.9 2002/07/13 15:58:35 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkimagemenuitem.h>

#include <gtkmm/menu_elems.h>
#include <gtkmm/label.h>
#include <strings.h>

namespace Gtk
{

namespace Menu_Helpers
{

Element::Element()
: child_(0)
{}

Element::Element(MenuItem& child)
: child_(&child)
{}

Element::Element(Widget& widget, const AccelKey& accel_key)
{
  child_ = manage(new MenuItem(widget));
  set_child_key(accel_key);
  child_->show();
}

Element::~Element()
{}

void Element::set_child_key(const AccelKey& accel_key)
{
  if(child_)
  {
    child_->accel_key_ = accel_key;
  }
}

void
Element::set_slot(const CallSlot& slot, 
                  const Glib::ustring& accel_signal)
{
  g_return_if_fail (child_ != 0);

  if(slot)
  {
    if(accel_signal == "activate") //The derived classes' constructors have appropriate default argument values.
    {
      child_->signal_activate().connect(slot);
    }
    else if (accel_signal == "toggled")
    {
      Glib::RefPtr<CheckMenuItem> pMenuItem = Glib::RefPtr<CheckMenuItem>::cast_dynamic(child_);
      if(pMenuItem)
        pMenuItem->signal_toggled().connect(slot);
    }
/*
    g_warning("Menu_Helpers::MenuElem: Connecting to signal \"%s\" "
                    "not yet implemented\n", accel_signal.c_str());
*/
  }
}

void
Element::set_navigation(const Glib::ustring& label,
                        const AccelKey& accel_key)
{
  g_return_if_fail (child_ != 0);

  child_->add_accel_label(label, true); //true = use_mnemonic.

  set_child_key(accel_key);
}

const Glib::RefPtr<MenuItem>& Element::get_child() const
{
  return child_;
}

void
Element::init(const Glib::ustring& label,
	      const CallSlot& slot,
	      const Glib::ustring& accel_signal,
	      const AccelKey& key)
{
  set_navigation(label, key);
  set_slot(slot, accel_signal);
  child_->show();
}

void
Element::init(const Glib::ustring& label, 
              Gtk::Menu& submenu,
              const AccelKey& key)
{
  set_navigation(label, key);
  child_->set_submenu(submenu);
  child_->show();
}

MenuElem::MenuElem(MenuItem& child)
: Element(child)
{}

MenuElem::MenuElem(const Glib::ustring& label, 
                   const CallSlot& slot,
                   const Glib::ustring& accel_signal)
{
  child_ = manage(new MenuItem());
  init(label, slot, accel_signal);
}

MenuElem::MenuElem(const Glib::ustring& label,
                   const AccelKey& accel_key,
                   const CallSlot& slot,
                   const Glib::ustring& accel_signal)
{
  child_ = manage(new MenuItem());
  init(label, slot, accel_signal, accel_key);
}

MenuElem::MenuElem(const Glib::ustring& label, Menu& submenu)
{
  child_ = manage(new MenuItem());
  init(label, submenu);
}

MenuElem::MenuElem(const Glib::ustring& label, 
                   const AccelKey& accel_key,
                   Gtk::Menu& submenu)
{
  child_ = manage(new MenuItem());
  init(label, submenu, accel_key);
}

SeparatorElem::SeparatorElem()
{
  child_ = manage(new SeparatorMenuItem());
  child_->show();
}

ImageMenuElem::ImageMenuElem(ImageMenuItem& child)
: Element(child)
{}

ImageMenuElem::ImageMenuElem(const Glib::ustring& label,
    const Gtk::Widget& image_widget,
    const CallSlot& slot,
    const Glib::ustring& accel_signal)
{
  child_ = manage(new ImageMenuItem());
  gtk_image_menu_item_set_image((GtkImageMenuItem*)child_->gobj(),
                                (GtkWidget*)image_widget.gobj());
  init(label, slot, accel_signal);
}

ImageMenuElem::ImageMenuElem(const Glib::ustring& label,
    const AccelKey& accel_key,
    const Gtk::Widget& image_widget,
    const CallSlot& slot,
    const Glib::ustring& accel_signal)
{
  child_ = manage(new ImageMenuItem());
  gtk_image_menu_item_set_image((GtkImageMenuItem*)child_->gobj(),
                                (GtkWidget*)image_widget.gobj());
  init(label, slot, accel_signal, accel_key);
}

ImageMenuElem::ImageMenuElem(const Glib::ustring& label,
    const Gtk::Widget& image_widget,
    Gtk::Menu& submenu)
{
  child_ = manage(new ImageMenuItem());
  gtk_image_menu_item_set_image((GtkImageMenuItem*)child_->gobj(),
                                (GtkWidget*)image_widget.gobj());
  init(label, submenu);
}

ImageMenuElem::ImageMenuElem(const Glib::ustring& label,
    const AccelKey& accel_key,
    const Gtk::Widget& image_widget,
    Gtk::Menu& submenu)
{
  child_ = manage(new ImageMenuItem());
  gtk_image_menu_item_set_image((GtkImageMenuItem*)child_->gobj(),
                                (GtkWidget*)image_widget.gobj());
  init(label, submenu, accel_key);
}

StockMenuElem::StockMenuElem(const Gtk::StockID& stock_id,
                             const CallSlot& slot,
                             const Glib::ustring& accel_signal)
{
  child_ = manage(new ImageMenuItem(stock_id));
  child_->show();
  set_slot(slot, accel_signal);
}

StockMenuElem::StockMenuElem(const Gtk::StockID& stock_id,
                             const AccelKey& accel_key,
                             const CallSlot& slot,
                             const Glib::ustring& accel_signal)
{
  child_ = manage(new ImageMenuItem(stock_id));
  child_->show();
  set_slot(slot, accel_signal);
  set_child_key(accel_key);
}

CheckMenuElem::CheckMenuElem(CheckMenuItem& child)
: Element(child)
{}

CheckMenuElem::CheckMenuElem(const Glib::ustring& label,
                             const CallSlot& slot,
                             const Glib::ustring& accel_signal)
{
  child_ = manage(new CheckMenuItem());
  init(label, slot, accel_signal);
}

CheckMenuElem::CheckMenuElem(const Glib::ustring& label,
                             const AccelKey& accel_key,
                             const CallSlot& slot,
                             const Glib::ustring& accel_signal)
{
  child_ = manage(new CheckMenuItem());
  init(label, slot, accel_signal, accel_key);
}


RadioMenuElem::RadioMenuElem(RadioMenuItem& child)
: Element(child), gr_(0)
{}

RadioMenuElem::RadioMenuElem(RadioMenuItem::Group& group,
                             const Glib::ustring& label,
                             const CallSlot& slot,
                             const Glib::ustring& accel_signal)
  : gr_(&group)
{
  child_ = manage(new RadioMenuItem(*gr_));
  init(label, slot, accel_signal);
}

RadioMenuElem::RadioMenuElem(RadioMenuItem::Group& gr,
                             const Glib::ustring& label,
                             const AccelKey& accel_key,
                             const CallSlot& slot,
                             const Glib::ustring& accel_signal)
  : gr_(&gr)
{
  child_ = manage(new RadioMenuItem(*gr_));
  init(label, slot, accel_signal, accel_key);
}

TearoffMenuElem::TearoffMenuElem(TearoffMenuItem& child)
: Element(child)
{}

TearoffMenuElem::TearoffMenuElem(const CallSlot& slot,
                                 const Glib::ustring& accel_signal)
{
  child_ = manage(new TearoffMenuItem());
  init(slot, accel_signal);
}

TearoffMenuElem::TearoffMenuElem(const AccelKey& accel_key,
                                 const CallSlot& slot,
                                 const Glib::ustring& accel_signal)
{
  child_ = manage(new TearoffMenuItem());
  init(slot, accel_signal, accel_key);
}

void
TearoffMenuElem::init(const CallSlot& slot,
                      const Glib::ustring& accel_signal,
                      const AccelKey& accel_key)
{
  set_child_key(accel_key);
  set_slot(slot, accel_signal);
  child_->show();
}

} /* namespace Menu_Helpers */

} /* namespace Gtk */

