// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_STATUSBAR_H
#define _GTKMM_STATUSBAR_H

#include <glibmm.h>

/* $Id: statusbar.hg,v 1.26 2002/04/21 23:40:14 murrayc Exp $ */

/* statusbar.h
 * 
 * Copyright (C) 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/box.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkStatusbar GtkStatusbar;
typedef struct _GtkStatusbarClass GtkStatusbarClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Statusbar_Class; } // namespace Gtk
namespace Gtk
{

/** Text status indicator
 * This widget is used to display status information.
 * Messages are pushed and poped onto a message stack.
 * When text is pushed it replaces the old contents.
 * The old text is restored when popped.
 *
 * It derives from Gtk::HBox so that additional information can be added
 * easily.
 *
 * The message list can be accessed through the messages() list.
 *
 * @ingroup Widgets
 */

class Statusbar : public HBox
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Statusbar CppObjectType;
  typedef Statusbar_Class CppClassType;
  typedef GtkStatusbar BaseObjectType;
  typedef GtkStatusbarClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Statusbar();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Statusbar_Class;
  static CppClassType statusbar_class_;

  // noncopyable
  Statusbar(const Statusbar&);
  Statusbar& operator=(const Statusbar&);

protected:
  explicit Statusbar(const Glib::ConstructParams& construct_params);
  explicit Statusbar(GtkStatusbar* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkStatusbar*       gobj()       { return reinterpret_cast<GtkStatusbar*>(gobject_); }
  const GtkStatusbar* gobj() const { return reinterpret_cast<GtkStatusbar*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_text_pushed(guint context_id, const Glib::ustring& text);
  virtual void on_text_popped(guint context_id, const Glib::ustring& text);


private:

  
public:
  Statusbar();

  
  /** 
   * Returns a new context identifier, given a description of the actual context.
   * 
   * 
   * being used in.
   * @param context_description Textual description of what context the new message is.
   * @return An integer id.
   */
  guint get_context_id(const Glib::ustring& context_description);
  guint push(const Glib::ustring& text, guint context_id = 0);
  
  /** 
   * Removes the message at the top of a Gtk::StatusBar's stack.
   * 
   * @param context_id A context identifier.
   */
  void pop(guint context_id = 0);
  void remove_message(guint message_id, guint context_id = 0);
  
  /** 
   * Sets whether the statusbar has a resize grip. <tt>true</tt> by default.
   * 
   * @param setting <tt>true</tt> to have a resize grip.
   */
  void set_has_resize_grip(bool setting = true);
  
  /** 
   * Returns whether the statusbar has a resize grip.
   * 
   * 
   * 
   * 
   * &lt;!-- ##### SIGNAL GtkStatusbar::text-popped ##### --&gt;
   * 
   * Is emitted whenever a new message is popped off a statusbar's stack.
   * 
   * 
   * 
   * &lt;!-- ##### SIGNAL GtkStatusbar::text-pushed ##### --&gt;
   * 
   * Is emitted whenever a new message gets pushed onto a statusbar's stack.
   * 
   * @param context_id The context id of the relevant message/statusbar.
   *  the context id of the relevant message/statusbar.
   * @param text The message that was just popped.
   *  the message that was pushed.
   * @return <tt>true</tt> if the statusbar has a resize grip.
   */
  bool get_has_resize_grip() const;

  
  /**
   * @par Prototype:
   * <tt>void %text_pushed(guint context_id, const Glib::ustring& text)</tt>
   */
  Glib::SignalProxy2<void,guint,const Glib::ustring&> signal_text_pushed();

  
  /**
   * @par Prototype:
   * <tt>void %text_popped(guint context_id, const Glib::ustring& text)</tt>
   */
  Glib::SignalProxy2<void,guint,const Glib::ustring&> signal_text_popped();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Statusbar */
  Gtk::Statusbar* wrap(GtkStatusbar* object, bool take_copy = false);
}
#endif /* _GTKMM_STATUSBAR_H */

