// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_COLORMAP_H
#define _GDKMM_COLORMAP_H

#include <glibmm.h>

/* $Id: colormap.hg,v 1.19 2002/10/11 18:05:37 murrayc Exp $ */

/* box.h
 *
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <gdkmm/visual.h>
#include <gdkmm/color.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkColormap GdkColormap;
typedef struct _GdkColormapClass GdkColormapClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class Colormap_Class; } // namespace Gdk
namespace Gdk
{


class Colormap : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Colormap CppObjectType;
  typedef Colormap_Class CppClassType;
  typedef GdkColormap BaseObjectType;
  typedef GdkColormapClass BaseClassType;

private:
  friend class Colormap_Class;
  static CppClassType colormap_class_;

  // noncopyable
  Colormap(const Colormap&);
  Colormap& operator=(const Colormap&);

protected:
  explicit Colormap(const Glib::ConstructParams& construct_params);
  explicit Colormap(GdkColormap* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Colormap();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GdkColormap*       gobj()       { return reinterpret_cast<GdkColormap*>(gobject_); }
  const GdkColormap* gobj() const { return reinterpret_cast<GdkColormap*>(gobject_); }

  GdkColormap* gobj_copy();

private:

  
protected:
  explicit Colormap(const Glib::RefPtr<Visual>& visual, bool allocate);

public:

  
  static Glib::RefPtr<Colormap> create(const Glib::RefPtr<Visual>& visual, bool allocate);


  //_WRAP_METHOD(void change(int ncolors), gdk_colormap_change)

  // Both 'GdkColor* colors' and 'gboolean* success' are _array_ output arguments.
  
  int alloc_colors(GdkColor* colors, int ncolors, bool writeable, bool best_match, gboolean* success);

  
  bool alloc_color(Color& color, bool writeable = false, bool best_match = true);
  
  void free_colors(GdkColor* colors, int ncolors);
  
  /** Locates the RGB color in @a colormap corresponding to the given
   * hardware pixel @a pixel. @a pixel must be a valid pixel in the
   * colormap; it's a programmer error to call this function with a
   * pixel which is not in the colormap. Hardware pixels are normally
   * obtained from alloc_colors(), or from a Gdk::Image. (A
   * Gdk::Image contains image data in hardware format, a Gdk::Pixbuf
   * contains image data in a canonical 24-bit RGB format.)
   * 
   * This function is rarely useful, it's used for example to
   * implement the eyedropper feature in Gtk::ColorSelection.
   * @param pixel Pixel value in hardware display format.
   * @param result Gdk::Color with red, green, blue fields initialized.
   */
  void query_color (gulong pixel, Color& result);

  
  Glib::RefPtr<Visual> get_visual();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} /* namespace Gdk */


namespace Glib
{
  /** @relates Gdk::Colormap */
  Glib::RefPtr<Gdk::Colormap> wrap(GdkColormap* object, bool take_copy = false);
}


#endif /* _GDKMM_COLORMAP_H */

