// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_DISPLAY_H
#define _GDKMM_DISPLAY_H

#include <glibmm.h>

/* $Id: display.hg,v 1.5 2002/11/30 11:11:24 daniel Exp $ */

/* display.h
 *
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdkmm/screen.h>
#include <gdkmm/device.h>
#include <gdkmm/types.h> //For ModifierType


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkDisplay GdkDisplay;
typedef struct _GdkDisplayClass GdkDisplayClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class Display_Class; } // namespace Gdk
namespace Gdk
{


class Drawable;


class Display : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Display CppObjectType;
  typedef Display_Class CppClassType;
  typedef GdkDisplay BaseObjectType;
  typedef GdkDisplayClass BaseClassType;

private:
  friend class Display_Class;
  static CppClassType display_class_;

  // noncopyable
  Display(const Display&);
  Display& operator=(const Display&);

protected:
  explicit Display(const Glib::ConstructParams& construct_params);
  explicit Display(GdkDisplay* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Display();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GdkDisplay*       gobj()       { return reinterpret_cast<GdkDisplay*>(gobject_); }
  const GdkDisplay* gobj() const { return reinterpret_cast<GdkDisplay*>(gobject_); }

  GdkDisplay* gobj_copy();

private:

protected:
  Display();

public:
  
  static Glib::RefPtr<Display> open(const Glib::ustring& display_name);;

  
  Glib::ustring get_name() const;

  
  int get_n_screens() const;
  
  Glib::RefPtr<Screen> get_screen(int screen_num);
  
  Glib::RefPtr<Screen> get_default_screen();
  
  void pointer_ungrab(guint32 time_);
  
  void keyboard_ungrab(guint32 time_);
  
  bool pointer_is_grabbed() const;
  
  void beep();
  
  void sync();
  
  void	close();

  
  Glib::ListHandle< Glib::RefPtr<Device> > list_devices();

  
  GdkEvent* get_event();
  
  GdkEvent* peek_event();
  
  void put_event(GdkEvent* event);

  //TODO:
  
  void add_client_message_filter(GdkAtom message_type, GdkFilterFunc func, gpointer data);

  
  void set_double_click_time(guint msec);

  
  static Glib::RefPtr<Display> get_default();
  //TODO: _WRAP_METHOD(static Glib::RefPtr<const Display> get_default() const, gdk_display_get_default)

  
  Glib::RefPtr<Device> get_core_pointer();
  
  Glib::RefPtr<const Device> get_core_pointer() const;
  
  void get_pointer(Glib::RefPtr<Screen>& screen, int& x, int& y, ModifierType& mask);
  
  Glib::RefPtr<Window> get_window_at_pointer(int& win_x, int& win_y);

  
  GdkDisplayPointerHooks* set_pointer_hooks(const GdkDisplayPointerHooks *new_hooks);

  
  static Glib::RefPtr<Display> open_default_libgtk_only();

  guint32 get_drag_protocol(guint32 xid, GdkDragProtocol* protocol);
  

  GdkKeymap* get_keymap();
  

  bool set_selection_owner(const Glib::RefPtr<Window>& owner, GdkAtom selection, guint32 time_, bool send_event);
  Glib::RefPtr<Window> get_selection_owner(GdkAtom selection);
  void selection_send_notify(guint32 requestor, GdkAtom selection, GdkAtom target, GdkAtom property, guint32 time_);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} /* namespace Gdk */


namespace Glib
{
  /** @relates Gdk::Display */
  Glib::RefPtr<Gdk::Display> wrap(GdkDisplay* object, bool take_copy = false);
}


#endif /* _GDKMM_DISPLAY_H */

