// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_PIXBUFFORMAT_H
#define _GDKMM_PIXBUFFORMAT_H


#include <glibmm.h>

/* $Id$ */

/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <gdkmmconfig.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GdkPixbufFormat GdkPixbufFormat; }
#endif

namespace Gdk
{

class PixbufFormat
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef PixbufFormat CppObjectType;
  typedef GdkPixbufFormat BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:


public:
  PixbufFormat();
  explicit PixbufFormat(const GdkPixbufFormat* gobject);
  virtual ~PixbufFormat();

  PixbufFormat(const PixbufFormat& src);
  PixbufFormat& operator=(const PixbufFormat& src);

  
  /** Return value: the name of the format.
   * @return The name of the format. 
   * 
   * @newin2p2.
   */
  Glib::ustring get_name() const;
  
  /** Return value: a description of the format.
   * @return A description of the format.
   * 
   * @newin2p2.
   */
  Glib::ustring get_description() const;
  
  /** Return value: a <tt>0</tt>-terminated array of mime types which must be freed with
   * @return A <tt>0</tt>-terminated array of mime types which must be freed with 
   * Glib::strfreev() when it is no longer needed.
   * 
   * @newin2p2.
   */
  Glib::StringArrayHandle get_mime_types() const;
  
  /** Return value: a <tt>0</tt>-terminated array of filename extensions which must be
   * @return A <tt>0</tt>-terminated array of filename extensions which must be
   * freed with Glib::strfreev() when it is no longer needed.
   * 
   * @newin2p2.
   */
  Glib::StringArrayHandle get_extensions() const;
  
  /** Return value: whether pixbufs can be saved in the given format.
   * @return Whether pixbufs can be saved in the given format.
   * 
   * @newin2p2.
   */
  bool is_writable() const;
  
  
  /** Return value: whether this image format is scalable.
   * @return Whether this image format is scalable.
   * 
   * @newin2p6.
   */
  bool is_scalable() const;
  
  /** Return value: whether this image format is disabled.
   * @return Whether this image format is disabled.
   * 
   * @newin2p6.
   */
  bool is_disabled() const;
  
  /** Disables or enables an image format. If a format is disabled, 
   * gdk-pixbuf won't use the image loader for this format to load 
   * images. Applications can use this to avoid using image loaders 
   * with an inappropriate license, see gdk_pixbuf_format_get_license().
   * 
   * @newin2p6
   * @param disabled <tt>true</tt> to disable the format @a format.
   */
  void set_disabled(bool disabled = true);
  
  /** Returns: a string describing the license of @a format.
   * @return A string describing the license of @a format. 
   * 
   * @newin2p6.
   */
  Glib::ustring get_license() const;

  /// Provides access to the underlying C GObject.
  GdkPixbufFormat*       gobj()       { return const_cast<GdkPixbufFormat*>(gobject_); }
  /// Provides access to the underlying C GObject.
  const GdkPixbufFormat* gobj() const { return gobject_; }

protected:
  const GdkPixbufFormat* gobject_;


};

} // namespace Gdk


#endif /* _GDKMM_PIXBUFFORMAT_H */

