// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _ATKMM_TABLE_H
#define _ATKMM_TABLE_H

#include <glibmm.h>

/* $Id: table.hg,v 1.1.1.1 2003/01/21 13:37:07 murrayc Exp $ */

/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C"
{
  typedef struct _AtkTableIface AtkTableIface;
  typedef struct _AtkTable      AtkTable;
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _AtkTable AtkTable;
typedef struct _AtkTableClass AtkTableClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Atk
{ class Table_Class; } // namespace Atk
namespace Atk
{

class Object;


class Table : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Table CppObjectType;
  typedef Table_Class CppClassType;
  typedef AtkTable BaseObjectType;
  typedef AtkTableIface BaseClassType;

private:
  friend class Table_Class;
  static CppClassType table_class_;

  // noncopyable
  Table(const Table&);
  Table& operator=(const Table&);

protected:
  Table(); // you must derive from this class
  explicit Table(AtkTable* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Table();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  AtkTable*       gobj()       { return reinterpret_cast<AtkTable*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const AtkTable* gobj() const { return reinterpret_cast<AtkTable*>(gobject_); }

private:


public:
  
  Glib::RefPtr<Atk::Object> get_at(int row, int column);
  
  int get_index_at(int row, int column) const;
  
  int get_column_at_index(int index) const;
  
  int get_row_at_index(int index) const;
  
  int get_n_columns() const;
  
  int get_n_rows() const;
  
  int get_column_extent_at(int row, int column) const;
  
  int get_row_extent_at(int row, int column) const;
  
  Glib::RefPtr<Atk::Object> get_caption();
  
  Glib::ustring get_column_description(int column) const;
  
  Glib::RefPtr<Atk::Object> get_column_header(int column);
  
  Glib::ustring get_row_description(int row) const;
  
  Glib::RefPtr<Atk::Object> get_row_header(int row);
  
  Glib::RefPtr<Atk::Object> get_summary();
  
  void set_caption(const Glib::RefPtr<Atk::Object>& caption);
  
  void set_column_description(int column, const Glib::ustring& description);
  
  void set_column_header(int column, const Glib::RefPtr<Atk::Object>& header);
  
  void set_row_description(int row, const Glib::ustring& description);
  
  void set_row_header(int row, const Glib::RefPtr<Atk::Object>& header);
  
  void set_summary(const Glib::RefPtr<Atk::Object>& accessible);

  
  Glib::ArrayHandle<int> get_selected_columns() const;
  Glib::ArrayHandle<int> get_selected_rows() const;

  
  bool is_column_selected(int column) const;
  
  bool is_row_selected(int row) const;
  
  bool is_selected(int row, int column) const;
  
  bool add_row_selection(int row);
  
  bool remove_row_selection(int row);
  
  bool add_column_selection(int column);
  
  bool remove_column_selection(int column);

  
  /**
   * @par Prototype:
   * <tt>void %row_inserted(int row, int num_inserted)</tt>
   */
  Glib::SignalProxy2<void,int,int> signal_row_inserted();

  
  /**
   * @par Prototype:
   * <tt>void %column_inserted(int column, int num_inserted)</tt>
   */
  Glib::SignalProxy2<void,int,int> signal_column_inserted();

  
  /**
   * @par Prototype:
   * <tt>void %row_deleted(int row, int num_deleted)</tt>
   */
  Glib::SignalProxy2<void,int,int> signal_row_deleted();

  
  /**
   * @par Prototype:
   * <tt>void %column_deleted(int column, int num_deleted)</tt>
   */
  Glib::SignalProxy2<void,int,int> signal_column_deleted();

  
  /**
   * @par Prototype:
   * <tt>void %row_reordered()</tt>
   */
  Glib::SignalProxy0<void> signal_row_reordered();

  
  /**
   * @par Prototype:
   * <tt>void %column_reordered()</tt>
   */
  Glib::SignalProxy0<void> signal_column_reordered();

  
  /**
   * @par Prototype:
   * <tt>void %model_changed()</tt>
   */
  Glib::SignalProxy0<void> signal_model_changed();


protected:
  
  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
  virtual Glib::RefPtr<Atk::Object> get_at_vfunc(int row, int column);
  virtual int get_index_at_vfunc(int row, int column);
  virtual int get_column_at_index_vfunc(int index);
  virtual int get_row_at_index_vfunc(int index);
  virtual int get_n_columns_vfunc();
  virtual int get_n_rows_vfunc();
  virtual int get_column_extent_at_vfunc(int row, int column);
  virtual int get_row_extent_at_vfunc(int row, int column);
  virtual Glib::RefPtr<Atk::Object> get_caption_vfunc();
  virtual const char* get_column_description_vfunc(int column);
  virtual Glib::RefPtr<Atk::Object> get_column_header_vfunc(int column);
  virtual const char* get_row_description_vfunc(int row);
  virtual Glib::RefPtr<Atk::Object> get_row_header_vfunc(int row);
  virtual Glib::RefPtr<Atk::Object> get_summary_vfunc();
  virtual void set_caption_vfunc(const Glib::RefPtr<Atk::Object>& caption);
  virtual void set_column_description_vfunc(int column, const char* description);
  virtual void set_column_header_vfunc(int column, const Glib::RefPtr<Atk::Object>& header);
  virtual void set_row_description_vfunc(int row, const char* description);
  virtual void set_row_header_vfunc(int row, const Glib::RefPtr<Atk::Object>& header);
  virtual void set_summary_vfunc(const Glib::RefPtr<Atk::Object>& accessible);
  virtual bool is_column_selected_vfunc(int column);
  virtual bool is_row_selected_vfunc(int row);
  virtual bool is_selected_vfunc(int row, int column);
  virtual bool add_row_selection_vfunc(int row);
  virtual bool remove_row_selection_vfunc(int row);
  virtual bool add_column_selection_vfunc(int column);
  virtual bool remove_column_selection_vfunc(int column);
  virtual int get_selected_columns_vfunc(int** selected);
  virtual int get_selected_rows_vfunc(int** selected);

  //Default Signal Handlers::
  virtual void on_row_inserted(int row, int num_inserted);
  virtual void on_column_inserted(int column, int num_inserted);
  virtual void on_row_deleted(int row, int num_deleted);
  virtual void on_column_deleted(int column, int num_deleted);
  virtual void on_row_reordered();
  virtual void on_column_reordered();
  virtual void on_model_changed();


};

} // namespace Atk


namespace Glib
{

/** @relates Atk::Table */
Glib::RefPtr<Atk::Table> wrap(AtkTable* object, bool take_copy = false);

} // namespace Glib

#endif /* _ATKMM_TABLE_H */

