// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _PANGOMM_LAYOUT_H
#define _PANGOMM_LAYOUT_H

#include <glibmm.h>

/* $Id: layout.hg,v 1.2 2003/07/12 13:54:38 murrayc Exp $ */

/* layout.h
 *
 * Copyright(C) 1998-1999 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/object.h>
#include <glibmm/slisthandle.h>
#include <pangomm/font.h>
#include <pangomm/fontdescription.h>
#include <pangomm/context.h>
#include <pangomm/attrlist.h>
#include <pangomm/tabarray.h>
#include <pangomm/layoutline.h>
#include <pangomm/layoutiter.h>
#include <pango/pango-layout.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _PangoLayout PangoLayout;
typedef struct _PangoLayoutClass PangoLayoutClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Pango
{ class Layout_Class; } // namespace Pango
namespace Pango
{


/** @addtogroup pangommEnums Enums and Flags */

/**
 * @ingroup pangommEnums
 */
enum Alignment
{
  ALIGN_LEFT,
  ALIGN_CENTER,
  ALIGN_RIGHT
};

} // namespace Pango


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Pango::Alignment> : public Glib::Value_Enum<Pango::Alignment>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Pango
{

/**
 * @ingroup pangommEnums
 */
enum WrapMode
{
  WRAP_WORD,
  WRAP_CHAR,
  WRAP_WORD_CHAR
};

} // namespace Pango


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Pango::WrapMode> : public Glib::Value_Enum<Pango::WrapMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Pango
{


/** A Pango::Layout represents and entire paragraph of text.
 * It is initialized with a Pango::Context, UTF-8 string and set of attributes for that string.
 * Once that is done, the set of formatted lines can be extracted from the object,
 * the layout can be rendered, and conversion between logical character positions
 * within the layout's text, and the physical position of the resulting glyphs can be made.
 */

class Layout : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Layout CppObjectType;
  typedef Layout_Class CppClassType;
  typedef PangoLayout BaseObjectType;
  typedef PangoLayoutClass BaseClassType;

private:
  friend class Layout_Class;
  static CppClassType layout_class_;

  // noncopyable
  Layout(const Layout&);
  Layout& operator=(const Layout&);

protected:
  explicit Layout(const Glib::ConstructParams& construct_params);
  explicit Layout(PangoLayout* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Layout();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  PangoLayout*       gobj()       { return reinterpret_cast<PangoLayout*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const PangoLayout* gobj() const { return reinterpret_cast<PangoLayout*>(gobject_); }

  PangoLayout* gobj_copy();

private:

  
protected:
  explicit Layout(const Glib::RefPtr<Context>& context);

public:
  
  static Glib::RefPtr<Layout> create(const Glib::RefPtr<Context>& context);


  Glib::RefPtr<Layout> copy();
  
  Glib::RefPtr<Context> get_context() const;
  
  void set_attributes(AttrList& attrs);
  
  AttrList get_attributes() const;

  /** Set the text of the layout.
   * @param text The text for the layout.
   */
  void set_text(const Glib::ustring& text);

  
  Glib::ustring get_text() const;

  /** Sets the layout text and attribute list from marked-up text (see markup format).
   * Replaces the current text and attribute list.
   * @param markup Some marked-up text.
   */
  void set_markup(const Glib::ustring& markup);

  /** Sets the layout text and attribute list from marked-up text (see markup format).
   * Replaces the current text and attribute list.
   *
   * If @a accel_marker is nonzero, the given character will mark the character following
   * it as an accelerator. For example, the accel marker might be an ampersand or
   * underscore. All characters marked as an accelerator will receive a
   * Pango::UNDERLINE_LOW attribute, and the first character so marked will be returned
   * in @a accel_char. Two @a accel_marker characters following each other produce a
   * single literal @a accel_marker character.
   * @param markup Some marked-up text.
   * @param accel_marker Marker for accelerators in the text.
   * @param accel_char Return location for any located accelerators.
   */
  void set_markup(const Glib::ustring& markup, gunichar accel_marker, gunichar& accel_char);

  
  void set_font_description(const FontDescription& desc);
  //TODO: Add void unset_font_description(), using pango_layout_set_font_description()

  
  void set_width(int width);
  
  int get_width() const;
  
  void set_wrap(WrapMode wrap);
  
  WrapMode get_wrap() const;
  
  void set_indent(int indent);
  
  int get_indent() const;
  
  void set_spacing(int spacing);
  
  int get_spacing() const;
  
  void set_justify(bool justify = true);
  
  bool get_justify() const;
  
  void set_alignment(Alignment alignment);
  
  Alignment get_alignment() const;

  
  void set_tabs(TabArray& tabs);
  
  TabArray get_tabs() const;

  
  void set_single_paragraph_mode(bool setting = true);
  
  bool get_single_paragraph_mode() const;

  
  void context_changed();

  /** Retrieve an array of logical attributes for each character in the layout.
   * @return An array of logical attributes.
   */
  Glib::ArrayHandle<LogAttr> get_log_attrs() const;

  /** Convert from an index within the layout to the onscreen position corresponding to the grapheme at that index, which is represented as rectangle.
   * Note that @a x in the returned rectangle is always the leading edge of the grapheme
   * and @a x + @a width the trailing edge of the grapheme.
   * If the directionality of the grapheme is right-to-left, then @a width will be negative.
   * @param index Byte index within layout.
   * @return The position of the grapheme.
   */
  Rectangle index_to_pos(int index) const;

  
  void get_cursor_pos(int index, Rectangle& strong_pos, Rectangle& weak_pos) const;

  /** Given an index within the layout, determine the positions that of the strong cursors if the insertion point is at that index.
   * @param index The byte index of the cursor.
   * @return The strong cursor position.
   */
  Rectangle get_cursor_strong_pos(int index) const;

  /** Given an index within the layout, determine the positions that of the weak cursors if the insertion point is at that index.
   * @param index The byte index of the cursor.
   * @return The weak cursor position.
   */
  Rectangle get_cursor_weak_pos(int index) const;

  
  void move_cursor_visually(bool strong,
     int old_index, int old_trailing, int direction,
     int& new_index, int& new_trailing) const;

  
  bool xy_to_index(int x, int y, int& index, int& trailing) const;

  
  void get_extents(Rectangle& ink_rect, Rectangle& logical_rect) const;

  /** Compute the ink extents of layout.
   * @return The extents of the layout as drawn.
   */
  Rectangle get_ink_extents() const;

  /** Compute the logical extents of layout.
   * @return The logical extents of the layout.
   */
  Rectangle get_logical_extents() const;

  
  void get_pixel_extents(Rectangle& ink_rect, Rectangle& logical_rect) const;

  /** Compute the ink extents of the layout in device units.
   * @return The extents of the layout as drawn.
   */
  Rectangle get_pixel_ink_extents() const;

  /** Compute the logical extents of the layout in device units.
   * @return The logical extents of the layout.
   */
  Rectangle get_pixel_logical_extents() const;

  
  void get_size(int& width, int& height) const;
  
  void get_pixel_size(int& width, int& height) const;

  
  int get_line_count() const;
  
  Glib::RefPtr<LayoutLine> get_line(int line) const;
  
  SListHandle_LayoutLine get_lines() const;

  /** Gets an iterator to iterate over the visual extents of the layout.
   * @param iter Location to store the iterator.
   */
  void get_iter(LayoutIter& iter);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} /* namespace Pango */


namespace Glib
{
  /** @relates Pango::Layout */
  Glib::RefPtr<Pango::Layout> wrap(PangoLayout* object, bool take_copy = false);
}


#endif /* _PANGOMM_LAYOUT_H */

