// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_FILEFILTER_H
#define _GTKMM_FILEFILTER_H

#include <glibmm.h>

/* $Id: filefilter.hg,v 1.5 2004/02/10 14:50:11 murrayc Exp $ */

/* Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/widget.h>
#include <gtkmm/accelgroup.h>
#include <gtkmm/stockid.h>


//TODO: remove this if we wrap this in a C++ type:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkFileFilterInfo GtkFileFilterInfo;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkFileFilter GtkFileFilter;
typedef struct _GtkFileFilterClass GtkFileFilterClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class FileFilter_Class; } // namespace Gtk
namespace Gtk
{

/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%FileFilterFlags operator|(FileFilterFlags, FileFilterFlags)</tt><br>
 * <tt>%FileFilterFlags operator&(FileFilterFlags, FileFilterFlags)</tt><br>
 * <tt>%FileFilterFlags operator^(FileFilterFlags, FileFilterFlags)</tt><br>
 * <tt>%FileFilterFlags operator~(FileFilterFlags)</tt><br>
 * <tt>%FileFilterFlags& operator|=(FileFilterFlags&, FileFilterFlags)</tt><br>
 * <tt>%FileFilterFlags& operator&=(FileFilterFlags&, FileFilterFlags)</tt><br>
 * <tt>%FileFilterFlags& operator^=(FileFilterFlags&, FileFilterFlags)</tt><br>
 */
enum FileFilterFlags
{
  FILE_FILTER_FILENAME = 1 << 0,
  FILE_FILTER_URI = 1 << 1,
  FILE_FILTER_DISPLAY_NAME = 1 << 2,
  FILE_FILTER_MIME_TYPE = 1 << 3
};

/** @ingroup gtkmmEnums */
inline FileFilterFlags operator|(FileFilterFlags lhs, FileFilterFlags rhs)
  { return static_cast<FileFilterFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline FileFilterFlags operator&(FileFilterFlags lhs, FileFilterFlags rhs)
  { return static_cast<FileFilterFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline FileFilterFlags operator^(FileFilterFlags lhs, FileFilterFlags rhs)
  { return static_cast<FileFilterFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline FileFilterFlags operator~(FileFilterFlags flags)
  { return static_cast<FileFilterFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline FileFilterFlags& operator|=(FileFilterFlags& lhs, FileFilterFlags rhs)
  { return (lhs = static_cast<FileFilterFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline FileFilterFlags& operator&=(FileFilterFlags& lhs, FileFilterFlags rhs)
  { return (lhs = static_cast<FileFilterFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline FileFilterFlags& operator^=(FileFilterFlags& lhs, FileFilterFlags rhs)
  { return (lhs = static_cast<FileFilterFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::FileFilterFlags> : public Glib::Value_Flags<Gtk::FileFilterFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


class FileFilter : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef FileFilter CppObjectType;
  typedef FileFilter_Class CppClassType;
  typedef GtkFileFilter BaseObjectType;
  typedef GtkFileFilterClass BaseClassType;

private:  friend class FileFilter_Class;
  static CppClassType filefilter_class_;

private:
  // noncopyable
  FileFilter(const FileFilter&);
  FileFilter& operator=(const FileFilter&);

protected:
  explicit FileFilter(const Glib::ConstructParams& construct_params);
  explicit FileFilter(GtkFileFilter* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~FileFilter();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkFileFilter*       gobj()       { return reinterpret_cast<GtkFileFilter*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkFileFilter* gobj() const { return reinterpret_cast<GtkFileFilter*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkFileFilter* gobj_copy();

private:

  FileFilter();
public:
  
  static Glib::RefPtr<FileFilter> create();


  /** Sets the human-readable name of the filter; this is the string
   * that will be displayed in the file selector user interface if
   * there is a selectable list of filters.
   * 
   * Since: 2.4
   * @param name The human-readable-name for the filter, or <tt>0</tt>
   * to remove any existing name.
   */
  void set_name(const Glib::ustring& name);
  
  /** Gets the human-readable name for the filter. See gtk_file_filter_set_name().
   * @return The human-readable name of the filter,
   * or <tt>0</tt>. This value is owned by GTK+ and must not
   * be modified or freed.
   * 
   * Since: 2.4.
   */
  Glib::ustring get_name() const;

  
  /** Adds a rule allowing a given mime type to @a filter .
   * 
   * Since: 2.4
   * @param mime_type Name of a MIME type.
   */
  void add_mime_type(const Glib::ustring& mime_type);
  
  /** Adds a rule allowing a shell style glob to a filter.
   * 
   * Since: 2.4
   * @param pattern A shell style glob.
   */
  void add_pattern(const Glib::ustring& pattern);

  //TODO: Use C++ type:
  /// For instance, bool on_custom(const GtkFileFilterInfo* filter_info);
  typedef sigc::slot<bool, const GtkFileFilterInfo*> SlotCustom;
  void add_custom(FileFilterFlags needed, const SlotCustom& slot);
  

  /** Gets the fields that need to be filled in for the structure
   * passed to gtk_file_filter_filter()
   * 
   * This function will not typically be used by applications; it
   * is intended principally for use in the implementation of
   * Gtk::FileChooser.
   * @return Bitfield of flags indicating needed fields when
   * calling gtk_file_filter_filter()
   * 
   * Since: 2.4.
   */
  FileFilterFlags get_needed() const;

  //TODO: This method is used by FileChooser implentors, so we might not need to wrap it properly.
  //GtkFileFilterInfo is not a registered GType. It has gchar* members but does not seem to take ownership of those strings.
  
  /** Tests whether a file should be displayed according to @a filter .
   * The Gtk::FileFilterInfo structure @a filter_info  should include
   * the fields returned feom gtk_file_filter_get_needed().
   * 
   * This function will not typically be used by applications; it
   * is intended principally for use in the implementation of
   * Gtk::FileChooser.
   * @param filter_info A Gtk::FileFilterInfo structure containing information
   * about a file.
   * @return <tt>true</tt> if the file should be displayed
   * 
   * Since: 2.4.
   */
  bool filter(const GtkFileFilterInfo* filter_info);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::FileFilter
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gtk::FileFilter> wrap(GtkFileFilter* object, bool take_copy = false);
}


#endif /* _GTKMM_FILEFILTER_H */

