// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gtkmm/treepath.h>
#include <gtkmm/private/treepath_p.h>

// -*- c++ -*-
/* $Id: treepath.ccg,v 1.4.6.1 2005/11/29 16:37:14 murrayc Exp $ */

/* Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/treemodel.h>
#include <glibmm/utility.h>
#include <gtk/gtktreemodel.h>
#include <gtk/gtktreednd.h>


namespace Gtk
{

TreePath::TreePath(TreePath::size_type n, TreePath::value_type value)
:
  gobject_ (gtk_tree_path_new())
{
  for(; n > 0; --n)
    gtk_tree_path_append_index(gobject_, value);
}

TreePath::TreePath(const Glib::ustring& path)
:
  gobject_ (gtk_tree_path_new_from_string(path.c_str()))
{}

TreePath::TreePath(const TreeModel::iterator& iter)
:
  // The GtkTreePath* is always newly created.
  gobject_ (gtk_tree_model_get_path(iter.get_model_gobject(), const_cast<GtkTreeIter*>(iter.gobj())))
{}

TreePath& TreePath::operator=(const TreeModel::iterator& iter)
{
  TreePath temp (iter);
  swap(temp);
  return *this;
}

void TreePath::clear()
{
  TreePath empty_path;
  swap(empty_path);
}

TreePath::size_type TreePath::size() const
{
  return gtk_tree_path_get_depth(gobject_);
}

bool TreePath::empty() const
{
  return (gtk_tree_path_get_depth(gobject_) == 0);
}

TreePath::reference TreePath::operator[](TreePath::size_type i)
{
  int *const indices = gtk_tree_path_get_indices(gobject_);
  return indices[i];
}

TreePath::const_reference TreePath::operator[](TreePath::size_type i) const
{
  const int *const indices = gtk_tree_path_get_indices(gobject_);
  return indices[i];
}

TreePath::iterator TreePath::begin()
{
  return gtk_tree_path_get_indices(gobject_);
}

TreePath::iterator TreePath::end()
{
  return gtk_tree_path_get_indices(gobject_) + gtk_tree_path_get_depth(gobject_);
}

TreePath::const_iterator TreePath::begin() const
{
  return gtk_tree_path_get_indices(gobject_);
}

TreePath::const_iterator TreePath::end() const
{
  return gtk_tree_path_get_indices(gobject_) + gtk_tree_path_get_depth(gobject_);
}

bool TreePath::get_from_selection_data(const SelectionData& selection_data, Glib::RefPtr<TreeModel>& model, TreePath& path) //static 
{
  GtkTreeModel* src_model = 0;
  GtkTreePath* src_path = 0;
  gboolean result = gtk_tree_get_row_drag_data(const_cast<GtkSelectionData*>(selection_data.gobj()), &src_model, &src_path);

  model = Glib::wrap(src_model, true /* take_copy=true */);
  
  //gtk_tree_get_row_drag_data gives us ownership of src_path.
  path = Glib::wrap(src_path, false /* take_copy=false */);

  return result;
}

bool TreePath::get_from_selection_data(const SelectionData& selection_data, TreePath& path) //static
{
  GtkTreePath* src_path = 0;
  gboolean result = gtk_tree_get_row_drag_data(const_cast<GtkSelectionData*>(selection_data.gobj()), 0, &src_path);

  //gtk_tree_get_row_drag_data gives us ownership of src_path.
  path = Glib::wrap(src_path, false /* take_copy=false */);

  return result;
}


bool TreePath::set_in_selection_data(SelectionData& selection_data, const Glib::RefPtr<const TreeModel>& model) const
{
  return gtk_tree_set_row_drag_data(selection_data.gobj(), const_cast<GtkTreeModel*>(model->gobj()), const_cast<GtkTreePath*>(gobj()));  
}

#ifndef GTKMM_DISABLE_DEPRECATED

Glib::ArrayHandle<int> TreePath::get_indices() const
{
  // gtk_tree_path_get_indices() returns a pointer to an internal array,
  // similar to std::string::data().  Thus the OWNERSHIP_NONE flag.

  return Glib::ArrayHandle<int>(gtk_tree_path_get_indices(gobject_),
                                gtk_tree_path_get_depth(gobject_),
                                Glib::OWNERSHIP_NONE);
}
#endif // GTKMM_DISABLE_DEPRECATED

  
} // namespace Gtk


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::TreePath wrap(GtkTreePath* object, bool take_copy)
{
  return Gtk::TreePath(object, take_copy);
}

} // namespace Glib


namespace Gtk
{


// static
GType TreePath::get_type()
{
  return gtk_tree_path_get_type();
}

TreePath::TreePath()
:
  gobject_ (gtk_tree_path_new())
{}

TreePath::TreePath(const TreePath& other)
:
  gobject_ ((other.gobject_) ? gtk_tree_path_copy(other.gobject_) : 0)
{}

TreePath::TreePath(GtkTreePath* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? gtk_tree_path_copy(gobject) : gobject)
{}

TreePath& TreePath::operator=(const TreePath& other)
{
  TreePath temp (other);
  swap(temp);
  return *this;
}

TreePath::~TreePath()
{
  if(gobject_)
    gtk_tree_path_free(gobject_);
}

void TreePath::swap(TreePath& other)
{
  GtkTreePath *const temp = gobject_;
  gobject_ = other.gobject_;
  other.gobject_ = temp;
}

GtkTreePath* TreePath::gobj_copy() const
{
  return gtk_tree_path_copy(gobject_);
}


void TreePath::push_back(int index)

{
  gtk_tree_path_append_index(gobj(), index);  
}


void TreePath::push_front(int index)

{
  gtk_tree_path_prepend_index(gobj(), index);  
}


void TreePath::next()

{
  gtk_tree_path_next(gobj());  
}


bool TreePath::prev()

{
  return gtk_tree_path_prev(gobj()); 
}


bool TreePath::up()

{
  return gtk_tree_path_up(gobj()); 
}


void TreePath::down()

{
  gtk_tree_path_down(gobj());  
}


bool TreePath::is_ancestor(const TreePath& descendant) const

{
  return gtk_tree_path_is_ancestor(const_cast<GtkTreePath*>(gobj()), const_cast<GtkTreePath*>((descendant).gobj())); 
}


bool TreePath::is_descendant(const TreePath& ancestor) const

{
  return gtk_tree_path_is_descendant(const_cast<GtkTreePath*>(gobj()), const_cast<GtkTreePath*>((ancestor).gobj())); 
}


Glib::ustring TreePath::to_string() const

{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_tree_path_to_string(const_cast<GtkTreePath*>(gobj()))); 
}


bool operator==(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) == 0);
}

bool operator!=(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) != 0);
}

bool operator<(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) < 0);
}

bool operator>(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) > 0);
}

bool operator<=(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) <= 0);
}

bool operator>=(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) >= 0);
}


#ifndef GTKMM_DISABLE_DEPRECATED


void TreePath::append_index(int index)

{
  gtk_tree_path_append_index(gobj(), index);  
}
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED


void TreePath::prepend_index(int index)

{
  gtk_tree_path_prepend_index(gobj(), index);  
}
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED


int TreePath::get_depth() const

{
  return gtk_tree_path_get_depth(const_cast<GtkTreePath*>(gobj())); 
}
#endif // GTKMM_DISABLE_DEPRECATED


} // namespace Gtk


