// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_SOURCEMARK_H
#define _GTKSOURCEVIEWMM_SOURCEMARK_H


#include <glibmm.h>

/* sourcemark.h
 *
 * Copyright (C) 2008 Jonathon Jongsma
 * Copyright (C) 2010 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/textmark.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSourceMark GtkSourceMark;
typedef struct _GtkSourceMarkClass GtkSourceMarkClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{ class SourceMark_Class; } // namespace gtksourceview
namespace gtksourceview
{

/** Mark class for SourceBuffer.
 *
 * @newin{2,2}
 */

class SourceMark : public Gtk::TextMark
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SourceMark CppObjectType;
  typedef SourceMark_Class CppClassType;
  typedef GtkSourceMark BaseObjectType;
  typedef GtkSourceMarkClass BaseClassType;

private:  friend class SourceMark_Class;
  static CppClassType sourcemark_class_;

private:
  // noncopyable
  SourceMark(const SourceMark&);
  SourceMark& operator=(const SourceMark&);

protected:
  explicit SourceMark(const Glib::ConstructParams& construct_params);
  explicit SourceMark(GtkSourceMark* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SourceMark();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSourceMark*       gobj()       { return reinterpret_cast<GtkSourceMark*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSourceMark* gobj() const { return reinterpret_cast<GtkSourceMark*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSourceMark* gobj_copy();

private:


protected:
  // TODO: C API does not provide default constructor for GtkSourceMark, should we delete it on API/ABI break? krnowak
   SourceMark();

  /* TODO: When breaking API/ABI add a constructor getting only category parameter to allow explicit anonymous mark creation and empty string names. Maybe also return to normal order of parameters. Does it have sense? krnowak
   */
  // We reversed the parameter order, because name can be NULL:
  explicit SourceMark(const Glib::ustring& category, const Glib::ustring& name = Glib::ustring());
  

public:
  /** Creates a text mark.
   *
   * Add it to a buffer using Gtk::TextBuffer::add_mark(). If @a name is empty
   * string, the mark is anonymous; otherwise, the mark can be retrieved by name
   * using Gtk::TextBuffer::get_mark(). Normally marks are created using the
   * utility function SourceBuffer::create_mark().
   *
   * @param category Is used to classify marks according to common
   * characteristics (e.g. all the marks representing a bookmark could belong to
   * the "bookmark" category, or all the marks representing a compilation error
   * could belong to "error" category).
   * @param name Name of the SourceMark.
   *
   * @return A new SourceMark that can be added using GtkTextBuffer::add_mark().
   */
  
  static Glib::RefPtr<SourceMark> create(const Glib::ustring& category, const Glib::ustring& name =  Glib::ustring());


  /** Returns the mark category.
   *
   * @return The category of the SourceMark.
   *
   * @newin{2,2}
   */
  Glib::ustring get_category() const;

  
  /** Returns the next SourceMark in the buffer.
   *
   * If there is no next mark, empty refptr will be returned.
   *
   * @param category A string specifying the mark category.
   *
   * @return The next SourceMark or empty Glib::RefPtr.
   *
   * @newin{2,2}
   */
  Glib::RefPtr<SourceMark> next(const Glib::ustring& category);

  
  /** Returns the next SourceMark in the buffer.
   *
   * If there is no next mark, empty refptr will be returned.
   *
   * @param category A string specifying the mark category.
   *
   * @return The next SourceMark or empty Glib::RefPtr.
   *
   * @newin{2,2}
   */
  Glib::RefPtr<const SourceMark> next(const Glib::ustring& category) const;

  /** Returns the next SourceMark of any category in the buffer.
   *
   * If there is no next mark, empty refptr will be returned.
   *
   * @return The next SourceMark or empty Glib::RefPtr.
   *
   * @newin{2,2}
   */
  Glib::RefPtr<SourceMark> next();

  /** Returns the next SourceMark of any category in the buffer.
   *
   * If there is no next mark, empty refptr will be returned.
   *
   * @return The next SourceMark or empty Glib::RefPtr.
   *
   * @newin{2,2}
   */
  Glib::RefPtr<const SourceMark> next() const;

  
  /** Returns the previous SourceMark in the buffer.
   *
   * If there is no previous mark, empty refptr will be returned.
   *
   * @param category A string specifying the mark category.
   *
   * @return The previous SourceMark or empty Glib::RefPtr.
   *
   * @newin{2,2}
   */
  Glib::RefPtr<SourceMark> prev(const Glib::ustring& category);

  
  /** Returns the previous SourceMark in the buffer.
   *
   * If there is no previous mark, empty refptr will be returned.
   *
   * @param category A string specifying the mark category.
   *
   * @return The previous SourceMark or empty Glib::RefPtr.
   *
   * @newin{2,2}
   */
  Glib::RefPtr<const SourceMark> prev(const Glib::ustring& category) const;

  /** Returns the previous SourceMark of any category in the buffer.
   *
   * If there is no previous mark, empty refptr will be returned.
   *
   * @return The previous SourceMark or empty Glib::RefPtr.
   *
   * @newin{2,2}
   */
  Glib::RefPtr<SourceMark> prev();

  /** Returns the previous SourceMark of any category in the buffer.
   *
   * If there is no previous mark, empty refptr will be returned.
   *
   * @return The previous SourceMark or empty Glib::RefPtr.
   *
   * @newin{2,2}
   */
  Glib::RefPtr<const SourceMark> prev() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The mark category.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_category() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};//end class SourceMark

}//end namespace gtksourceview


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates gtksourceview::SourceMark
   */
  Glib::RefPtr<gtksourceview::SourceMark> wrap(GtkSourceMark* object, bool take_copy = false);
}


#endif /* _GTKSOURCEVIEWMM_SOURCEMARK_H */

