
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <gtksourceviewmm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "sourcebuffer.h"
#include "sourcecompletion.h"
#include "sourcecompletionactivation.h"
#include "sourcecompletioncontext.h"
#include "sourcecompletioninfo.h"
#include "sourcecompletionitem.h"
#include "sourcecompletionproposal.h"
#include "sourcecompletionprovider.h"
#include "sourcecompletionwords.h"
#include "sourcegutter.h"
#include "sourcegutterrenderer.h"
#include "sourcegutterrendererpixbuf.h"
#include "sourcegutterrenderertext.h"
#include "sourcelanguage.h"
#include "sourcelanguagemanager.h"
#include "sourcemark.h"
#include "sourcemarkcategory.h"
#include "sourceprintcompositor.h"
#include "sourcestyle.h"
#include "sourcestylescheme.h"
#include "sourcestyleschememanager.h"
#include "sourceundomanager.h"
#include "sourceview.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType gtk_source_buffer_get_type(void);
GType gtk_source_completion_get_type(void);
GType gtk_source_completion_context_get_type(void);
GType gtk_source_completion_info_get_type(void);
GType gtk_source_completion_item_get_type(void);
GType gtk_source_completion_words_get_type(void);
GType gtk_source_gutter_get_type(void);
GType gtk_source_gutter_renderer_get_type(void);
GType gtk_source_gutter_renderer_pixbuf_get_type(void);
GType gtk_source_gutter_renderer_text_get_type(void);
GType gtk_source_language_get_type(void);
GType gtk_source_language_manager_get_type(void);
GType gtk_source_mark_get_type(void);
GType gtk_source_mark_category_get_type(void);
GType gtk_source_print_compositor_get_type(void);
GType gtk_source_style_get_type(void);
GType gtk_source_style_scheme_get_type(void);
GType gtk_source_style_scheme_manager_get_type(void);
GType gtk_source_view_get_type(void);

//Declarations of the *_error_quark() functions:

GQuark gtk_source_completion_error_quark(void);
} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Gsv {  class SourceBuffer_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourceCompletion_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourceCompletionContext_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourceCompletionInfo_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourceCompletionItem_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourceCompletionWords_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourceGutter_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourceGutterRenderer_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourceGutterRendererPixbuf_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourceGutterRendererText_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourceLanguage_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourceLanguageManager_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourceMark_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourceMarkCategory_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourcePrintCompositor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourceStyle_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourceStyleScheme_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourceStyleSchemeManager_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gsv {  class SourceView_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }

namespace Gsv { 

void wrap_init()
{
  // Register Error domains:
  Glib::Error::register_domain(gtk_source_completion_error_quark(), &Gsv::SourceCompletionError::throw_func);

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(gtk_source_buffer_get_type(), &Gsv::SourceBuffer_Class::wrap_new);
  Glib::wrap_register(gtk_source_completion_get_type(), &Gsv::SourceCompletion_Class::wrap_new);
  Glib::wrap_register(gtk_source_completion_context_get_type(), &Gsv::SourceCompletionContext_Class::wrap_new);
  Glib::wrap_register(gtk_source_completion_info_get_type(), &Gsv::SourceCompletionInfo_Class::wrap_new);
  Glib::wrap_register(gtk_source_completion_item_get_type(), &Gsv::SourceCompletionItem_Class::wrap_new);
  Glib::wrap_register(gtk_source_completion_words_get_type(), &Gsv::SourceCompletionWords_Class::wrap_new);
  Glib::wrap_register(gtk_source_gutter_get_type(), &Gsv::SourceGutter_Class::wrap_new);
  Glib::wrap_register(gtk_source_gutter_renderer_get_type(), &Gsv::SourceGutterRenderer_Class::wrap_new);
  Glib::wrap_register(gtk_source_gutter_renderer_pixbuf_get_type(), &Gsv::SourceGutterRendererPixbuf_Class::wrap_new);
  Glib::wrap_register(gtk_source_gutter_renderer_text_get_type(), &Gsv::SourceGutterRendererText_Class::wrap_new);
  Glib::wrap_register(gtk_source_language_get_type(), &Gsv::SourceLanguage_Class::wrap_new);
  Glib::wrap_register(gtk_source_language_manager_get_type(), &Gsv::SourceLanguageManager_Class::wrap_new);
  Glib::wrap_register(gtk_source_mark_get_type(), &Gsv::SourceMark_Class::wrap_new);
  Glib::wrap_register(gtk_source_mark_category_get_type(), &Gsv::SourceMarkCategory_Class::wrap_new);
  Glib::wrap_register(gtk_source_print_compositor_get_type(), &Gsv::SourcePrintCompositor_Class::wrap_new);
  Glib::wrap_register(gtk_source_style_get_type(), &Gsv::SourceStyle_Class::wrap_new);
  Glib::wrap_register(gtk_source_style_scheme_get_type(), &Gsv::SourceStyleScheme_Class::wrap_new);
  Glib::wrap_register(gtk_source_style_scheme_manager_get_type(), &Gsv::SourceStyleSchemeManager_Class::wrap_new);
  Glib::wrap_register(gtk_source_view_get_type(), &Gsv::SourceView_Class::wrap_new);

  // Register the gtkmm gtypes:
  Gsv::SourceBuffer::get_type();
  Gsv::SourceCompletion::get_type();
  Gsv::SourceCompletionContext::get_type();
  Gsv::SourceCompletionInfo::get_type();
  Gsv::SourceCompletionItem::get_type();
  Gsv::SourceCompletionWords::get_type();
  Gsv::SourceGutter::get_type();
  Gsv::SourceGutterRenderer::get_type();
  Gsv::SourceGutterRendererPixbuf::get_type();
  Gsv::SourceGutterRendererText::get_type();
  Gsv::SourceLanguage::get_type();
  Gsv::SourceLanguageManager::get_type();
  Gsv::SourceMark::get_type();
  Gsv::SourceMarkCategory::get_type();
  Gsv::SourcePrintCompositor::get_type();
  Gsv::SourceStyle::get_type();
  Gsv::SourceStyleScheme::get_type();
  Gsv::SourceStyleSchemeManager::get_type();
  Gsv::SourceView::get_type();

} // wrap_init()

} //Gsv


