/* Hipo - iPod management tool
 *
 * Pedro Villavicencio Garrido <pvillavi@gnome.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * (C) Copyright 2006-2007 Pedro Villavicencio Garrido <pvillavi@gnome.org>.
 */


using System;
using System.IO;
using System.Threading;
using IPod;
using Gtk;
using Gnome;
using Gnome.Vfs;
using Mono.Unix;

namespace Hipo
{
	public class PlaylistView
	{
		private Gtk.TreeStore store;
		private Gtk.ListStore plstore;
		
		public PlaylistView ()
		{
			store = new Gtk.TreeStore (typeof (Gdk.Pixbuf), typeof (string),
						   typeof (string));

			plstore = new Gtk.ListStore (typeof (string), typeof (string),
						     typeof (string), typeof (string),
						     typeof (long));     
		}

		public Gtk.TreeStore GetModel ()
		{
			return this.store;
		}

		public Gtk.ListStore GetModel (Playlist plist)
		{
			this.plstore.Clear ();
			
			foreach (Track track in plist.Tracks) {
				
				this.plstore.AppendValues (track.Artist, track.Album,
							   track.Title, track.Genre,
							   track.Id);
			}
			
			return plstore;
		}

		public void Clear ()
		{
			this.store.Clear ();
		}

		public void RefreshDevice (Device device)
		{
			TreeIter iter;

			if (!this.store.GetIterFirst (out iter))
				return;

			
			this.store.SetValue (iter, 2, String.Format ("({0})", device.TrackDatabase.Tracks.Count));
			this.store.SetValue (iter, 1, String.Format ("{0}", device.Name));
		}

		public void UpdateTrackNumber (TrackDatabase db, Gtk.TreeIter iter)
		{
			string playlistName = (string) this.store.GetValue (iter, 1);

			foreach (Playlist plist in db.Playlists)
			{
				if (plist.Name == playlistName) {
					this.store.SetValue (iter, 2, String.Format ("({0})", plist.Tracks.Count));
				}
			}	
		}

		public bool UpdatePlaylistName (TrackDatabase db, Gtk.TreeIter iter, string newName)
		{
			// Check if the name already exists
			if (db.LookupPlaylist (newName) != null)
				return false;
			
			string playlistName = (string) this.store.GetValue (iter, 1);
			
			foreach (Playlist plist in db.Playlists)
			{
				if (plist.Name == playlistName)
				{
					plist.Name = newName;
					this.store.SetValue (iter, 1, plist.Name);
					return true;
				}
			}
			
			return false;
		}
		
		public void UpdateTrackNumber (TrackDatabase db, Playlist playlist)
		{
			TreeIter iter;

			if (!this.store.GetIterFirst(out iter))
				return;
			
			do {
				string playlistName = (string) this.store.GetValue (iter, 1);

				if (playlistName == playlist.Name)
					this.store.SetValue (iter, 2, String.Format ("({0})", playlist.Tracks.Count));
				
			} while (this.store.IterNext (ref iter));

		}
			
		public void AddDeviceToStore (Device device)
		{
			Gtk.Application.Invoke (delegate {
					store.AppendValues (HipoMainWindow.GetDeviceIcon (device),
							    device.Name,
							    String.Format ("({0})", device.TrackDatabase.Tracks.Count));
				});
		}
		
		public void AddListToStore (Playlist list)
		{
			Gtk.Application.Invoke (delegate {

					TreeIter iter;

					if (!this.store.GetIterFirst (out iter))
						return;       

					store.AppendValues (iter,
							    Gnome.IconTheme.Default.LoadIcon ("stock_playlist", 16, 0),
							    list.Name,
							    String.Format ("({0})", list.Tracks.Count)
						);
				});
		}

		public void RemoveFromPlaylist (Gtk.TreeIter iter)
		{
			this.plstore.Remove (ref iter);
		}

		public void RemovePlaylist (Gtk.TreeIter iter)
		{
			this.store.Remove (ref iter);
		}

	}
}
