/* -*- tab-width: 4; c-basic-offset: 4 -*- */

using System;

public class MemRegion {
	public long Start; // real start
	public long End;   // pointer to start of next page
    public void Set(MemRegion r)
    {   this.Start = r.Start; this.End = r.End;   }
    public MemRegion() {}
    public MemRegion(MemRegion r)
    {   Set (r);    }
    public MemRegion(long s, long e)
    {   this.Start = s; this.End = e; }
	public bool Overlaps (MemRegion a) // NB. 0 size blocks don't overlap
	{   return !(this.End <= a.Start || a.End <= this.Start);   }
	public bool Adjacent (MemRegion a)
	{   return this.End == a.Start || this.Start == a.End;    }
	public void Collate (MemRegion a)
	{
		// assert Adjacent (?)
		this.Start = Math.Min (this.Start, a.Start);
		this.End = Math.Max (this.End, a.End);
	}
	public long Size { get { return this.End - this.Start; } }
	public bool IsEmpty()
	{	return this.Start == this.End;	}
	public bool IsEqualTo(MemRegion a)
	{	return this.Start == a.Start && this.End == a.End;	}
    public override string ToString()
    {
        return String.Format ("0x{0:x08}", Start) + " -> " +
            String.Format ("0x{0:x08}", End);
    }
}
