/* -*- mode: C; c-file-style: "gnu" -*- */
/*
 * Copyright (C) 2003 Richard Hult <richard@imendio.com>
 * Copyright (C) 2003 Johan Dahlin <johan@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __SONG_LIST_VIEW_H__
#define __SONG_LIST_VIEW_H__

#include <gtk/gtktreeview.h>
#include "song-list-model.h"

#define TYPE_SONG_LIST_VIEW            (song_list_view_get_type ())
#define SONG_LIST_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SONG_LIST_VIEW, SongListView))
#define SONG_LIST_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SONG_LIST_VIEW, SongListViewClass))
#define IS_SONG_LIST_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SONG_LIST_VIEW))
#define IS_SONG_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SONG_LIST_VIEW))
#define SONG_LIST_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SONG_LIST_VIEW, SongListViewClass))

typedef struct _SongListView      SongListView;
typedef struct _SongListViewClass SongListViewClass;

struct _SongListView
{
  GtkTreeView parent;
  
  GtkTreeViewColumn *play_column;
  GtkCellRenderer *play_cell;
};

struct _SongListViewClass
{
  GtkTreeViewClass parent_class;
};

GType           song_list_view_get_type       (void);
GtkWidget *     song_list_view_new            (void);
void            song_list_view_column_chooser (SongListView *view,
                                               GtkWindow    *parent);
void            song_list_view_setup_columns  (SongListView *view);

#endif /* __SONG_LIST_VIEW_H__ */
