import gtk

from kiwi.ui.widgets.combobox import ComboBoxEntry
from kiwi.ui.widgets.combobox import ComboBox

window = gtk.Window()
window.connect('delete-event', gtk.main_quit)
window.connect('key-press-event', lambda w, e: e.keyval == gtk.keysyms.Escape and gtk.main_quit())

def create_combo():
    def visible_func(store, iter):
        row = store[iter]
        if not row[0]:
            return False

        if 'a' in row[0]:
            return True
        return False

    model = gtk.ObjectListStore(str)
    filter = model.filter_new()
    filter.set_visible_func(visible_func)

    combo = gtk.ComboBox()
    renderer = gtk.CellRendererText()
    combo.pack_start(renderer)
    combo.add_attribute(renderer, 'text', 0)
    combo.set_model(filter)

    for a in ('foo', 'bar', 'baz'):
        model.append([a])

    return combo

def set_style_property(name, gobj, attribute, value):
    import gobject
    type_name = gobject.type_name(gobj)
    gtk.rc_parse_string('''style "%(name)s" {
        %(type_name)s::%(attribute)s = %(value)s
    }
    class "%(type_name)s" style "%(name)s"
    ''' % dict(name=name,
               type_name=type_name,
               attribute=attribute.replace('-', '_'),
               value=value))

def create_kiwi_combo():
    set_style_property('combo-list-style',
                       gtk.ComboBox, 'appears-as-list', 1)

    cbe = ComboBoxEntry()
    cbe.prefill(('Johan Dahlgren',
                 'Johan Dahlen',
                 'Johan Dahlin',
                 'Johan Dahl',
                 'Johan Dingle',
                 'Johan Doe'))
    return cbe

combo = create_kiwi_combo()

window.add(combo)

window.show_all()
gtk.main()
