/* This file is part of libccc
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2007  Sven Herzberg
 *
 * This work is provided "as is"; redistribution and modification
 * in whole or in part, in any medium, physical or electronic is
 * permitted without restriction.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * In no event shall the authors or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 */

#include "g-type-private-demo.h"

struct _GPrivateDemoPrivate {
	gchar sliff;
};

G_DEFINE_TYPE (GPrivateDemo, g_private_demo, G_TYPE_OBJECT);

static void
g_private_demo_init (GPrivateDemo* self)
{
	self->_private = G_TYPE_INSTANCE_GET_PRIVATE (self, G_TYPE_PRIVATE_DEMO, GPrivateDemoPrivate);
}

static void
g_private_demo_class_init (GPrivateDemoClass* self_class)
{
	g_type_class_add_private (self_class, sizeof (GPrivateDemoPrivate));
}

int
main (int   argc,
      char**argv)
{
	GPrivateDemoPrivate* priv;
	GPrivateDemo* demo;
	GTimer* timer;
	gint64 n_tests = G_GINT64_CONSTANT(100000000);
	gint64 i;

	/* init */
	g_type_init ();

	/* prepare */
	demo = g_object_new (G_TYPE_PRIVATE_DEMO, NULL);
	timer = g_timer_new ();

	/* check 1 */
	g_timer_start (timer);
	for (i = 0; i < n_tests; i++) {
		priv = demo->_private;
	}
	g_timer_stop (timer);
	g_print ("%" G_GINT64_FORMAT " Pointer dereferences: %f\n", n_tests, g_timer_elapsed (timer, NULL));

	/* check 2 */
	g_timer_start (timer);
	for (i = 0; i < n_tests; i++) {
		priv = G_TYPE_INSTANCE_GET_PRIVATE (demo, G_TYPE_PRIVATE_DEMO, GPrivateDemoPrivate);
	}
	g_timer_stop (timer);
	g_print ("%" G_GINT64_FORMAT " Function calls:       %f\n", n_tests, g_timer_elapsed (timer, NULL));

	/* cleanup */
	g_timer_destroy (timer);
	g_object_unref (demo);

	return 0;
}

