


#include <config.h>
#include <glib-object.h>
#include "champlain-enum-types.h"


/* enumerations from "champlain-defines.h" */
static const GEnumValue _champlain_state_values[] = {
  { CHAMPLAIN_STATE_NONE, "CHAMPLAIN_STATE_NONE", "none" },
  { CHAMPLAIN_STATE_INIT, "CHAMPLAIN_STATE_INIT", "init" },
  { CHAMPLAIN_STATE_LOADING, "CHAMPLAIN_STATE_LOADING", "loading" },
  { CHAMPLAIN_STATE_VALIDATING_CACHE, "CHAMPLAIN_STATE_VALIDATING_CACHE", "validating-cache" },
  { CHAMPLAIN_STATE_DONE, "CHAMPLAIN_STATE_DONE", "done" },
  { 0, NULL, NULL }
};

GType
champlain_state_get_type (void)
{
  static GType type = 0;

  if (!type)
    type = g_enum_register_static ("ChamplainState", _champlain_state_values);

  return type;
}

static const GEnumValue _champlain_unit_values[] = {
  { CHAMPLAIN_UNIT_KM, "CHAMPLAIN_UNIT_KM", "km" },
  { CHAMPLAIN_UNIT_MILES, "CHAMPLAIN_UNIT_MILES", "miles" },
  { 0, NULL, NULL }
};

GType
champlain_unit_get_type (void)
{
  static GType type = 0;

  if (!type)
    type = g_enum_register_static ("ChamplainUnit", _champlain_unit_values);

  return type;
}


/* enumerations from "champlain-view.h" */
static const GEnumValue _champlain_scroll_mode_values[] = {
  { CHAMPLAIN_SCROLL_MODE_PUSH, "CHAMPLAIN_SCROLL_MODE_PUSH", "push" },
  { CHAMPLAIN_SCROLL_MODE_KINETIC, "CHAMPLAIN_SCROLL_MODE_KINETIC", "kinetic" },
  { 0, NULL, NULL }
};

GType
champlain_scroll_mode_get_type (void)
{
  static GType type = 0;

  if (!type)
    type = g_enum_register_static ("ChamplainScrollMode", _champlain_scroll_mode_values);

  return type;
}


/* enumerations from "champlain-selection-layer.h" */
static const GEnumValue _champlain_selection_mode_values[] = {
  { CHAMPLAIN_SELECTION_NONE, "CHAMPLAIN_SELECTION_NONE", "none" },
  { CHAMPLAIN_SELECTION_SINGLE, "CHAMPLAIN_SELECTION_SINGLE", "single" },
  { CHAMPLAIN_SELECTION_MULTIPLE, "CHAMPLAIN_SELECTION_MULTIPLE", "multiple" },
  { 0, NULL, NULL }
};

GType
champlain_selection_mode_get_type (void)
{
  static GType type = 0;

  if (!type)
    type = g_enum_register_static ("ChamplainSelectionMode", _champlain_selection_mode_values);

  return type;
}


/* enumerations from "champlain-map-source.h" */
static const GEnumValue _champlain_map_projection_values[] = {
  { CHAMPLAIN_MAP_PROJECTION_MERCATOR, "CHAMPLAIN_MAP_PROJECTION_MERCATOR", "mercator" },
  { 0, NULL, NULL }
};

GType
champlain_map_projection_get_type (void)
{
  static GType type = 0;

  if (!type)
    type = g_enum_register_static ("ChamplainMapProjection", _champlain_map_projection_values);

  return type;
}




