// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDA_UIMM_DATAENTRY_H
#define _LIBGDA_UIMM_DATAENTRY_H


#include <glibmm.h>

/* libgda-uimm - a C++ wrapper for libgda-ui
 *
 * Copyright (c) 2010 libgda-uimm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgda-ui/gdaui-data-entry.h>
#include <glibmm/interface.h>
#include <libgdamm/datamodel.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdauiDataEntry GdauiDataEntry;
typedef struct _GdauiDataEntryClass GdauiDataEntryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace GdaUI
{ class DataEntry_Class; } // namespace GdaUI

} // namespace Gnome
namespace Gnome
{

// Gnome::Gda class forward declarations.
namespace Gda
{

class DataHandler;

}

namespace GdaUI
{

/** DataEntry - Data entry widget.
 * The DataEntry is an interface for widgets (simple or complex) which lets
 * the user view and/or modify a GValue.
 *
* This interface is implemented by widgets which feature data editing (usually
* composed of an editing area and a button to have some more control on the
* value being edited). The interface allows to control how the widget works
* and to query the value and the attributes of the data held by the widget.
 *
* The widget can store the original value (to be able to tell if the value has
* been changed by the user) and a default value (which will be returned if the
* user explicitly forces the widget to be set to the default value). Control
* methods allow to set the type of value to be edited (the requested type must
* be compatible with what the widget can handle), set the value (which
* replaces the currently edited value), set the value and the original value
* (the value passed as argument is set and is also considered to be the
* original value).
 *
* DataEntry widgets are normally created using the create_data_entry() method.
 */


class DataEntry :
  public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataEntry CppObjectType;
  typedef DataEntry_Class CppClassType;
  typedef GdauiDataEntry BaseObjectType;
  typedef GdauiDataEntryIface BaseClassType;

private:
  friend class DataEntry_Class;
  static CppClassType dataentry_class_;

  // noncopyable
  DataEntry(const DataEntry&);
  DataEntry& operator=(const DataEntry&);

protected:
  DataEntry(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit DataEntry(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit DataEntry(GdauiDataEntry* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataEntry();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdauiDataEntry*       gobj()       { return reinterpret_cast<GdauiDataEntry*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GdauiDataEntry* gobj() const { return reinterpret_cast<GdauiDataEntry*>(gobject_); }

private:


public:
  
  /** Creates a new Gdaui::DataEntry widget, taking into account the requested entry name
   * if @a plugin_name is not <tt>0</tt> (if no entry of that name is found, then the default data
   * entry widget will be created).
   * 
   *  @a plugin_name format is interpreted as two parts: <plugin name>:<plugin options>, and
   * if the plugins has no option, then the ":<plugin options>" part may be omitted.
   * @param type A Type.
   * @param plugin_name The name of an entry plugin, or <tt>0</tt>.
   * @return A new Gdaui::DataEntry widget, _NEVER_ <tt>0</tt>.
   */
  static Glib::RefPtr<DataEntry> create_data_entry(GType type, const Glib::ustring& plugin_name = Glib::ustring());

  
  /** Sets the type of value the GdauiDataEntry will handle. The type must be compatible with what
   * the widget can handle.
   * 
   * @newin{4,2}
   */
  void set_value_type(GType type);
  
  /** Fetch the type of data the GdauiDataEntry handles
   * @return The GType type
   * 
   * @newin{4,2}.
   */
  GType get_value_type() const;
  
  /** Push a value into the Gdaui::DataEntry. The value parameter must either be:
   * <itemizedlist>
   * <listitem><para>of type GDA_TYPE_<tt>0</tt> (may be created using gda_value_new_null()) to 
   * represent a <tt>0</tt> value (SQL <tt>0</tt>), or</para></listitem>
   * <listitem><para>of type specified using set_value_type(), or</para></listitem>
   * <listitem><para><tt>0</tt> to represent an undetermined value (usually an error)</para></listitem>
   * </itemizedlist>
   * 
   * @newin{4,2}
   * @param value A Value, or <tt>0</tt>.
   */
  void set_value(const Glib::ValueBase& value);

  /** Push a value into the DataEntry. The value parameter must be of the type
   * specified using set_value_type().
   *
   * @param value The value to set.
   *
   * @newin{4,2}
   */
  template <class DataType>
  void set_value(const DataType& value);

  /** Fetch the value held in the DataEntry widget. If the value is set to
   * NULL, the returned value is of type GDA_TYPE_NULL. If the value is set to
   * default, then the returned value is of type GDA_TYPE_NULL or is the
   * default value if it has been provided to the widget (and is of the same
   * type as the one provided by the data entry).
   *
   * @param value A place in which to store the value.  The value must be
   * uninitialized.
   *
   * @newin{4,2}
   */
  void get_value(Glib::ValueBase& value) const;
  

  /** Fetch the value held in the DataEntry widget. If the value is set to
   * NULL, the returned value is of type GDA_TYPE_NULL. If the value is set to
   * default, then the returned value is of type GDA_TYPE_NULL or is the
   * default value if it has been provided to the widget (and is of the same
   * type as the one provided by the data entry).
   *
   * @param value A place in which to store the value.  The value must be
   * uninitialized.
   *
   * @newin{4,2}
   */
  template<class DataType>
  void get_value(DataType& value) const;

  
  /** Tests the validity of @a de's contents. The validity is a determined from:
   * <itemizedlist>
   * <listitem><para>the @a de widget itself if it is capable of doing it (depending on the implementation)</para></listitem>
   * <listitem><para>the results of the "contents-valid" signal which can be connected from </para></listitem>
   * </itemizedlist>
   * @return <tt>true</tt> if @a de's contents is valid
   * 
   * @newin{4,2}.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool content_is_valid();
#else
  bool content_is_valid(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Fetch the original value held in the GdauiDataEntry widget.
   *
   * @param value A place in which to store the value.  The value must be
   * uninitialized and should not be modified.
   *
   * @newin{4,2}
   */
  void get_original_value(Glib::ValueBase& value) const;
  

  /** Fetch the original value held in the GdauiDataEntry widget.
   *
   * @param value A place in which to store the value.  The value must be
   * uninitialized and should not be modified.
   *
   * @newin{4,2}
   */
  template<class DataType>
  void get_original_value(DataType& value) const;

  
  /** Tells that the current value in @a de is to be considered as the original value
   * 
   * @newin{4,2}
   */
  void reset();
  
  /** Sets the default value for the GdauiDataEntry which gets displayed when the
   * user forces the default value. If it is not set then it is set to type GDA_TYPE_<tt>0</tt>.
   * The value parameter must either be:
   * <itemizedlist>
   * <listitem><para><tt>0</tt> or of type GDA_TYPE_<tt>0</tt>, or</para></listitem>
   * <listitem><para>of type specified using set_value_type().</para></listitem>
   * </itemizedlist>
   * 
   * @newin{4,2}
   * @param value A Value, or <tt>0</tt>.
   */
  void set_value_default(const Glib::ValueBase& value);

  /** Sets the default value for the DataEntry which gets displayed when the
   * user forces the default value. If it is not set then it is set to type
   * GDA_TYPE_NULL.  The value parameter must be of the type specified using
   * set_value_type().
   *
   * @param value The value to set.
   *
   * @newin{4,2}
   */
  template <class DataType>
  void set_value_default(const DataType& value);

  
  /** Sets the parameters of the GdauiDataEntry. Only the attributes corresponding to the
   * mask are set, the other ones are ignored.
   * 
   * @newin{4,2}
   * @param attrs The attributes to set (OR'ed between them).
   * @param mask The mask corresponding to the considered attributes.
   */
  void set_attributes(Gnome::Gda::ValueAttribute attrs, Gnome::Gda::ValueAttribute mask);
  
  /** Retrieves the parameters of the GdauiDataEntry widget.
   * @return The OR'ed bits corresponding to the attributes.
   * 
   * @newin{4,2}.
   */
  Gnome::Gda::ValueAttribute get_attributes() const;
  
  /** Fetch the GdaDataHandler the GdauiDataEntry is using
   * @return The GdaDataHandler object
   * 
   * @newin{4,2}.
   */
  Glib::RefPtr<Gnome::Gda::DataHandler> get_handler();
  
  /** Fetch the GdaDataHandler the GdauiDataEntry is using
   * @return The GdaDataHandler object
   * 
   * @newin{4,2}.
   */
  Glib::RefPtr<const Gnome::Gda::DataHandler> get_handler() const;
  
  /** Used for the layout of the widget in containers.
   * @return <tt>true</tt> if the widget should expand
   * 
   * @newin{4,2}.
   */
  bool expand_in_layout() const;
  
  /** Set if @a de can be modified or not by the user
   * 
   * @newin{4,2}
   * @param editable Set to <tt>true</tt> to have an editable data entry.
   */
  void set_editable(bool editable);
  
  /** Tells if @a de can be edited by the user
   * @return <tt>true</tt> if @a de is editable
   * 
   * @newin{4,2}.
   */
  bool get_editable() const;
  
  /** Makes @a de grab the focus for the window it's in
   * 
   * @newin{4,2}
   */
  void grab_focus();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%contents_activated()</tt>
   */

  Glib::SignalProxy0< void > signal_contents_activated();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%contents_modified()</tt>
   */

  Glib::SignalProxy0< void > signal_contents_modified();


  //TODO: The class declaration seems to suggest that this signal throws a
  //GError.
  //_WRAP_SIGNAL(void contents_valid(), "contents-valid", errthrow)

  
  /**
   * @par Prototype:
   * <tt>void on_my_%status_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_status_changed();


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_value_type_vfunc(GType type);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual GType get_value_type_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_value_vfunc(const Glib::ValueBase& value);
#endif //GLIBMM_VFUNCS_ENABLED


#ifdef GLIBMM_VFUNCS_ENABLED
  void get_value_vfunc(Glib::ValueBase& value) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_value_orig_vfunc(const Glib::ValueBase& value);
#endif //GLIBMM_VFUNCS_ENABLED


#ifdef GLIBMM_VFUNCS_ENABLED
  void get_value_orig_vfunc(Glib::ValueBase& value) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_value_default_vfunc(const Glib::ValueBase& value);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_attributes_vfunc(Gnome::Gda::ValueAttribute attrs, Gnome::Gda::ValueAttribute mask);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Gnome::Gda::ValueAttribute get_attributes_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::RefPtr<Gnome::Gda::DataHandler> get_handler_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool expand_in_layout_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_editable_vfunc(bool editable);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void grab_focus_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED


protected:

  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_contents_activated();
  virtual void on_contents_modified();
  virtual void on_status_changed();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

/***************************** DataEntry *****************************/

#ifndef DOXYGEN_SHOULD_SKIP_THIS

template <class DataType>
void DataEntry::set_value(const DataType& value)
{
  typedef Glib::Value<DataType> ValueType;

  ValueType temp;
  temp.init(ValueType::value_type());
  temp.set(value);
  this->set_value(temp);
}

template<class DataType>
void DataEntry::get_value(DataType& value) const
{
  Glib::Value<DataType> temp;
  this->get_value(temp);
  value = temp.get();
}

template<class DataType>
void DataEntry::get_original_value(DataType& value) const
{
  Glib::Value<DataType> temp;
  this->get_original_value(temp);
  value = temp.get();
}

template <class DataType>
void DataEntry::set_value_default(const DataType& value)
{
  typedef Glib::Value<DataType> ValueType;

  ValueType temp;
  temp.init(ValueType::value_type());
  temp.set(value);
  this->set_value_default(temp);
}

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace GdaUI

} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::GdaUI::DataEntry
   */
  Glib::RefPtr<Gnome::GdaUI::DataEntry> wrap(GdauiDataEntry* object, bool take_copy = false);

} // namespace Glib


#endif /* _LIBGDA_UIMM_DATAENTRY_H */

