// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDA_UIMM_BASICFORM_H
#define _LIBGDA_UIMM_BASICFORM_H


#include <glibmm.h>

/* libgda-uimm - a C++ wrapper for libgda-ui
 *
 * Copyright (c) 2010 libgda-uimm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/box.h>


// Gtk class forward declarations.
#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdauiBasicForm GdauiBasicForm;
typedef struct _GdauiBasicFormClass GdauiBasicFormClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace GdaUI
{ class BasicForm_Class; } // namespace GdaUI

} // namespace Gnome
namespace Gtk
{

class Menu;
class SizeGroup;
class Widget;
class Window;

}

namespace Gnome
{

// Gnome::Gda class forward declartions.
namespace Gda
{

class Holder;
class Set;

}

namespace GdaUI
{

/** @addtogroup libgda_uimmEnums libgda_uimm Enums and Flags */

/**
 * @ingroup libgda_uimmEnums
 */
enum BasicFormPart
{
  BASIC_FORM_LABELS,
  BASIC_FORM_ENTRIES
};

} // namespace GdaUI

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::GdaUI::BasicFormPart> : public Glib::Value_Enum<Gnome::GdaUI::BasicFormPart>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace GdaUI
{


/** BasicForm - Form widget mapping the values contained in a Gnome::Gda::Set.
 * The BasicForm widget is a form containing an entry for each
 * Gnome::Gda::Holder object contained in a Gnome::Gda::Set (specified when
 * the form is created). A typical usage is when the user is requested to
 * enter a value which will be used in a statement (without any error checking
 * for clarity):
 *
 * - TODO: Translate and include example from C API docs.
 *
 * The default layout within a BasicForm  is a vertical column: all the data
 * entry widgets are aligned in a single column. This behaviour can be
 * changed using the set_layout_from_file() method or setting the xml-layout
 * property.
 *
 * <H3>XML Layout Definitions</H3>
 *
 * The BasicForm class parses textual descriptions of XML layout which which
 * can be described by the following DTD.
 *
 * @code
 * <!ELEMENT gdaui_layouts (gdaui_form | gdaui_grid)>
 * <!ELEMENT gdaui_form (gdaui_section | gdaui_column | gdaui_notebook)*>
 * <!ATTLIST gdaui_form
 *         name CDATA #REQUIRED
 *         container (columns|rows|hpaned|vpaned) #IMPLIED>
 * <!ELEMENT gdaui_section (gdaui_section | gdaui_column | gdaui_notebook)*>
 * <!ATTLIST gdaui_section
 *         title CDATA #IMPLIED >
 * <!ELEMENT gdaui_notebook (gdaui_section | gdaui_column | gdaui_notebook)*>
 * <!ELEMENT gdaui_column (gdaui_entry | gdaui_placeholder)*>
 * <!ELEMENT gdaui_entry EMPTY>
 * <!ATTLIST gdaui_entry
 *         name CDATA #REQUIRED
 *         editable (true|false) #IMPLIED
 *         label CDATA #IMPLIED
 *         plugin CDATA #IMPLIED>
 * <!ELEMENT gdaui_placeholder EMPTY>
 * <!ATTLIST gdaui_placeholder
 *         id CDATA #REQUIRED
 *         label CDATA #IMPLIED>
 * @endcode
 *
 * <H3>Example 1. A BasicForm layout example</H3>
 *
 * @code
 * <?xml version="1.0" encoding="UTF-8"?>
 * <gdaui_layouts>
 *   <gdaui_form name="customers" container="hpaned">
 *     <gdaui_section title="Summary">
 *       <gdaui_column>
 *         <gdaui_entry name="id" editable="no"/>
 *         <gdaui_entry name="name"/>
 *         <gdaui_entry name="comments" plugin="text"/>
 *         <gdaui_entry name="total_orders" label="Total ordered" plugin="number:NB_DECIMALS=2;CURRENCY=€"/>
 *       </gdaui_column>
 *     </gdaui_section>
 *     <gdaui_section title="Photo">
 *       <gdaui_column>
 *         <gdaui_entry name="photo" plugin="picture"/>
 *       </gdaui_column>
 *     </gdaui_section>
 *   </gdaui_form>
 * </gdaui_layouts>
 * @endcode
 */

class BasicForm :
  public Gtk::Box
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef BasicForm CppObjectType;
  typedef BasicForm_Class CppClassType;
  typedef GdauiBasicForm BaseObjectType;
  typedef GdauiBasicFormClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~BasicForm();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class BasicForm_Class;
  static CppClassType basicform_class_;

  // noncopyable
  BasicForm(const BasicForm&);
  BasicForm& operator=(const BasicForm&);

protected:
  explicit BasicForm(const Glib::ConstructParams& construct_params);
  explicit BasicForm(GdauiBasicForm* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GdauiBasicForm*       gobj()       { return reinterpret_cast<GdauiBasicForm*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GdauiBasicForm* gobj() const { return reinterpret_cast<GdauiBasicForm*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_activated();
  virtual void on_holder_changed(const Glib::RefPtr<Gnome::Gda::Holder>& holder, bool is_user_modified);
  virtual void on_layout_changed();


private:


public:
  
  /** Creates a new Gdaui::BasicForm widget using all the Gda::Holder objects provided in @a data_set.
   * 
   * The global layout is rendered using a table (a Gtk::Table), and an entry is created for each
   * node of @a data_set.
   * 
   * @newin{4,2}
   * @param data_set A Gda::Set structure.
   * @return The new widget.
   */

    explicit BasicForm(const Glib::RefPtr<Gnome::Gda::Set>& data_set);


  /** Creates a new Gdaui::BasicForm widget in the same way as new()
   * and puts it into a Gtk::Dialog widget. The returned dialog has the "Ok" and "Cancel" buttons
   * which respectively return GTK_RESPONSE_ACCEPT and GTK_RESPONSE_REJECT.
   * 
   * The Gdaui::BasicForm widget is attached to the dialog using the user property
   * "form".
   * 
   * @newin{4,2}
   * @param data_set A Gda::Set object.
   * @param parent The parent window for the new dialog, or <tt>0</tt>.
   * @param title The title of the dialog window, or <tt>0</tt>.
   * @param header A helper text displayed at the top of the dialog, or <tt>0</tt>.
   * @return The new Gtk::Dialog widget.
   */

    explicit BasicForm(const Glib::RefPtr<Gnome::Gda::Set>& data_set, Gtk::Window* parent, const Glib::ustring& title, const Glib::ustring& header);


public:
  
  /** Get a pointer to the Gda::Set object which
   * is modified by @a form
   * 
   * @newin{4,2}
   * @return A pointer to the Gda::Set.
   */
  Glib::RefPtr<Gnome::Gda::Set> get_data_set();
  
  /** Get a pointer to the Gda::Set object which
   * is modified by @a form
   * 
   * @newin{4,2}
   * @return A pointer to the Gda::Set.
   */
  Glib::RefPtr<const Gnome::Gda::Set> get_data_set() const;
  
  /** Tells if the form can be used as-is (if all the parameters do have some valid values)
   * 
   * @newin{4,2}
   * @return <tt>true</tt> if the form is valid.
   */
  bool is_valid() const;
  
  /** Tells if the form has had at least on entry changed since @a form was created or
   * set_as_reference() has been called.
   * 
   * @newin{4,2}
   * @return <tt>true</tt> if one entry has changed at least.
   */
  bool has_changed() const;
  
  /** Resets all the entries in the form to their
   * original values
   * 
   * @newin{4,2}
   */
  void reset();
  
  /** Tells @a form that the current values in the different entries are
   * to be considered as the original values for all the entries; the immediate
   * consequence is that any sub-sequent call to has_changed()
   * will return <tt>false</tt> (of course until any entry is changed).
   * 
   * @newin{4,2}
   */
  void set_as_reference();
  
  /** Shows or hides the Gdaui::DataEntry in @a form which corresponds to the
   *  @param parameter
   * 
   * @newin{4,2}
   * @param param A Gda::Holder object.
   * @param show Set to <tt>true</tt> to show the data entry, and to <tt>false</tt> to hide it.
   */
  void entry_set_visible(const Glib::RefPtr<Gnome::Gda::Holder>& holder, bool show);
  
  /** Makes the data entry corresponding to @param grab the focus for the window it's in
   * 
   * @newin{4,2}
   * @param param A Gda::Holder object.
   */
  void entry_grab_focus(const Glib::RefPtr<Gnome::Gda::Holder>& holder);
  
  /** Sets the Gdaui::DataEntry in @a form which corresponds to the
   *  @a holder parameter editable or not. If @a holder is <tt>0</tt>, then all the parameters
   * are concerned.
   * 
   * @newin{4,2}
   * @param holder A Gda::Holder object; or <tt>0</tt>.
   * @param editable <tt>true</tt> if corresponding data entry must be editable.
   */
  void entry_set_editable(const Glib::RefPtr<Gnome::Gda::Holder>& holder, bool editable);
  
  /** For each entry in the form, sets it to a default value if it is possible to do so.
   * 
   * @newin{4,2}
   */
  void set_entries_to_default();
  
  /** Get the Gdaui::DataEntry in @a form which corresponds to the param parameter.
   * 
   * @newin{4,2}
   * @param param A Gda::Holder object.
   * @return The requested widget, or <tt>0</tt> if not found.
   */
  Gtk::Widget* get_entry_widget(const Glib::RefPtr<Gnome::Gda::Holder>& holder);
  
  /** Get the Gdaui::DataEntry in @a form which corresponds to the param parameter.
   * 
   * @newin{4,2}
   * @param param A Gda::Holder object.
   * @return The requested widget, or <tt>0</tt> if not found.
   */
  const Gtk::Widget* get_entry_widget(const Glib::RefPtr<Gnome::Gda::Holder>& holder) const;
  
  /** Get the label in @a form which corresponds to the param parameter.
   * 
   * @newin{4,2}
   * @param param A Gda::Holder object.
   * @return The requested widget, or <tt>0</tt> if not found.
   */
  Gtk::Widget* get_label_widget(const Glib::RefPtr<Gnome::Gda::Holder>& holder);
  
  /** Get the label in @a form which corresponds to the param parameter.
   * 
   * @newin{4,2}
   * @param param A Gda::Holder object.
   * @return The requested widget, or <tt>0</tt> if not found.
   */
  const Gtk::Widget* get_label_widget(const Glib::RefPtr<Gnome::Gda::Holder>& holder) const;
  
  /** Sets a form layout according an XML description contained in @a file_name, for the form identified
   * by the @a form_name name (as an XML layout file can contain the descriptions of several forms and grids).
   * 
   * @newin{4,2}
   * @param file_name XML file name to use.
   * @param form_name The name of the form to use, in @a file_name.
   */
  void set_layout_from_file(const std::string& file_name, const Glib::ustring& form_name);
  
  /** Retreives a pointer to a place holder widget. This feature is only available if a specific
   * layout has been defined for @a form using set_layout_from_file().
   * 
   * @newin{4,2}
   * @param placeholder_id The name of the requested place holder.
   * @return A pointer to the requested place holder, or <tt>0</tt> if not found.
   */
  Gtk::Widget* get_place_holder(const Glib::ustring& placeholder_id);
  
  /** Retreives a pointer to a place holder widget. This feature is only available if a specific
   * layout has been defined for @a form using set_layout_from_file().
   * 
   * @newin{4,2}
   * @param placeholder_id The name of the requested place holder.
   * @return A pointer to the requested place holder, or <tt>0</tt> if not found.
   */
  const Gtk::Widget* get_place_holder(const Glib::ustring& placeholder_id) const;

  
  /** Add @a form's widgets specified by @a part to @a size_group
   * (the widgets can then be removed using remove_from_size_group()).
   * 
   * @newin{4,2}
   * @param size_group A Gtk::SizeGroup object.
   * @param part Specifies which widgets in @a form are concerned.
   */
  void add_to_size_group(const Glib::RefPtr<Gtk::SizeGroup>& size_group, BasicFormPart part =  BASIC_FORM_LABELS);
  
  /** Removes @a form's widgets specified by @a part from @a size_group
   * (the widgets must have been added using add_to_size_group()).
   * 
   * @newin{4,2}
   * @param size_group A Gtk::SizeGroup object.
   * @param part Specifies which widgets in @a form are concerned.
   */
  void remove_from_size_group(const Glib::RefPtr<Gtk::SizeGroup>& size_group, BasicFormPart part =  BASIC_FORM_LABELS);

  
  /**
   * @par Prototype:
   * <tt>void on_my_%activated()</tt>
   */

  Glib::SignalProxy0< void > signal_activated();


  /**
   * @par Prototype:
   * <tt>void on_my_%holder_changed(const Glib::RefPtr<Gnome::Gda::Holder>& holder, bool is_user_modified)</tt>
   */

  Glib::SignalProxy2< void,const Glib::RefPtr<Gnome::Gda::Holder>&,bool > signal_holder_changed();


  /**
   * @par Prototype:
   * <tt>void on_my_%layout_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_layout_changed();


  /**
   * @par Prototype:
   * <tt>void on_my_%populate_popup(Gtk::Menu* menu)</tt>
   */

  Glib::SignalProxy1< void,Gtk::Menu* > signal_populate_popup();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_can_expand_v() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_entries_auto_default() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_entries_auto_default() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_headers_sensitive() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_headers_sensitive() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  //TODO: _WRAP_PROPERTY("paramlist", gpointer)
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_actions() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_actions() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  //TODO: _WRAP_PROPERTY("xml-layout", gpointer)


};

} // namespace GdaUI

} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::GdaUI::BasicForm
   */
  Gnome::GdaUI::BasicForm* wrap(GdauiBasicForm* object, bool take_copy = false);
} //namespace Glib


#endif /* _LIBGDA_UIMM_BASICFORM_H */

