
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <libgda-uimm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "basicform.h"
#include "cloud.h"
#include "combo.h"
#include "dataentry.h"
#include "datafilter.h"
#include "dataproxy.h"
#include "dataproxyinfo.h"
#include "dataselector.h"
#include "datastore.h"
#include "form.h"
#include "grid.h"
#include "login.h"
#include "providerselector.h"
#include "rawform.h"
#include "rawgrid.h"
#include "rteditor.h"
#include "serveroperation.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType gdaui_basic_form_get_type(void);
GType gdaui_cloud_get_type(void);
GType gdaui_combo_get_type(void);
GType gdaui_data_filter_get_type(void);
GType gdaui_data_proxy_info_get_type(void);
GType gdaui_data_store_get_type(void);
GType gdaui_form_get_type(void);
GType gdaui_grid_get_type(void);
GType gdaui_login_get_type(void);
GType gdaui_provider_selector_get_type(void);
GType gdaui_raw_form_get_type(void);
GType gdaui_raw_grid_get_type(void);
GType gdaui_rt_editor_get_type(void);
GType gdaui_server_operation_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Gnome { namespace GdaUI {  class BasicForm_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace GdaUI {  class Cloud_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace GdaUI {  class Combo_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace GdaUI {  class DataFilter_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace GdaUI {  class DataProxyInfo_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace GdaUI {  class DataStore_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace GdaUI {  class Form_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace GdaUI {  class Grid_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace GdaUI {  class Login_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace GdaUI {  class ProviderSelector_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace GdaUI {  class RawForm_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace GdaUI {  class RawGrid_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace GdaUI {  class RtEditor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace GdaUI {  class ServerOperation_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }

namespace Gnome { namespace GdaUI { 

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(gdaui_basic_form_get_type(), &Gnome::GdaUI::BasicForm_Class::wrap_new);
  Glib::wrap_register(gdaui_cloud_get_type(), &Gnome::GdaUI::Cloud_Class::wrap_new);
  Glib::wrap_register(gdaui_combo_get_type(), &Gnome::GdaUI::Combo_Class::wrap_new);
  Glib::wrap_register(gdaui_data_filter_get_type(), &Gnome::GdaUI::DataFilter_Class::wrap_new);
  Glib::wrap_register(gdaui_data_proxy_info_get_type(), &Gnome::GdaUI::DataProxyInfo_Class::wrap_new);
  Glib::wrap_register(gdaui_data_store_get_type(), &Gnome::GdaUI::DataStore_Class::wrap_new);
  Glib::wrap_register(gdaui_form_get_type(), &Gnome::GdaUI::Form_Class::wrap_new);
  Glib::wrap_register(gdaui_grid_get_type(), &Gnome::GdaUI::Grid_Class::wrap_new);
  Glib::wrap_register(gdaui_login_get_type(), &Gnome::GdaUI::Login_Class::wrap_new);
  Glib::wrap_register(gdaui_provider_selector_get_type(), &Gnome::GdaUI::ProviderSelector_Class::wrap_new);
  Glib::wrap_register(gdaui_raw_form_get_type(), &Gnome::GdaUI::RawForm_Class::wrap_new);
  Glib::wrap_register(gdaui_raw_grid_get_type(), &Gnome::GdaUI::RawGrid_Class::wrap_new);
  Glib::wrap_register(gdaui_rt_editor_get_type(), &Gnome::GdaUI::RtEditor_Class::wrap_new);
  Glib::wrap_register(gdaui_server_operation_get_type(), &Gnome::GdaUI::ServerOperation_Class::wrap_new);

  // Register the gtkmm gtypes:
  Gnome::GdaUI::BasicForm::get_type();
  Gnome::GdaUI::Cloud::get_type();
  Gnome::GdaUI::Combo::get_type();
  Gnome::GdaUI::DataFilter::get_type();
  Gnome::GdaUI::DataProxyInfo::get_type();
  Gnome::GdaUI::DataStore::get_type();
  Gnome::GdaUI::Form::get_type();
  Gnome::GdaUI::Grid::get_type();
  Gnome::GdaUI::Login::get_type();
  Gnome::GdaUI::ProviderSelector::get_type();
  Gnome::GdaUI::RawForm::get_type();
  Gnome::GdaUI::RawGrid::get_type();
  Gnome::GdaUI::RtEditor::get_type();
  Gnome::GdaUI::ServerOperation::get_type();

} // wrap_init()

} //GdaUI
} //Gnome


