/* GDA common library
 * Copyright (C) 1998 - 2006 The GNOME Foundation.
 *
 * AUTHORS:
 *	Rodrigo Moya <rodrigo@gnome-db.org>
 *      Vivien Malerba <malerba@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gda_util_h__)
#  define __gda_util_h__

#include <glib/ghash.h>
#include <glib/glist.h>
#include "gda-parameter.h"
#include "gda-row.h"
#include "gda-connection.h"

G_BEGIN_DECLS

/*
 * Type utilities
 */
const gchar *gda_type_to_string (GType type);
GType gda_type_from_string (const gchar *str);

GList       *gda_string_hash_to_list (GHashTable *hash_table);

/* 
 * SQL escaping
 */
gchar *gda_default_escape_chars (const gchar *string);
gchar *gda_default_unescape_chars (const gchar *string);

/*
 * SQL parsing utilities
 */

gchar *gda_sql_replace_placeholders (const gchar *sql, GdaParameterList *params);

/*
 * File management utility functions
 */
gchar    *gda_file_load (const gchar *filename);
gboolean  gda_file_save (const gchar *filename, const gchar *buffer, gint len);

/*
 * utilities dealing with storing and retreiving GdaDictField's attributes
 * which is a list of comma separated keywords
 */
gchar *utility_table_field_attrs_stringify (guint attributes);
guint  utility_table_field_attrs_parse     (const gchar *str);

/*
 * XML Id encoding and decoding
 */
gchar *utility_build_encoded_id (const gchar *prefix, const gchar *id);
gchar *utility_build_decoded_id (const gchar *prefix, const gchar *id);

/*
 * Param & model utilities
 */
gboolean utility_check_data_model (GdaDataModel *model, gint nbcols, ...);
void     utility_data_model_dump_data_to_xml (GdaDataModel *model, xmlNodePtr parent, 
					      const gint *cols, gint nb_cols, gboolean use_col_ids);
void     utility_parameter_load_attributes (GdaParameter *param, xmlNodePtr node, GSList *sources);
GdaDictType *utility_find_or_create_data_type (GdaDict *dict, GdaServerProvider *prov, GdaConnection *cnc, 
					       const gchar *dbms_type, const gchar *gda_type, gboolean *created);


G_END_DECLS

#endif
