// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_CLIENT_H
#define _LIBGDAMM_CLIENT_H

#include <glibmm.h>

/* $Id: client.hg,v 1.3 2004/03/30 17:30:01 murrayc Exp $ */
// -*- C++ -*- //

/* client.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/transaction.h>
#include <libgdamm/connection.h>
//#include <libgda/gda-client.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaClient GdaClient;
typedef struct _GdaClientClass GdaClientClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Client_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** @addtogroup libgdammEnums Enums and Flags */

/**
 * @ingroup libgdammEnums
 */
enum ClientEvent
{
  CLIENT_EVENT_INVALID,
  CLIENT_EVENT_ERROR,
  CLIENT_EVENT_CONNECTION_OPENED,
  CLIENT_EVENT_CONNECTION_CLOSED,
  CLIENT_EVENT_TRANSACTION_STARTED,
  CLIENT_EVENT_TRANSACTION_COMMITTED,
  CLIENT_EVENT_TRANSACTION_CANCELLED
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ClientEvent> : public Glib::Value_Enum<Gnome::Gda::ClientEvent>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


class Client : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Client CppObjectType;
  typedef Client_Class CppClassType;
  typedef GdaClient BaseObjectType;
  typedef GdaClientClass BaseClassType;

private:  friend class Client_Class;
  static CppClassType client_class_;

private:
  // noncopyable
  Client(const Client&);
  Client& operator=(const Client&);

protected:
  explicit Client(const Glib::ConstructParams& construct_params);
  explicit Client(GdaClient* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Client();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaClient*       gobj()       { return reinterpret_cast<GdaClient*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaClient* gobj() const { return reinterpret_cast<GdaClient*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaClient* gobj_copy();

private:

protected:
  Client();

public:
  
  static Glib::RefPtr<Client> create();

  
  Glib::RefPtr<Connection> open_connection(const Glib::ustring& dsn, const Glib::ustring& username, const Glib::ustring& password, ConnectionOptions options = (ConnectionOptions)0);
  
  Glib::RefPtr<Connection> open_connection_from_string(const Glib::ustring& provider_id, const Glib::ustring& cnc_string, ConnectionOptions options = (ConnectionOptions)0);
//TODO:  _WRAP_METHOD(const GList   *get_connection_list(), gda_client_get_connection_list)

 //Use a special conversion here, because we should not own any part of the returned GList, and because we need to unconst the GList.:
  

  Glib::ListHandle< Glib::RefPtr<Connection> > get_connection_list();;
  
  Glib::ListHandle< Glib::RefPtr<const Connection> > get_connection_list() const;;
   
  
  Glib::RefPtr<Connection> find_connection(const Glib::ustring& dsn, const Glib::ustring& username, const Glib::ustring& password);
  
  void close_all_connections();

  
  void notify_event(const Glib::RefPtr<Connection>& cnc, ClientEvent event, GdaParameterList *params);
  
  void notify_error_event(const Glib::RefPtr<Connection>& cnc, GdaError *error);
  
  void notify_connection_opened_event(const Glib::RefPtr<Connection>& cnc);
//  _WRAP_METHOD(void notify_connection_closed_event(const Glib::RefPtr<Connection>& cnc), gda_client_notify_connection_closed_event)
  
  void notify_transaction_started_event(const Glib::RefPtr<Connection>& cnc, const Glib::RefPtr<Transaction>& xaction);
  
  void notify_transaction_committed_event(const Glib::RefPtr<Connection>& cnc, const Glib::RefPtr<Transaction>& xaction);
  
  void notify_transaction_cancelled_event(const Glib::RefPtr<Connection>& cnc, const Glib::RefPtr<Transaction>& xaction);


  bool begin_transaction(const Glib::RefPtr<Transaction>& xaction);
  
  bool commit_transaction(const Glib::RefPtr<Transaction>& xaction);
  
  bool rollback_transaction(const Glib::RefPtr<Transaction>& xaction);

  //TODO: Use C++ types:
  //gtkmmproc error: event_notification :  signal defs lookup failed;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::Client
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::Client> wrap(GdaClient* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_CLIENT_H */

